/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    private static final String ourLineEndWhilePasteInString = "\\n\"\n \"";

    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text) {
        if (!(file2.getLanguage() instanceof OCLanguage)) {
            return null;
        }
        Document document2 = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document2 == null) {
            return null;
        }
        boolean isLiteral = true;
        for (int i2 = 0; i2 < startOffsets.length && isLiteral; ++i2) {
            if (OCStringLiteralCopyPasteProcessor.findLiteralTokenType(document2.getCharsSequence(), startOffsets[i2], endOffsets[i2]) != null) continue;
            isLiteral = false;
        }
        return isLiteral ? StringUtil.unescapeStringCharacters((String)text) : null;
    }

    @NotNull
    public String preprocessOnPaste(Project project2, PsiFile file2, Editor editor, String text, RawText rawText) {
        if (!(file2.getLanguage() instanceof OCLanguage)) {
            return text;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        IElementType tokenType = OCStringLiteralCopyPasteProcessor.findLiteralTokenType(editor.getDocument().getCharsSequence(), selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
        if (tokenType == OCTokenTypes.STRING_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                return rawText.rawText;
            }
            StringBuilder buffer = new StringBuilder(text.length());
            String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
            for (int i2 = 0; i2 < lines.length; ++i2) {
                String line = lines[i2];
                buffer.append(StringUtil.escapeStringCharacters((String)line));
                if (i2 == lines.length - 1) continue;
                buffer.append(ourLineEndWhilePasteInString);
            }
            text = buffer.toString();
        } else if (tokenType == OCTokenTypes.CHARACTER_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                return rawText.rawText;
            }
            return OCStringLiteralCopyPasteProcessor.escapeCharCharacters(text);
        }
        return text;
    }

    @Nullable
    private static IElementType findLiteralTokenType(@NotNull CharSequence documentText, int selectionStart, int selectionEnd) {
        OCLexer lexer = new OCLexer(OCLexerSettings.forLanguage(CLanguageKind.maxLanguage()).build());
        lexer.start(documentText);
        IElementType tokenType;
        while ((tokenType = lexer.getTokenType()) != null) {
            if ((tokenType == OCTokenTypes.STRING_LITERAL || tokenType == OCTokenTypes.CHARACTER_LITERAL) && lexer.getTokenStart() < selectionStart && selectionEnd < lexer.getTokenEnd()) {
                return tokenType;
            }
            lexer.advance();
        }
        return null;
    }

    @NotNull
    public static String escapeCharCharacters(@NotNull String s) {
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"'", (StringBuilder)buffer);
        return buffer.toString();
    }
}

