/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation.doxygen.api;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.documentation.doxygen.api.Doxygen;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCommentGroup;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoxygenFacade {
    public static boolean isDoxygenSupported() {
        return ((Doxygen[])Doxygen.EP_NAME.getExtensions()).length > 0;
    }

    @Nullable
    public static DoxygenCommentGroup getCommentGroup(@NotNull PsiElement element) {
        Doxygen[] extensions = (Doxygen[])Doxygen.EP_NAME.getExtensions();
        return extensions.length > 0 ? extensions[0].getCommentGroup(element) : null;
    }

    @NotNull
    public static List<PsiComment> getCommentScope(@NotNull PsiElement element) {
        Doxygen[] extensions = (Doxygen[])Doxygen.EP_NAME.getExtensions();
        return extensions.length > 0 ? extensions[0].getCommentScope(element) : Collections.emptyList();
    }

    public static boolean isDoxygenComment(@NotNull PsiComment comment) {
        if (DoxygenFacade.isDoxygenSupported()) {
            return ((Doxygen[])Doxygen.EP_NAME.getExtensions())[0].isDoxygenComment(comment);
        }
        return false;
    }
}

