/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.contextSensitive;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCContextSensitiveBuilderKt;
import com.jetbrains.cidr.lang.dfa.contextSensitive.ToolwindowConsole;
import com.jetbrains.cidr.lang.legacy.dfa.OCContextSensitiveControlFlowBuilder;
import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.scripts.rml.RMLScript;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ConsoleUI;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.ui.console.EmptyConsole;
import com.jetbrains.sourceglider.ui.console.SystemConsole;
import com.jetbrains.sourceglider.visitors.VisitorImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCSourceGliderService {
    private static final String SCRIPT_PATH = "CidrDFA.rml";
    private static final String LEGACY_SCRIPT_PATH = "../../legacy/dfa/CidrDFALegacy.rml";
    private static final int PROVIDERS_CNT = 4;
    private final List<ManagerInstancesProvider> myProviders = new ArrayList<ManagerInstancesProvider>();
    private final List<VisitorImpl> myVisitors = new ArrayList<VisitorImpl>();
    private final MultiMap<Integer, VisitorRunner> myVisitorRunners = new MultiMap();

    public static OCSourceGliderService getInstance() {
        return (OCSourceGliderService)ServiceManager.getService(OCSourceGliderService.class);
    }

    private static int getIndex(boolean legacy, boolean contextSensitive) {
        return (legacy ? 2 : 0) + (contextSensitive ? 1 : 0);
    }

    private static boolean isLegacy(int index) {
        return (index & 2) != 0;
    }

    public ManagerInstancesProvider getProvider(boolean legacy, boolean contextSensitive) {
        return this.myProviders.get(OCSourceGliderService.getIndex(legacy, contextSensitive));
    }

    public void addVisitorRunner(boolean legacy, boolean contextSensitive, VisitorRunner visitorRunner) {
        this.myVisitorRunners.putValue((Object)OCSourceGliderService.getIndex(legacy, contextSensitive), (Object)visitorRunner);
    }

    public void clearVisitorRunners() {
        this.myVisitorRunners.clear();
    }

    public VisitorImpl getVisitor(boolean legacy, boolean contextSensitive) {
        return this.myVisitors.get(OCSourceGliderService.getIndex(legacy, contextSensitive));
    }

    public OCSourceGliderService() {
        for (int i2 = 0; i2 < 4; ++i2) {
            int index = i2;
            this.myProviders.add(OCSourceGliderService.createProvider(OCSourceGliderService.isLegacy(i2), OCSourceGliderService.logEnabled(), (symbolTable, visitor, options2, threadCallback) -> {
                for (VisitorRunner runner : this.myVisitorRunners.get((Object)index)) {
                    runner.run(options2, threadCallback);
                }
            }, this.myVisitors, new HashMap<Object, Object>()));
        }
    }

    @NotNull
    public static ManagerInstancesProvider createProvider(final boolean isLegacy, final boolean isLogEnabled, final VisitorRunnerEX visitorRunner, final List<VisitorImpl> visitors, Map<Object, Object> options2) {
        ManagerInstancesProvider provider2 = new ManagerInstancesProvider(){

            @Override
            protected UIInstancesProvider createUIInstancesProvider() {
                return isLogEnabled ? new UIInstancesProvider(ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode() ? new SystemConsole() : new ToolwindowConsole(), new ConsoleUI()) : new UIInstancesProvider(new EmptyConsole(), new ConsoleUI(true));
            }

            @Override
            protected void registerVisitors() {
                VisitorImpl visitor = new VisitorImpl(this.symbolTable){

                    @Override
                    public RelationSignature[] getOutputRelations() {
                        return isLegacy ? new OCContextSensitiveControlFlowBuilder(symbolTable, null).getOutputRelations() : OCContextSensitiveBuilderKt.getRelationSignatures(symbolTable).toArray(new RelationSignature[0]);
                    }

                    @Override
                    public void run(Map options2, ThreadCallback threadCallback) {
                        visitorRunner.run(symbolTable, this, options2, threadCallback);
                    }
                };
                this.visitorsManager.addVisitor(visitor);
                visitors.add(visitor);
            }

            @Override
            protected void registerScripts() {
                String path = isLegacy ? OCSourceGliderService.LEGACY_SCRIPT_PATH : OCSourceGliderService.SCRIPT_PATH;
                URL url = OCSourceGliderService.class.getResource(path);
                this.scriptManager.addScript(RMLScript.readScript(path, url, this));
            }
        };
        provider2.startInit(options2);
        provider2.getSymbolTable().setAllowDomainsResize(true);
        return provider2;
    }

    public static boolean logEnabled() {
        return Registry.is((String)"clion.dfa.log");
    }

    @FunctionalInterface
    public static interface VisitorRunnerEX {
        public void run(SymbolTable var1, VisitorImpl var2, Map var3, ThreadCallback var4);
    }

    @FunctionalInterface
    public static interface VisitorRunner {
        public void run(Map var1, ThreadCallback var2);
    }
}

