/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.contextSensitive;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.relations.RelationSignature;
import org.jetbrains.annotations.NotNull;

public class OCDFAUtils {
    public static final Key<Integer> DFA_TIME_LIMIT = Key.create((String)"DFA_TIME_LIMIT");
    public static final int DEFAULT_TIME_LIMIT_IN_SEC = 5;
    private static final Logger LOG = Logger.getInstance((String)OCDFAUtils.class.getName());

    public static long getTimeLimit(@NotNull PsiFile file2) {
        try {
            Integer forcedTimeLimit = (Integer)file2.getUserData(DFA_TIME_LIMIT);
            if (forcedTimeLimit != null && forcedTimeLimit > 0) {
                return Math.multiplyExact(forcedTimeLimit, 1000);
            }
            forcedTimeLimit = (Integer)file2.getProject().getUserData(DFA_TIME_LIMIT);
            if (forcedTimeLimit != null && forcedTimeLimit > 0) {
                return Math.multiplyExact(forcedTimeLimit, 1000);
            }
            int timeLimitFromRegistry = Registry.get((String)"cidr.inspection.dfa.timeout.in.sec").asInteger();
            if (timeLimitFromRegistry > 0) {
                return Math.multiplyExact(timeLimitFromRegistry, 1000);
            }
        }
        catch (ArithmeticException e) {
            LOG.debug("Cannot use preferred TIME_LIMIT. Default one will be used:" + e.getMessage());
            return 5000L;
        }
        LOG.debug("Using default TIME_LIMIT for DFA");
        return 5000L;
    }

    public static class WorkingTimeMeasurer
    implements Disposable {
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        private volatile boolean myTimedOut = false;

        public WorkingTimeMeasurer(long timeoutInMilliseconds) {
            this.myAlarm.addRequest(() -> {
                this.myTimedOut = true;
            }, timeoutInMilliseconds);
        }

        public boolean isTimeOver() {
            return this.myTimedOut;
        }

        public void dispose() {
        }
    }

    public static class DFAException
    extends RuntimeException {
        public DFAException(String message) {
            super(message);
        }
    }

    @FunctionalInterface
    public static interface TuplesConsumer {
        public void addTuple(RelationSignature var1, Attribute ... var2);
    }
}

