/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorInfo;
import org.jetbrains.annotations.NotNull;

public class ShowClangTidyInfoAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(e.getData(CommonDataKeys.PSI_FILE) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        assert (file2 != null);
        try {
            file2.putUserData(ClangTidyAnnotator.COLLECT_DEBUG_INFORMATION, (Object)true);
            ClangTidyAnnotator annotator = new ClangTidyAnnotator();
            ClangTidyAnnotatorInfo info = annotator.collectInformation(file2);
            annotator.doAnnotate(info);
            String debugInformation = (String)file2.getUserData(ClangTidyAnnotator.DEBUG_INFORMATION);
            if (debugInformation == null) {
                return;
            }
            LightVirtualFile outputFile = new LightVirtualFile("Clang-Tidy Info for " + file2.getName(), (FileType)PlainTextFileType.INSTANCE, (CharSequence)debugInformation);
            FileEditorManager.getInstance((Project)file2.getProject()).openFile((VirtualFile)outputFile, false);
        }
        finally {
            file2.putUserData(ClangTidyAnnotator.COLLECT_DEBUG_INFORMATION, null);
            file2.putUserData(ClangTidyAnnotator.DEBUG_INFORMATION, null);
        }
    }
}

