/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.settings;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

@State(name="ClangdSettings", storages={@Storage(value="$WORKSPACE_FILE$"), @Storage(value="other.xml", deprecated=true)})
public class ClangdSettings
implements PersistentStateComponent<StoredState> {
    private static final List<ClangFeatures.Warning> DISABLE_FOR_UnusedInspections = Collections.singletonList(ClangFeatures.Warnings.UNUSED_VARIABLE);
    private static final List<ClangFeatures.Warning> DISABLE_FOR_InfiniteRecursion = Collections.singletonList(ClangFeatures.Warnings.INFINITE_RECURSION);
    private static final List<ClangFeatures.Warning> ENABLE_FOR_HidesUpperScope = Collections.singletonList(ClangFeatures.Warnings.SHADOW);
    private static final List<ClangFeatures.Warning> DISABLE_FOR_FunctionImplicitDeclarationInspection = Collections.singletonList(ClangFeatures.Warnings.IMPLICIT_FUNCTION_DECLARATION);
    private static final String DEFAULT_DISABLED_WARNINGS = ClangdSettings.makeWarningsDisabled(DISABLE_FOR_UnusedInspections, DISABLE_FOR_InfiniteRecursion);
    private static final String DEFAULT_ENABLED_WARNINGS = ClangdSettings.makeWarningsEnabled(ENABLE_FOR_HidesUpperScope, Collections.singletonList(ClangFeatures.Warnings.UNINITIALIZED), Collections.singletonList(ClangFeatures.Warnings.UNUSED_LABEL), Collections.singletonList(ClangFeatures.Warnings.UNUSED_LAMBDA_CAPTURE));
    private static final String DEFAULT_DISABLED_ERRORS = ClangdSettings.makeWarningsAsErrors(DISABLE_FOR_FunctionImplicitDeclarationInspection);
    private static final String DEFAULT_MESSAGE_FILTERS = PluginManagerCore.isRunningFromSources() ? "<-- clionDefinition\n--> reply:clionDefinition\n--> telemetry/event\n<-- clionDebugDumpMemoryStat\n--> reply:clionDebugDumpMemoryStat\nclion-method:clionDefinition\nclion-method:clionDebugDumpMemoryStat\nclion-method:telemetry/event" : "<-- clionDefinition\n--> reply:clionDefinition\n--> telemetry/event\n<-- clionDebugDumpMemoryStat\n--> reply:clionDebugDumpMemoryStat";
    public static final Key<List<String>> DISABLED_WARNINGS = Key.create((String)"DISABLED_WARNINGS");
    @NotNull
    private final Project myProject;
    @NotNull
    private final StoredState myState = new StoredState();

    public ClangdSettings(@NotNull Project project2) {
        this.myProject = project2;
        Registry.get((String)"clion.clang.clangd.on").addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                ClangdSettings.this.setClangdEnabledImpl(value.asBoolean());
            }
        }, (Disposable)project2);
    }

    public static ClangdSettings getInstance(@NotNull Project project2) {
        return (ClangdSettings)ServiceManager.getService((Project)project2, ClangdSettings.class);
    }

    public synchronized boolean isClangdOn() {
        return this.myState.clangdEnabled && (this.myState.clangdShowErrors || this.myState.clangTidyViaClangd || this.myState.navigationViaClangd || this.myState.formatViaClangd || this.myState.completionType != CompletionType.Builtin);
    }

    public synchronized boolean isClangdShowErrors() {
        return this.myState.clangdShowErrors;
    }

    public synchronized void setClangdShowErrors(boolean clangdShowErrors) {
        this.setProperty(value -> {
            this.myState.clangdShowErrors = value;
        }, ClangdSettingsListener::onClangdShowErrorsChanged, this.myState.clangdShowErrors, clangdShowErrors);
    }

    public synchronized boolean isClangTidyViaClangd() {
        return this.myState.clangTidyViaClangd;
    }

    public synchronized void setClangTidyViaClangd(boolean clangTidyViaClangd) {
        this.setProperty(value -> {
            this.myState.clangTidyViaClangd = value;
        }, ClangdSettingsListener::onClangTidyViaClangdChanged, this.myState.clangTidyViaClangd, clangTidyViaClangd);
    }

    public synchronized boolean isNavigationViaClangd() {
        return this.myState.navigationViaClangd;
    }

    public synchronized void setNavigationViaClangd(boolean navigationViaClangd) {
        this.setProperty(value -> {
            this.myState.navigationViaClangd = value;
        }, ClangdSettingsListener::onNavigationViaClangdChanged, this.myState.navigationViaClangd, navigationViaClangd);
    }

    public synchronized boolean isFormatViaClangd() {
        return this.myState.formatViaClangd;
    }

    public synchronized void setFormatViaClangd(boolean formatViaClangd) {
        this.setProperty(value -> {
            this.myState.formatViaClangd = value;
        }, ClangdSettingsListener::onFormatViaClangdChanged, this.myState.formatViaClangd, formatViaClangd);
    }

    public synchronized CompletionType getCompletionType() {
        return this.myState.completionType;
    }

    public synchronized void setCompletionType(CompletionType completionType) {
        this.setProperty(value -> {
            this.myState.completionType = completionType;
        }, ClangdSettingsListener::onCompletionTypeChanged, this.myState.completionType, completionType);
    }

    public synchronized boolean isClangdEnabled() {
        return this.myState.clangdEnabled;
    }

    public synchronized void setClangdEnabled(boolean clangdEnabled) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            CidrLogService.LOG.error("Enabling clangd in production programmatically? It is allowed from Registry only.");
        }
        this.setClangdEnabledImpl(clangdEnabled);
    }

    private synchronized void setClangdEnabledImpl(boolean clangdEnabled) {
        this.setProperty(value -> {
            this.myState.clangdEnabled = value;
        }, ClangdSettingsListener::onClangdEnabled, this.myState.clangdEnabled, clangdEnabled);
    }

    @NotNull
    public synchronized String getClangdMessagesFilters() {
        return StringUtil.notNullize((String)this.myState.clangdMessagesFilters);
    }

    public synchronized void setClangdMessagesFilters(@NotNull String clangdMessagesFilters) {
        this.setProperty(value -> {
            this.myState.clangdMessagesFilters = value;
        }, ClangdSettingsListener::onClangdMessagesFiltersChanged, this.myState.clangdMessagesFilters, clangdMessagesFilters);
    }

    @NotNull
    public synchronized String getClangFlags() {
        return StringUtil.notNullize((String)this.myState.clangWarnings);
    }

    public synchronized void setClangFlags(@NotNull String clangWarnings) {
        this.myState.clangWarnings = clangWarnings;
    }

    @NotNull
    public synchronized StoredState getState() {
        return new StoredState(this.myState);
    }

    public synchronized void loadState(@NotNull StoredState state) {
        this.setClangdShowErrors(state.clangdShowErrors);
        this.setClangTidyViaClangd(state.clangTidyViaClangd);
        this.setNavigationViaClangd(state.navigationViaClangd);
        this.setFormatViaClangd(state.formatViaClangd);
        this.setCompletionType(state.completionType);
        this.setClangFlags(state.clangWarnings);
        this.setClangdMessagesFilters(state.clangdMessagesFilters);
    }

    @NotNull
    private ClangdSettingsListener getPublisher() {
        return (ClangdSettingsListener)this.myProject.getMessageBus().syncPublisher(ClangdSettingsListener.TOPIC);
    }

    public static void rehighlight() {
        Project[] openProjects;
        for (Project project2 : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            PsiManager.getInstance((Project)project2).dropPsiCaches();
        }
    }

    @NotNull
    private static String makeWarningsDisabled(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList<String> args = new ArrayList<String>();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getDisabledOnlyThis());
            }
        }
        return StringUtil.join(args, (String)",");
    }

    @NotNull
    private static String makeWarningsEnabled(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList<String> args = new ArrayList<String>();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getEnabledOnlyThis(false));
            }
        }
        return StringUtil.join(args, (String)",");
    }

    @NotNull
    private static String makeWarningsAsErrors(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList<String> args = new ArrayList<String>();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getEnabledOnlyThis(true));
            }
        }
        return StringUtil.join(args, (String)",");
    }

    private <Type> void setProperty(@NotNull Consumer<Type> propertySetter, @NotNull BiConsumer<ClangdSettingsListener, Type> propertyListener, Type oldValue, Type newValue) {
        if (!Objects.equals(newValue, oldValue)) {
            boolean oldClangdOn = this.isClangdOn();
            propertySetter.accept(newValue);
            propertyListener.accept(this.getPublisher(), newValue);
            boolean newClangOn = this.isClangdOn();
            if (oldClangdOn != newClangOn) {
                this.getPublisher().onClangdOnChanged(newClangOn);
            }
        }
    }

    static /* synthetic */ String access$100() {
        return DEFAULT_DISABLED_WARNINGS;
    }

    static /* synthetic */ String access$200() {
        return DEFAULT_DISABLED_ERRORS;
    }

    static /* synthetic */ String access$300() {
        return DEFAULT_ENABLED_WARNINGS;
    }

    static /* synthetic */ String access$400() {
        return DEFAULT_MESSAGE_FILTERS;
    }

    static class StoredState {
        public boolean clangdShowErrors = !ApplicationManager.getApplication().isUnitTestMode();
        public boolean clangTidyViaClangd = true;
        public boolean navigationViaClangd = true;
        public boolean formatViaClangd = true;
        public CompletionType completionType = ApplicationManager.getApplication().isUnitTestMode() ? CompletionType.Builtin : CompletionType.Clangd;
        public boolean clangdEnabled = Registry.is((String)"clion.clang.clangd.on");
        public String clangWarnings = StringUtil.join(Arrays.asList(ClangdSettings.access$100(), ClangdSettings.access$200(), ClangdSettings.access$300(), ApplicationManager.getApplication().isUnitTestMode() ? "-Wconversion" : null), (String)",");
        public String clangdMessagesFilters = ClangdSettings.access$400();

        StoredState() {
        }

        StoredState(@NotNull StoredState other) {
            this.clangdShowErrors = other.clangdShowErrors;
            this.clangTidyViaClangd = other.clangTidyViaClangd;
            this.navigationViaClangd = other.navigationViaClangd;
            this.formatViaClangd = other.formatViaClangd;
            this.completionType = other.completionType;
            this.clangdEnabled = other.clangdEnabled;
            this.clangWarnings = other.clangWarnings;
            this.clangdMessagesFilters = other.clangdMessagesFilters;
        }
    }

    public static enum CompletionType {
        Builtin(0),
        BuiltinWithClangd(1),
        Clangd(2);

        private final int value;

        private CompletionType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static CompletionType forValue(int value) {
            CompletionType[] allValues = CompletionType.values();
            if (value < 0 || value >= allValues.length) {
                throw new IllegalArgumentException("Illegal enum value: " + value);
            }
            return allValues[value];
        }
    }
}

