/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFileListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WorkspaceFileImpl
implements WorkspaceFile {
    @NotNull
    private final String myUrl;
    @NotNull
    private final WorkspaceFileListener myListener;
    @NotNull
    private final Map<WorkspaceFile.Key<?>, Object> myData = new HashMap();

    protected WorkspaceFileImpl(@NotNull String url, @NotNull WorkspaceFileListener listener) {
        this.myUrl = url;
        this.myListener = listener;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    @Override
    @NotNull
    public Set<WorkspaceFile.Key<?>> keys() {
        return this.myData.keySet();
    }

    @Override
    public <T> T get(@NotNull WorkspaceFile.Key<T> key) {
        return (T)this.myData.get(key);
    }

    @Override
    public <T> T getOrDefault(@NotNull WorkspaceFile.Key<T> key) {
        if (this.hasKey(key)) {
            return this.get(key);
        }
        T result2 = key.createDefaultValue();
        this.put(key, result2);
        return result2;
    }

    @Override
    public <T> void put(@NotNull WorkspaceFile.Key<T> key, T data) {
        this.myData.put(key, data);
        this.myListener.onChanged(this.getUrl(), key, data);
    }

    @Override
    public boolean hasKey(@NotNull WorkspaceFile.Key<?> key) {
        return this.myData.containsKey(key);
    }
}

