/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractClangWorkspace<WF extends WorkspaceFile>
implements ClangWorkspace<WF> {
    @NotNull
    private final ConcurrentHashMap<String, FileAndLock> myUrl2FileStateMap = new ConcurrentHashMap();
    @NotNull
    private final TimeStats myTimeStats = new TimeStats();
    @NotNull
    private final TimeStats myAWTTimeStats = new TimeStats();

    @NotNull
    protected abstract WF createWorkspaceFile(@NotNull String var1);

    @Override
    public List<String> getRegisteredUrls() {
        return new ArrayList<String>(this.myUrl2FileStateMap.keySet());
    }

    @Override
    public void modify(@NotNull String url, @NotNull Consumer<WF> consumer) {
        this.modifyImpl(System.nanoTime(), url, consumer);
    }

    @Override
    public void modifyWithRead(@NotNull String url, @NotNull Consumer<WF> consumer) {
        long opStart = System.nanoTime();
        ReadAction.run(() -> this.modifyImpl(opStart, url, consumer));
    }

    private void modifyImpl(long opStart, @NotNull String url, @NotNull Consumer<WF> consumer) {
        this.applyImpl(opStart, url, (WF wf) -> {
            consumer.accept(wf);
            return 0;
        });
    }

    @Override
    public <T> T apply(@NotNull String url, @NotNull Function<WF, T> consumer) {
        return this.applyImpl(System.nanoTime(), url, consumer);
    }

    @Override
    public <T> T applyWithRead(@NotNull String url, @NotNull Function<WF, T> consumer) {
        long opStart = System.nanoTime();
        return (T)ReadAction.compute(() -> this.applyImpl(opStart, url, consumer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T applyImpl(long opStart, @NotNull String url, @NotNull Function<WF, T> consumer) {
        boolean isDispatchThread = ApplicationManager.getApplication().isDispatchThread();
        FileAndLock fileAndLock = this.getOrCreate(url);
        fileAndLock.lock.lock();
        try {
            this.afterLockEntered(opStart, isDispatchThread);
            T t = consumer.apply(fileAndLock.workspaceFile);
            return t;
        }
        finally {
            fileAndLock.lock.unlock();
            this.afterOperationCompleted(opStart, isDispatchThread);
        }
    }

    @Override
    public void modify(@NotNull List<String> urls, @NotNull Consumer<Map<String, WF>> consumer) {
        this.modifyImpl(System.nanoTime(), urls, consumer);
    }

    @Override
    public void modifyWithRead(@NotNull List<String> urls, @NotNull Consumer<Map<String, WF>> consumer) {
        long opStart = System.nanoTime();
        ReadAction.run(() -> this.modifyImpl(opStart, urls, consumer));
    }

    public void modifyImpl(long opStart, @NotNull List<String> urls, @NotNull Consumer<Map<String, WF>> consumer) {
        this.applyImpl(opStart, urls, (Map<String, WF> wfMap) -> {
            consumer.accept((Map)wfMap);
            return 0;
        });
    }

    @Override
    public <T> T apply(@NotNull List<String> urls, @NotNull Function<Map<String, WF>, T> consumer) {
        return this.applyImpl(System.nanoTime(), urls, consumer);
    }

    @Override
    public <T> T applyWithRead(@NotNull List<String> urls, @NotNull Function<Map<String, WF>, T> consumer) {
        long opStart = System.nanoTime();
        return (T)ReadAction.compute(() -> this.applyImpl(opStart, urls, consumer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T applyImpl(long opStart, @NotNull List<String> urls, @NotNull Function<Map<String, WF>, T> consumer) {
        Iterator<Object> iterator2;
        boolean isDispatchThread = ApplicationManager.getApplication().isDispatchThread();
        ArrayList<String> sortedUrls = new ArrayList<String>(urls);
        sortedUrls.sort(Comparator.naturalOrder());
        HashMap statesMap = new HashMap();
        ArrayList<FileAndLock> fileAndLocks = new ArrayList<FileAndLock>();
        for (String url : sortedUrls) {
            FileAndLock fileAndLock = this.getOrCreate(url);
            fileAndLocks.add(fileAndLock);
            statesMap.put(url, fileAndLock.workspaceFile);
        }
        for (FileAndLock state : fileAndLocks) {
            state.lock.lock();
        }
        try {
            this.afterLockEntered(opStart, isDispatchThread);
            iterator2 = consumer.apply(statesMap);
        }
        catch (Throwable throwable) {
            for (FileAndLock state : fileAndLocks) {
                state.lock.unlock();
            }
            this.afterOperationCompleted(opStart, isDispatchThread);
            throw throwable;
        }
        for (FileAndLock state : fileAndLocks) {
            state.lock.unlock();
        }
        this.afterOperationCompleted(opStart, isDispatchThread);
        return (T)iterator2;
    }

    @Override
    public void clear() {
        this.myUrl2FileStateMap.clear();
    }

    @Override
    @NotNull
    public String printStats(@NotNull String linePrefix) {
        return this.myTimeStats.printStats(linePrefix + "Overall ") + this.myAWTTimeStats.printStats(linePrefix + "AWT ");
    }

    @NotNull
    private FileAndLock getOrCreate(@NotNull String url) {
        return this.myUrl2FileStateMap.computeIfAbsent(url, key -> new FileAndLock((String)key));
    }

    private void afterLockEntered(long opStart, boolean isDispatchThread) {
        this.myTimeStats.afterLockEntered(opStart);
        if (isDispatchThread) {
            this.myAWTTimeStats.afterLockEntered(opStart);
        }
    }

    private void afterOperationCompleted(long opStart, boolean isDispatchThread) {
        this.myTimeStats.afterOperationCompleted(opStart);
        if (isDispatchThread) {
            this.myAWTTimeStats.afterOperationCompleted(opStart);
        }
    }

    private static class TimeStats {
        private final AtomicLong myTotalWaitTimeMicroSecs = new AtomicLong(0L);
        private final AtomicLong myMaxWaitTimeMicroSecs = new AtomicLong(0L);
        private final AtomicLong myTotalOpTimeMicroSecs = new AtomicLong(0L);
        private final AtomicLong myMaxOpTimeMicroSecs = new AtomicLong(0L);
        private final AtomicInteger myNumOfOps = new AtomicInteger(0);

        private TimeStats() {
        }

        private int getAverageWaitTimeMicroSecs() {
            int numOfOps = this.myNumOfOps.get();
            long totalWaitTime = this.myTotalWaitTimeMicroSecs.get();
            return numOfOps > 0 ? Long.valueOf(totalWaitTime / (long)numOfOps).intValue() : 0;
        }

        private int getAverageOpTimeMicroSecs() {
            int numOfOps = this.myNumOfOps.get();
            long totalOpTime = this.myTotalOpTimeMicroSecs.get();
            return numOfOps > 0 ? Long.valueOf(totalOpTime / (long)numOfOps).intValue() : 0;
        }

        private static String renderTimeValue(long valueMicroSecs) {
            return valueMicroSecs > 1000L ? valueMicroSecs / 1000L + "ms" : valueMicroSecs + "\u00b5s";
        }

        final void afterLockEntered(long opStartTime) {
            long currentMaxWaitTime;
            long waitTimeMicroSecs = (System.nanoTime() - opStartTime) / 1000L;
            this.myNumOfOps.incrementAndGet();
            this.myTotalWaitTimeMicroSecs.addAndGet(waitTimeMicroSecs);
            while ((currentMaxWaitTime = this.myMaxWaitTimeMicroSecs.get()) < waitTimeMicroSecs) {
                this.myMaxWaitTimeMicroSecs.compareAndSet(currentMaxWaitTime, waitTimeMicroSecs);
            }
        }

        final void afterOperationCompleted(long opStartTime) {
            long currentMaxOpTime;
            long opTimeMicroSecs = (System.nanoTime() - opStartTime) / 1000L;
            this.myTotalOpTimeMicroSecs.addAndGet(opTimeMicroSecs);
            while ((currentMaxOpTime = this.myMaxOpTimeMicroSecs.get()) < opTimeMicroSecs) {
                this.myMaxOpTimeMicroSecs.compareAndSet(currentMaxOpTime, opTimeMicroSecs);
            }
        }

        final String printStats(@NotNull String linePrefix) {
            return linePrefix + "File registry events: " + this.myNumOfOps.get() + "\n" + linePrefix + "Wait time (avg/max): " + TimeStats.renderTimeValue(this.getAverageWaitTimeMicroSecs()) + " / " + TimeStats.renderTimeValue(this.myMaxWaitTimeMicroSecs.get()) + "\n" + linePrefix + "Operation time (avg/max): " + TimeStats.renderTimeValue(this.getAverageOpTimeMicroSecs()) + " / " + TimeStats.renderTimeValue(this.myMaxOpTimeMicroSecs.get()) + "\n";
        }
    }

    private class FileAndLock {
        @NotNull
        final WF workspaceFile;
        @NotNull
        final Lock lock;

        private FileAndLock(String url) {
            this.workspaceFile = AbstractClangWorkspace.this.createWorkspaceFile(url);
            this.lock = new ReentrantLock();
        }
    }
}

