/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidOpenTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangFileBasedNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import org.eclipse.lsp4j.TextDocumentItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangOpenNotification
extends ClangFileBasedNotification<OpenData> {
    @Nullable
    public static ClangInteractionPromise<ClangOpenNotification> createPromise(@NotNull ClangDaemonContext context2, @NotNull VirtualFile file2, int version) {
        ClangOpenNotification notification = ClangOpenNotification.create(context2, file2, version);
        if (notification == null) {
            return null;
        }
        return new ClangInteractionPromiseImpl.Builder<ClangOpenNotification>(notification).addWriteAccessedProperties(file2.getUrl(), ClangProperty.Content, ClangProperty.SavedFlag, ClangProperty.Ast).create();
    }

    @Nullable
    public static ClangOpenNotification create(@NotNull ClangDaemonContext context2, @NotNull VirtualFile file2, int version) {
        OpenData data = ClangOpenNotification.doPrepare(context2, file2, version);
        return data != null ? new ClangOpenNotification(context2, file2.getUrl(), version, data) : null;
    }

    private ClangOpenNotification(@NotNull ClangDaemonContext context2, @NotNull String url, int version, @NotNull OpenData data) {
        super(context2, url, version, false, data);
    }

    @Override
    protected boolean sendNotificationImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        assert (ws.isClosedRemotely(this.myUrl));
        return ClangOpenNotification.doSend(server, (OpenData)this.myParams);
    }

    @Override
    protected void toNextRemoteState(@NotNull RemoteWorkspaceFile wf, @NotNull OpenData params) {
        super.toNextRemoteState(wf, params);
        wf.put(RemoteWorkspaceFile.IS_OPENED, true);
        wf.put(RemoteWorkspaceFile.IS_SAVED, params.params.isSaved());
        wf.put(RemoteWorkspaceFile.CONTENT, params.params.getTextDocument().getText());
    }

    @Nullable
    static OpenData doPrepare(@NotNull ClangDaemonContext context2, @NotNull VirtualFile file2, int version) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (context2.getProject().isDisposed()) {
            return null;
        }
        String url = file2.getUrl();
        ClangIdeFacade ideFacade = context2.getIdeFacade();
        boolean isFileSaved = !ideFacade.isModified(file2);
        String fileText = ideFacade.getText(file2);
        if (fileText == null) {
            ClangUtils.warnClangd(LOG, "Failed to get text of a file " + url);
            return null;
        }
        return ClangOpenNotification.doPrepare(context2, url, version, fileText, isFileSaved);
    }

    @NotNull
    static OpenData doPrepare(@NotNull ClangDaemonContext context2, @NotNull String url, int version, @NotNull String content, boolean saved) {
        String uri = context2.getUrlConverter().toUri(url);
        TextDocumentItem docItem = new TextDocumentItem(uri, "cpp", version, content);
        ClionDidOpenTextDocumentParams params = new ClionDidOpenTextDocumentParams(docItem, saved, null);
        return new OpenData(context2, url, params);
    }

    static boolean doSend(@NotNull ClangServer server, @NotNull OpenData data) {
        server.clionDidOpen(data.params);
        return true;
    }

    public static class OpenData {
        @NotNull
        public final ClangDaemonContext context;
        @NotNull
        public final String url;
        @NotNull
        public final ClionDidOpenTextDocumentParams params;

        OpenData(@NotNull ClangDaemonContext context2, @NotNull String url, @NotNull ClionDidOpenTextDocumentParams params) {
            this.context = context2;
            this.url = url;
            this.params = params;
        }
    }
}

