/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDFATuple;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangHighlighting;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.CachingSupplier;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClient;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCodeAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDFAInputsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishHighlightingsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishNamehintParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishTidyDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.namehint.ClangNamehintInfo;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ByteToCharOffsetMapBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangClientImpl
implements ClangClient {
    private static final Logger LOG = Logger.getInstance((String)ClangClient.class.getName());
    @NotNull
    private final ClangDaemonContext myContext;

    public ClangClientImpl(@NotNull ClangDaemonContext context2) {
        this.myContext = context2;
    }

    @Override
    public void clionPublishDiagnostics(ClionPublishDiagnosticsParams diagnostics2) {
        ClangParseResponse openedFile = this.findFile(diagnostics2.getUri(), diagnostics2.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == diagnostics2.getVersion());
            openedFile.getDiagnostics().complete(new CachingSupplier<List>(() -> {
                ArrayList<ClangDiagnostic> clangDiagnostics = new ArrayList<ClangDiagnostic>();
                ListIterator<ClionDiagnostic> lspDiagsIter = diagnostics2.getDiagnostics().listIterator();
                while (lspDiagsIter.hasNext()) {
                    ClangDiagnostic diag;
                    ClionDiagnostic lspDiag = lspDiagsIter.next();
                    if (ClangClientImpl.isForMainFile(lspDiag)) {
                        clangDiagnostics.add(this.createClangDiag(lspDiag));
                        continue;
                    }
                    if (lspDiag.getSeverity() != DiagnosticSeverity.Error || (diag = this.createOtherFileDiag(lspDiag, lspDiagsIter)) == null) continue;
                    clangDiagnostics.add(diag);
                }
                return clangDiagnostics;
            }));
        }
    }

    @NotNull
    private ClangDiagnostic createClangDiag(@NotNull ClionDiagnostic lspDiag) {
        List allFixits;
        Range clionRange = lspDiag.getRange();
        List<String> messageAndNotes = ClangClientImpl.splitMessage(lspDiag.getMessage());
        List list = allFixits = lspDiag.getCodeActions() != null ? ContainerUtil.filter(lspDiag.getCodeActions(), ca -> ca != null) : null;
        if (allFixits != null) {
            ClangUrlConverter converter = this.myContext.getUrlConverter();
            for (ClionCodeAction fixit : allFixits) {
                if (fixit.getEdit() == null) continue;
                Map changes = fixit.getEdit().getChanges();
                for (String uri : changes.keySet()) {
                    List textEdits = (List)changes.remove(uri);
                    changes.put(converter.fromUriToUrl(uri), textEdits);
                }
            }
        }
        return new ClangDiagnostic(lspDiag.getCode(), lspDiag.getSource(), ClangClientImpl.makeFirstLetterUpperCase(ClangClientImpl.constructMessage(messageAndNotes)), ClangClientImpl.constructNotes(messageAndNotes), allFixits != null ? ContainerUtil.filter((Collection)allFixits, f -> f.getEdit() != null) : Collections.emptyList(), allFixits != null ? ContainerUtil.filter((Collection)ContainerUtil.map((Collection)allFixits, f -> f.getClionFix()), f -> f != null) : Collections.emptyList(), ClangClientImpl.getHighlightSeverity(lspDiag.getSeverity()), clionRange.getStart().getLine(), clionRange.getStart().getCharacter(), clionRange.getEnd().getLine(), clionRange.getEnd().getCharacter());
    }

    @Nullable
    private ClangDiagnostic createOtherFileDiag(@NotNull ClionDiagnostic errorLspDiag, @NotNull ListIterator<ClionDiagnostic> iter) {
        assert (errorLspDiag.getSeverity() == DiagnosticSeverity.Error);
        assert (!ClangClientImpl.isForMainFile(errorLspDiag));
        ClangDiagnostic candidate = null;
        int errorLine = errorLspDiag.getClionRange().getStart().getLine();
        int errorCharacter = errorLspDiag.getClionRange().getStart().getCharacter();
        while (iter.hasNext()) {
            ClionDiagnostic nextLspDiag = iter.next();
            if (ClangClientImpl.isForMainFile(nextLspDiag) && nextLspDiag.getSeverity() == DiagnosticSeverity.Information) {
                ClangLanguageServiceUtils.ClangNote note;
                List<String> messageAndNotes = ClangClientImpl.splitMessage(nextLspDiag.getMessage());
                assert (messageAndNotes.size() > 0);
                String rawNote = messageAndNotes.get(messageAndNotes.size() - 1);
                if (rawNote.contains("error: ") && (note = ClangLanguageServiceUtils.parseNote(rawNote)) != null && note.line - 1 == errorLine && note.character - 1 == errorCharacter && note.path.contentEquals(errorLspDiag.getClionFilePath())) {
                    if (candidate != null) continue;
                    ClangDiagnostic mainDiag = this.createClangDiag(errorLspDiag);
                    ClangDiagnostic noteDiag = this.createClangDiag(nextLspDiag);
                    candidate = new ClangDiagnostic(noteDiag.getCode(), noteDiag.getSource(), noteDiag.getMessage(), noteDiag.getNotes(), mainDiag.getClangdFixits(), mainDiag.getClionFixits(), HighlightSeverity.ERROR, noteDiag.getStartLine(), noteDiag.getStartColumn(), noteDiag.getEndLine(), noteDiag.getEndColumn());
                    continue;
                }
            }
            iter.previous();
            return candidate;
        }
        return candidate;
    }

    private static boolean isForMainFile(@NotNull ClionDiagnostic diag) {
        return StringUtil.isEmpty((String)diag.getClionFilePath());
    }

    @Override
    public void clionPublishHighlightings(ClionPublishHighlightingsParams highlightings) {
        ClangParseResponse openedFile = this.findFile(highlightings.getUri(), highlightings.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == highlightings.getVersion());
            openedFile.getHighlightings().complete(new CachingSupplier<List>(() -> ContainerUtil.map(highlightings.getHighlightings(), d -> {
                Range clionRange = d.getRange();
                return new ClangHighlighting(d.getType(), clionRange.getStart().getLine(), clionRange.getStart().getCharacter(), clionRange.getEnd().getLine(), clionRange.getEnd().getCharacter());
            })));
        }
    }

    @Override
    public void clionPublishTidyDiagnostics(ClionPublishTidyDiagnosticsParams diagnostics2) {
        this.clionPublishTidyDiagnosticsImpl(diagnostics2, true);
    }

    @Override
    public void clionPublishOurTidyDiagnostics(ClionPublishTidyDiagnosticsParams diagnostics2) {
        this.clionPublishTidyDiagnosticsImpl(diagnostics2, false);
    }

    @Override
    public void clionPublishNamehints(ClionPublishNamehintParams nameHints) {
        ClangParseResponse openedFile = this.findFile(nameHints.getUri(), nameHints.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == nameHints.getVersion());
            CompletableFuture<Supplier<List<ClangNamehintInfo>>> namehintFuture = openedFile.getNamehints();
            namehintFuture.complete(new CachingSupplier<List>(() -> {
                String openedPath = this.myContext.getUrlConverter().fromUri(nameHints.getUri());
                return ContainerUtil.filter(nameHints.getNamehints(), d -> {
                    int res = FileUtil.comparePaths((String)d.getFilePath(), (String)openedPath);
                    return res == 0;
                });
            }));
        }
    }

    @Override
    public void clionPublishDFAInput(ClionPublishDFAInputsParams input) {
        ClangParseResponse openedFile = this.findFile(input.getUri(), input.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == input.getVersion());
            openedFile.getDFAInput().complete(new CachingSupplier<List>(() -> ContainerUtil.map(input.getTuples(), d -> new ClangDFATuple(d.getRelation(), d.getAttributes()))));
        }
    }

    private void clionPublishTidyDiagnosticsImpl(ClionPublishTidyDiagnosticsParams diagnostics2, boolean completeDefaultTidyDiags) {
        ClangParseResponse openedFile = this.findFile(diagnostics2.getUri(), diagnostics2.getVersion());
        if (openedFile != null) {
            assert (openedFile.getVersion() == diagnostics2.getVersion());
            CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> responseFuture = completeDefaultTidyDiags ? openedFile.getTidyDiagnostics() : openedFile.getOurTidyDiagnostics();
            responseFuture.complete(new CachingSupplier<List>(() -> {
                String openedPath = this.myContext.getUrlConverter().fromUri(diagnostics2.getUri());
                ClangUtils.infoClangd(LOG, "Got " + diagnostics2.getClangTidyErrors().size() + " clang-tidy errors before filtering");
                List<ClionClangTidyError> clangTidyErrors = diagnostics2.getClangTidyErrors().stream().filter(ClangClientImpl::isValid).filter(d -> {
                    int res = FileUtil.comparePaths((String)d.getFilePath(), (String)openedPath);
                    ClangUtils.infoClangd(LOG, "Comparing " + d.getFilePath() + " vs " + openedPath + " = " + res);
                    return res == 0;
                }).collect(Collectors.toList());
                ClangUtils.infoClangd(LOG, "Got " + clangTidyErrors.size() + " clang-tidy errors after filtering");
                Map<String, Map<Integer, Integer>> byteToCharOffsetMap = ClangClientImpl.createByteToCharOffset(clangTidyErrors, openedFile);
                return clangTidyErrors.stream().map(tidyError -> ClangClientImpl.createClangTidyDiagnostic(tidyError, byteToCharOffsetMap)).collect(Collectors.toList());
            }));
        }
    }

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics2) {
        throw new UnsupportedOperationException("Standard clangd is no longer supported!");
    }

    public void telemetryEvent(Object object) {
        this.myContext.getTelemetry().onServerTelemetryEvent(object);
    }

    public void showMessage(MessageParams messageParams) {
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        CompletableFuture<MessageActionItem> response = new CompletableFuture<MessageActionItem>();
        response.complete(null);
        return response;
    }

    public void logMessage(MessageParams message) {
        LOG.info("From server: " + message.getMessage());
    }

    @Nullable
    private ClangParseResponse findFile(@NotNull String uri, int version) {
        String vfsUrl = this.myContext.getUrlConverter().fromUriToUrl(uri);
        ClangParseResponse file2 = this.myContext.getLocalWorkspace().apply(vfsUrl, wf -> wf.getPendingParseResponse(version));
        if (file2 == null) {
            ClangUtils.infoClangd(LOG, "Failed to find file to report diagnostics: " + uri);
        }
        return file2;
    }

    @NotNull
    private static Map<String, Map<Integer, Integer>> createByteToCharOffset(@NotNull List<ClionClangTidyError> errors, @NotNull ClangParseResponse openedFile) {
        HashSet<String> unsavedFileUrls = (HashSet<String>)openedFile.getUserData(ClangParseResponse.UNSAVED_FILES);
        unsavedFileUrls = unsavedFileUrls != null ? new HashSet<String>(unsavedFileUrls) : new HashSet();
        unsavedFileUrls.add(openedFile.getUrl());
        Set<String> unsavedFilePaths = unsavedFileUrls.stream().map(url -> VirtualFileManager.extractPath((String)url)).collect(Collectors.toSet());
        ByteToCharOffsetMapBuilder builder2 = new ByteToCharOffsetMapBuilder();
        return builder2.createFor(errors, unsavedFilePaths);
    }

    @NotNull
    private static HighlightSeverity getHighlightSeverity(@NotNull DiagnosticSeverity lspSeverity) {
        switch (lspSeverity) {
            case Error: {
                return HighlightSeverity.ERROR;
            }
            case Warning: {
                return HighlightSeverity.WARNING;
            }
            case Information: {
                return HighlightSeverity.INFORMATION;
            }
            case Hint: {
                return HighlightSeverity.INFORMATION;
            }
        }
        LOG.warn("Unexpected severity: " + lspSeverity);
        return HighlightSeverity.INFORMATION;
    }

    @NotNull
    private static ClangTidyDiagnostic createClangTidyDiagnostic(@NotNull ClionClangTidyError diagnostic, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        List<ClangTidyReplacement> replacements = Collections.emptyList();
        if (diagnostic.getReplacements() != null && !diagnostic.getReplacements().isEmpty()) {
            replacements = diagnostic.getReplacements().stream().map(replacement -> ClangClientImpl.createClangTidyReplacement(replacement, byteToCharOffsetMap)).collect(Collectors.toList());
        }
        int offset = ClangClientImpl.getCharOffset(diagnostic.getFilePath(), diagnostic.getFileOffset(), byteToCharOffsetMap);
        return new ClangTidyDiagnostic(diagnostic.getMessage(), diagnostic.getName(), diagnostic.getFilePath(), offset, replacements, diagnostic.getClionFix());
    }

    @NotNull
    private static ClangTidyReplacement createClangTidyReplacement(@NotNull ClionClangTidyReplacement replacement, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        int beginOffset = ClangClientImpl.getCharOffset(replacement.getFilePath(), replacement.getOffset(), byteToCharOffsetMap);
        int endOffset = ClangClientImpl.getCharOffset(replacement.getFilePath(), replacement.getOffset() + replacement.getLength(), byteToCharOffsetMap);
        return new ClangTidyReplacement(replacement.getFilePath(), replacement.getReplacementText(), beginOffset, endOffset);
    }

    private static boolean isValid(@NotNull ClionClangTidyError diagnostic) {
        return StringUtil.isNotEmpty((String)diagnostic.getName()) && StringUtil.isNotEmpty((String)diagnostic.getFilePath()) && StringUtil.isNotEmpty((String)diagnostic.getMessage()) && diagnostic.getFileOffset() >= 0 && (diagnostic.getReplacements() == null || diagnostic.getReplacements().isEmpty() || diagnostic.getReplacements().stream().allMatch(ClangClientImpl::isValid));
    }

    private static boolean isValid(@NotNull ClionClangTidyReplacement replacement) {
        return StringUtil.isNotEmpty((String)replacement.getFilePath()) && replacement.getLength() >= 0 && replacement.getOffset() >= 0;
    }

    private static int getCharOffset(@NotNull String filePath, int byteOffset, @NotNull Map<String, Map<Integer, Integer>> byteToCharOffsetMap) {
        return byteToCharOffsetMap.getOrDefault(filePath, Collections.emptyMap()).getOrDefault(byteOffset, byteOffset);
    }

    @NotNull
    private static String makeFirstLetterUpperCase(@NotNull String message) {
        if (message.isEmpty()) {
            return message;
        }
        char upperCaseLetter = Character.toUpperCase(message.charAt(0));
        return upperCaseLetter + message.substring(1);
    }

    @NotNull
    private static List<String> splitMessage(@NotNull String message) {
        return Arrays.asList(message.split("\n\n"));
    }

    @NotNull
    private static String constructMessage(@NotNull List<String> messagesAndNotes) {
        String message = messagesAndNotes.get(0);
        if (message.endsWith(" requested here")) {
            return message.substring(0, message.length() - " requested here".length());
        }
        return message;
    }

    @Nullable
    private static List<String> constructNotes(@NotNull List<String> messagesAndNotes) {
        return messagesAndNotes.size() > 1 ? messagesAndNotes.subList(1, messagesAndNotes.size()) : null;
    }
}

