/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProviderListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContextImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdLanguageServiceProvider
implements ClangLanguageServiceProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(ClangdLanguageServiceProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myServiceLock = new Object();
    @Nullable
    private ClangLanguageService myService = null;

    public ClangdLanguageServiceProvider(@NotNull Project project2) {
        this.myProject = project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClangLanguageService getOrStart() {
        Object object = this.myServiceLock;
        synchronized (object) {
            if (this.myService != null) {
                return this.myService;
            }
            this.myService = ClangdLanguageServiceProvider.startImpl(this.myProject);
            if (!this.myProject.isDisposed()) {
                ((ClangLanguageServiceProviderListener)this.myProject.getMessageBus().syncPublisher(ClangLanguageServiceProviderListener.TOPIC)).onServiceStarted(this.myService);
            }
            return this.myService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ClangLanguageService getIfStarted() {
        Object object = this.myServiceLock;
        synchronized (object) {
            return this.myService;
        }
    }

    @NotNull
    private static ClangLanguageService startImpl(@NotNull Project project2) {
        ClangDaemonContextImpl context2 = null;
        try {
            context2 = new ClangDaemonContextImpl.Builder("main", project2).setMessageBus(project2.getMessageBus()).create();
            return ClangdLanguageService.create(context2);
        }
        catch (Throwable thr) {
            if (context2 != null) {
                Disposer.dispose(context2);
            }
            throw thr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClangStopData stop() {
        Object object = this.myServiceLock;
        synchronized (object) {
            ClangStopData clangStopData;
            if (this.myService == null) {
                return ClangStopData.EMPTY;
            }
            ClangLanguageService service = this.myService;
            this.myService = null;
            try {
                clangStopData = service.stop();
            }
            catch (Throwable throwable) {
                if (!this.myProject.isDisposed()) {
                    ((ClangLanguageServiceProviderListener)this.myProject.getMessageBus().syncPublisher(ClangLanguageServiceProviderListener.TOPIC)).onServiceStopped(service);
                }
                throw throwable;
            }
            if (!this.myProject.isDisposed()) {
                ((ClangLanguageServiceProviderListener)this.myProject.getMessageBus().syncPublisher(ClangLanguageServiceProviderListener.TOPIC)).onServiceStopped(service);
            }
            return clangStopData;
        }
    }

    public void dispose() {
        ClangStopData stopData = this.stop();
        try {
            stopData.exitCode.get(450L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.warn((Throwable)ex);
        }
        catch (TimeoutException ex) {
            LOG.info((Throwable)ex);
            stopData.killRunnable.run();
        }
    }
}

