/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdCompletionUtils {
    @NotNull
    public static String getText(@NotNull Document document2, int startOffset, int endOffset) {
        if (startOffset >= 0 && endOffset > startOffset) {
            CharSequence chars = document2.getImmutableCharSequence();
            return chars.subSequence(Math.min(chars.length(), startOffset), Math.min(chars.length(), endOffset)).toString();
        }
        return "";
    }

    @NotNull
    public static String getText(@NotNull Editor editor, int startOffset, int endOffset) {
        return ClangdCompletionUtils.getText(editor.getDocument(), startOffset, endOffset);
    }

    public static boolean hasMatchingSpaceAfterInsertion(@NotNull String insertion, @NotNull Document document2, int endOffset) {
        return insertion.endsWith(" ") && endOffset < document2.getTextLength() && ClangdCompletionUtils.getText(document2, endOffset, endOffset + 1).equals(" ");
    }

    public static void adjustCompletionInLiveTemplateIfNeeded(@NotNull Project project2, @NotNull Editor editor, @NotNull Document document2, @NotNull String insertion, int endOffset) {
        Template currentTemplate = TemplateManager.getInstance((Project)project2).getActiveTemplate(editor);
        if (currentTemplate != null && insertion.endsWith(" ")) {
            document2.replaceString(endOffset - 1, endOffset, (CharSequence)"");
        }
    }

    public static boolean isLiveTemplateNameSegmentCompletion(@NotNull Project project2, @NotNull Editor editor) {
        Template currentTemplate = TemplateManager.getInstance((Project)project2).getActiveTemplate(editor);
        if (currentTemplate == null) {
            return false;
        }
        @Nullable TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
        if (templateState == null) {
            return false;
        }
        return currentTemplate.getSegmentName(templateState.getCurrentVariableNumber()).equals("name");
    }

    public static void reformatCompletion(@NotNull InsertionContext context2, int startOffset, int endOffset) {
        Document document2 = context2.getDocument();
        Project project2 = context2.getProject();
        RangeMarker marker = document2.createRangeMarker(startOffset, endOffset);
        PsiDocumentManager.getInstance((Project)project2).performForCommittedDocument(document2, () -> CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            int _startOffset = marker.getStartOffset();
            int _endOffset = marker.getEndOffset();
            marker.dispose();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
            if (psiFile == null) {
                return;
            }
            if (ExternalFormatProcessor.useExternalFormatter((PsiFile)psiFile)) {
                ExternalFormatProcessor.formatRangeInFile((PsiFile)psiFile, (TextRange)new TextRange(_startOffset, _endOffset), (boolean)true, (boolean)true);
                return;
            }
            OCChangeUtil.reformatTextIfNotInjected(psiFile, _startOffset, _endOffset);
        })));
    }

    public static void reindentCompletion(@NotNull InsertionContext context2, int startOffset) {
        Document document2 = context2.getDocument();
        Project project2 = context2.getProject();
        RangeMarker marker = document2.createRangeMarker(startOffset, startOffset);
        PsiDocumentManager.getInstance((Project)project2).performForCommittedDocument(document2, () -> CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            String indent;
            int _startOffset = marker.getStartOffset();
            marker.dispose();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
            if (psiFile == null) {
                return;
            }
            int startOfLineOffset = document2.getLineStartOffset(document2.getLineNumber(_startOffset));
            String string = indent = ExternalFormatProcessor.useExternalFormatter((PsiFile)psiFile) ? ExternalFormatProcessor.indentLine((PsiFile)psiFile, (int)startOfLineOffset) : OCChangeUtil.indentLineIfNotInjected(psiFile, startOfLineOffset);
            if (indent != null) {
                int startOfTextInLine = CharArrayUtil.shiftForward((CharSequence)document2.getCharsSequence(), (int)startOfLineOffset, (String)" \t");
                document2.replaceString(startOfLineOffset, startOfTextInLine, (CharSequence)indent);
            }
        })));
    }
}

