/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangAnnotatorUtilsKt;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class OurClangTidyInspectionsViaClangdAnnotatorPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(OurClangTidyInspectionsViaClangdAnnotatorPass.class);
    private final PsiFile myFile;
    private final Document myDocument;
    private final HighlightInfoHolder myHolder;
    private int myParsedVersion = -1;

    public OurClangTidyInspectionsViaClangdAnnotatorPass(@NotNull PsiFile file2, @NotNull Document document2) {
        super(file2.getProject(), document2);
        this.myFile = file2;
        this.myDocument = document2;
        this.myHolder = new HighlightInfoHolder(file2, new HighlightInfoFilter[0]);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        this.myHolder.clear();
        this.myParsedVersion = -1;
        if (!this.isAnnotatorPassEnabled() || !ClangAnnotatorUtilsKt.shouldAnnotate(this.myProject, this.myFile)) {
            return;
        }
        VirtualFile virtualFile = this.myFile.getVirtualFile();
        if (virtualFile == null || virtualFile instanceof OCFragmentVirtualFile) {
            return;
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(this.myProject);
        service.runWithParsed(virtualFile, response -> {
            if (response == null) {
                return;
            }
            this.myParsedVersion = response.getVersion();
            CompletableFuture<Supplier<List<ClangTidyDiagnostic>>> future = response.getOurTidyDiagnostics();
            this.waitForFuture(virtualFile, response.getVersion(), future);
        });
    }

    public void doApplyInformationToEditor() {
        if (this.myDocument == null) {
            return;
        }
        if (this.isAnnotatorPassEnabled()) {
            ClangUtils.infoClangd(LOG, () -> {
                VirtualFile virtualFile = this.myFile.getVirtualFile();
                return "Applying our clang-tidy inspections for " + virtualFile.getName() + "[" + this.myParsedVersion + "].";
            });
        }
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>(this.myHolder.size());
        for (int j = 0; j < this.myHolder.size(); ++j) {
            HighlightInfo info = this.myHolder.get(j);
            highlights.add(info);
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myFile.getTextLength(), highlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private void waitForFuture(VirtualFile virtualFile, int curFileVersion, Future<Supplier<List<ClangTidyDiagnostic>>> diagnosticsFuture) {
        try {
            Supplier<List<ClangTidyDiagnostic>> supplier = ClangUtils.waitCancelAware(diagnosticsFuture, Long.MAX_VALUE, "our clang-tidy inspections");
            if (supplier != null) {
                ClangUtils.infoClangd(LOG, "Our clang-tidy inspections for " + virtualFile.getName() + "[" + curFileVersion + "] received.");
                List<ClangTidyDiagnostic> diagnostics2 = supplier.get();
                if (diagnostics2 != null) {
                    ClangTidyAnnotationApplier applier = new ClangTidyAnnotationApplier();
                    applier.applySuccess(this.myFile, diagnostics2, this.myHolder, true);
                }
            } else {
                ClangUtils.infoClangd(LOG, "Our clang-tidy inspections for " + virtualFile.getName() + "[" + curFileVersion + "] are unavailable.");
            }
        }
        catch (ProcessCanceledException ex) {
            ClangUtils.infoClangd(LOG, "Waiting for our clang-tidy inspections for " + virtualFile.getName() + "[" + curFileVersion + "] is cancelled.");
            throw ex;
        }
        catch (ExecutionException ex) {
            ClangUtils.logServerException(LOG, ex.getMessage(), ex);
        }
        catch (TimeoutException ex) {
            ClangUtils.warnClangd(LOG, ex);
        }
    }

    private boolean isAnnotatorPassEnabled() {
        return ClangUtils.isClangdOn(this.myProject) && ClangUtils.isClangTidyViaClangdOn(this.myProject);
    }
}

