/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultFuture;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultFutureImpl;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangResultImpl<T>
implements ClangResult<T> {
    @NotNull
    private final String myName;
    @NotNull
    private final CompletableFuture<T> myFuture;
    @Nullable
    private Runnable myDoneRunnable;

    public ClangResultImpl(@NotNull String name, @NotNull CompletableFuture<T> future) {
        this(name, future, () -> {});
    }

    public ClangResultImpl(@NotNull String name, @NotNull CompletableFuture<T> future, @NotNull Runnable doneRunnable) {
        this.myName = name;
        this.myFuture = future;
        this.myDoneRunnable = doneRunnable;
    }

    @Override
    @Nullable
    public T waitForResult() throws ExecutionException {
        assert (this.myDoneRunnable != null) : "Already has been converted to the result future or released!";
        return ClangUtils.waitCancelAware(this.myFuture, this.myName);
    }

    @Override
    @Nullable
    public T waitForResult(long timeoutMs) throws ExecutionException, TimeoutException {
        assert (this.myDoneRunnable != null) : "Already has been converted to the result future or released!";
        return ClangUtils.waitCancelAware(this.myFuture, timeoutMs, this.myName);
    }

    @Override
    @NotNull
    public ClangResultFuture<T> iWillNotForgetToCancelTheFuture() {
        assert (this.myDoneRunnable != null) : "Already has been converted to the result future or released!";
        ClangResultFutureImpl<T> asResultFuture = new ClangResultFutureImpl<T>(this.myFuture, this.myDoneRunnable);
        this.myDoneRunnable = null;
        return asResultFuture;
    }

    public void release() {
        if (this.myDoneRunnable != null) {
            this.myDoneRunnable.run();
            this.myDoneRunnable = null;
        }
    }
}

