/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.switchHeaderSource;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSDebugListener;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSHandlerImpl;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSDebugAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "calcAllFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "checkFile", "file", "processed", "Ljava/util/concurrent/atomic/AtomicInteger;", "total", "", "processProject", "intellij.c"})
public final class OCSwitchHSDebugAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        this.processProject(project3);
    }

    private final void processProject(Project project2) {
        List<VirtualFile> files = this.calcAllFiles(project2);
        int nThreads = 8;
        ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
        int total = files.size();
        AtomicInteger processed = new AtomicInteger(0);
        for (VirtualFile file2 : files) {
            if (!OCLanguageUtils.isSupported(file2)) continue;
            executorService.submit(new Runnable(this, file2, project2, processed, total){
                final /* synthetic */ OCSwitchHSDebugAction this$0;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ Project $project;
                final /* synthetic */ AtomicInteger $processed;
                final /* synthetic */ int $total;

                public final void run() {
                    OCSwitchHSDebugAction.access$checkFile(this.this$0, this.$file, this.$project, this.$processed, this.$total);
                }
                {
                    this.this$0 = oCSwitchHSDebugAction;
                    this.$file = virtualFile;
                    this.$project = project2;
                    this.$processed = atomicInteger;
                    this.$total = n;
                }
            });
        }
    }

    private final List<VirtualFile> calcAllFiles(Project project2) {
        boolean bl = false;
        List result2 = new ArrayList();
        FileBasedIndex.getInstance().iterateIndexableFiles(new ContentIterator(project2, result2){
            final /* synthetic */ Project $project;
            final /* synthetic */ List $result;

            public final boolean processFile(@NotNull VirtualFile it) {
                if (OCSearchScope.isInProjectSources(this.$project, it) && OCLanguageUtils.isSupported(it)) {
                    this.$result.add(it);
                }
                return true;
            }
            {
                this.$project = project2;
                this.$result = list;
            }
        }, project2, (ProgressIndicator)new EmptyProgressIndicator());
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFile(VirtualFile file2, Project project2, AtomicInteger processed, int total) {
        String string;
        OCSwitchHSDebugListener sink = new OCSwitchHSDebugListener();
        OCSwitchHSHandlerImpl handler = new OCSwitchHSHandlerImpl(file2, project2);
        handler.invoke(sink);
        List<VirtualFile> result2 = sink.getResult().get();
        switch (result2.size()) {
            case 0: {
                string = "S1";
                break;
            }
            case 1: {
                string = "S0";
                break;
            }
            default: {
                void $this$groupByTo$iv$iv;
                Iterable $this$groupBy$iv = result2;
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    VirtualFile it = (VirtualFile)element$iv$iv;
                    boolean bl = false;
                    String key$iv$iv = it.getCanonicalPath();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                string = destination$iv$iv.size() == 1 ? "S2" : "S3";
            }
        }
        String severity = string;
        processed.incrementAndGet();
        if (Intrinsics.areEqual((Object)severity, (Object)"S3")) {
            String string2 = "" + '[' + processed.get() + '/' + total + "]: " + file2 + ' ' + result2 + ' ' + severity;
            boolean bl = false;
            System.out.println((Object)string2);
        }
    }

    public static final /* synthetic */ void access$checkFile(OCSwitchHSDebugAction $this, VirtualFile file2, Project project2, AtomicInteger processed, int total) {
        $this.checkFile(file2, project2, processed, total);
    }
}

