/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCTestFramework;
import com.jetbrains.cidr.lang.OCTestLineMarkInfo;
import com.jetbrains.cidr.lang.navigation.OCLineMarkerProvider;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTestFrameworks {
    private static final ThreadLocal<Boolean> ourCanWaitInThisThread = new ThreadLocal();

    @NotNull
    public static List<OCTestFramework> getFrameworks() {
        return OCTestFramework.EP_NAME.getExtensionList();
    }

    public static boolean isTestClassOrStruct(@Nullable OCSymbol clazz, @Nullable PsiElement element, @NotNull Project project2) {
        for (OCTestFramework each : OCTestFrameworks.getFrameworks()) {
            if (!each.isTestClassOrStruct(clazz, element, project2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTestMethodOrFunction(@Nullable OCSymbol method, @Nullable PsiElement element, @NotNull Project project2) {
        for (OCTestFramework each : OCTestFrameworks.getFrameworks()) {
            if (!each.isTestMethodOrFunction(method, element, project2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTestNamespace(@Nullable OCNamespaceSymbol namespaceSymbol, @Nullable PsiElement element, @NotNull Project project2) {
        for (OCTestFramework each : OCTestFrameworks.getFrameworks()) {
            if (!each.isTestNamespace(namespaceSymbol, element, project2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTestGlobalVar(@Nullable OCDeclaratorSymbol varSymbol, @Nullable PsiElement element, @NotNull Project project2) {
        for (OCTestFramework each : OCTestFrameworks.getFrameworks()) {
            if (!each.isTestGlobalVar(varSymbol, element, project2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static OCTestLineMarkInfo getTestLineMarkInfo(@Nullable PsiElement e) {
        PsiElement idOwner = OCLineMarkerProvider.getOwnerById(e);
        if (idOwner != null) {
            for (OCTestFramework each : OCTestFrameworks.getFrameworks()) {
                OCTestLineMarkInfo info = each.getTestLineMarkInfo(idOwner);
                if (info == null) continue;
                return info;
            }
        }
        return null;
    }

    public static <T> T executeWithCachedValuesFast(@NotNull Supplier<T> producer) {
        return OCTestFrameworks.execute(producer, false);
    }

    public static <T> T executeWithRealValuesSlow(@NotNull Supplier<T> producer) {
        return OCTestFrameworks.execute(producer, true);
    }

    private static <T> T execute(@NotNull Supplier<T> producer, boolean canWait) {
        assert (ourCanWaitInThisThread.get() == null);
        ourCanWaitInThisThread.set(canWait);
        try {
            T t = producer.get();
            return t;
        }
        finally {
            ourCanWaitInThisThread.remove();
        }
    }

    public static boolean canWaitInThisThread() {
        Boolean canWait = ourCanWaitInThisThread.get();
        if (canWait != null) {
            return canWait;
        }
        Application application = ApplicationManager.getApplication();
        return !application.isDispatchThread() || application.isUnitTestMode();
    }
}

