/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.jetbrains.cidr.lang.OCExperimentalInterner;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class OCInterner<T>
extends Interner<T> {
    private static final boolean isExperimental = Boolean.getBoolean("cidr.memory.efficient.interner");
    private final ConcurrentMap<T, T> myCache = isExperimental ? null : ContainerUtil.createConcurrentWeakKeyWeakValueMap();
    private final OCExperimentalInterner<T> myExperimentalInterner = isExperimental ? new OCExperimentalInterner() : null;

    @NotNull
    public T intern(@NotNull T value) {
        if (isExperimental) {
            return this.myExperimentalInterner.intern(value);
        }
        Object internedValue = this.myCache.get(value);
        if (internedValue != null) {
            return (T)internedValue;
        }
        T valueToIntern = this.valueToStore(value);
        return (T)ConcurrencyUtil.cacheOrGet(this.myCache, valueToIntern, valueToIntern);
    }

    public void clear() {
        if (isExperimental) {
            this.myExperimentalInterner.clear();
        } else {
            this.myCache.clear();
        }
    }

    @NotNull
    public Set<T> getValues() {
        if (isExperimental) {
            return this.myExperimentalInterner.getValues();
        }
        return new HashSet(this.myCache.values());
    }

    @NotNull
    protected T valueToStore(@NotNull T original) {
        return original;
    }
}

