/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelper;
import com.jetbrains.cidr.lang.OCLanguageKind;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCFileTypeHelpers {
    private static final Logger LOG = Logger.getInstance((String)("#" + OCFileTypeHelpers.class.getPackage().getName()));
    private static final Map<String, ExtensionDescriptor> EXTENSIONS = new Object2ObjectOpenHashMap();
    private static final Set<String> HEADER_EXTENSIONS;
    private static final Set<String> SOURCE_EXTENSIONS;
    private static final Set<String> ALL_EXTENSIONS;
    private static final Set<String> OBJ_EXTENSIONS;

    @NotNull
    public static List<OCFileTypeHelper> getHelpers() {
        return OCFileTypeHelper.EP_NAME.getExtensionsIfPointIsRegistered();
    }

    @Nullable
    private static ExtensionDescriptor getDescriptor(@NotNull String extension) {
        String lower = extension.toLowerCase(Locale.getDefault());
        ExtensionDescriptor descriptor = EXTENSIONS.get(lower);
        if (lower.equals(extension) || descriptor != null && !descriptor.myIsCaseSensitive) {
            return descriptor;
        }
        return EXTENSIONS.get(extension);
    }

    public static boolean isHeaderFile(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        ExtensionDescriptor descriptor = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        if (descriptor != null) {
            return descriptor.myIsHeader;
        }
        for (OCFileTypeHelper each : OCFileTypeHelpers.getHelpers()) {
            if (!each.isHeaderFile(filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSourceFile(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        ExtensionDescriptor descriptor = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        if (descriptor != null) {
            return !descriptor.myIsHeader;
        }
        for (OCFileTypeHelper each : OCFileTypeHelpers.getHelpers()) {
            if (each.isHeaderFile(filename)) {
                return false;
            }
            if (!each.isSourceFile(filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKnownFileType(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        return OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename)) != null;
    }

    @Nullable
    public static OCLanguageKind getLanguageKind(@Nullable String filename) {
        if (filename == null) {
            return null;
        }
        ExtensionDescriptor descriptor = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        return descriptor != null ? descriptor.myLanguageKind : null;
    }

    @Nullable
    public static OCLanguageKind getLanguageKindStrict(@Nullable String filename) {
        if (filename == null) {
            return null;
        }
        ExtensionDescriptor descriptor = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        return descriptor != null && !descriptor.myIsAmbiguous ? descriptor.myLanguageKind : null;
    }

    public static boolean isCppFile(@Nullable String filename) {
        OCLanguageKind kind = OCFileTypeHelpers.getLanguageKind(filename);
        return kind != null && kind.isCpp();
    }

    public static boolean isCudaFile(@Nullable String filename) {
        OCLanguageKind kind = OCFileTypeHelpers.getLanguageKind(filename);
        return kind != null && kind.isCuda();
    }

    private static Set<String> collectExtensions(Predicate<? super Map.Entry<String, ExtensionDescriptor>> predicate) {
        Set extensionsSet = CollectionFactory.createCaseInsensitiveStringSet();
        return EXTENSIONS.entrySet().stream().filter(predicate).map(entry -> ((String)entry.getKey()).toLowerCase(Locale.getDefault())).collect(Collectors.toCollection(() -> extensionsSet));
    }

    public static Set<String> headerExtensions() {
        return HEADER_EXTENSIONS;
    }

    public static Set<String> sourceExtensions() {
        return SOURCE_EXTENSIONS;
    }

    public static Set<String> allExtensions() {
        return ALL_EXTENSIONS;
    }

    public static Set<String> objExtensions() {
        return OBJ_EXTENSIONS;
    }

    static {
        try {
            EXTENSIONS.put("c", new ExtensionDescriptor(CLanguageKind.C, false, true));
            EXTENSIONS.put("i", new ExtensionDescriptor(CLanguageKind.C, false));
            EXTENSIONS.put("h", new ExtensionDescriptor(CLanguageKind.C, true, true, true));
            EXTENSIONS.put("inl", new ExtensionDescriptor(CLanguageKind.C, true));
            EXTENSIONS.put("", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("ii", new ExtensionDescriptor(CLanguageKind.CPP, false));
            EXTENSIONS.put("cc", new ExtensionDescriptor(CLanguageKind.CPP, false));
            EXTENSIONS.put("cp", new ExtensionDescriptor(CLanguageKind.CPP, false));
            EXTENSIONS.put("cxx", new ExtensionDescriptor(CLanguageKind.CPP, false));
            EXTENSIONS.put("cpp", new ExtensionDescriptor(CLanguageKind.CPP, false));
            EXTENSIONS.put("c++", new ExtensionDescriptor(CLanguageKind.CPP, false));
            EXTENSIONS.put("hh", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("hp", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("hxx", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("hpp", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("h++", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("tcc", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("tpp", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("icc", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("ipp", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("ino", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("pch", new ExtensionDescriptor(CLanguageKind.CPP, true));
            EXTENSIONS.put("cu", new ExtensionDescriptor(CUDALanguageKind.CUDA, false));
            EXTENSIONS.put("cuh", new ExtensionDescriptor(CUDALanguageKind.CUDA, true));
            EXTENSIONS.put("m", new ExtensionDescriptor(CLanguageKind.OBJ_C, false, true));
            EXTENSIONS.put("mm", new ExtensionDescriptor(CLanguageKind.OBJ_CPP, false));
            EXTENSIONS.put("C", new ExtensionDescriptor(CLanguageKind.CPP, false, true));
            EXTENSIONS.put("H", new ExtensionDescriptor(CLanguageKind.CPP, true, true));
            EXTENSIONS.put("M", new ExtensionDescriptor(CLanguageKind.OBJ_CPP, false, true));
            HEADER_EXTENSIONS = Collections.unmodifiableSet(OCFileTypeHelpers.collectExtensions(entry -> ((ExtensionDescriptor)entry.getValue()).myIsHeader));
            SOURCE_EXTENSIONS = Collections.unmodifiableSet(OCFileTypeHelpers.collectExtensions(entry -> !((ExtensionDescriptor)entry.getValue()).myIsHeader));
            ALL_EXTENSIONS = Collections.unmodifiableSet(OCFileTypeHelpers.collectExtensions(entry -> true));
            OBJ_EXTENSIONS = SetsKt.setOf((Object[])new String[]{"", "o", "obj", "so", "bin", "elf", "exe", "lib", "a", "dll", "axf", "prx", "puff", "ko", "mod", "COM", "dylib", "bundle", "acm", "ax", "cpl", "drv", "efi", "mui", "ocx", "scr", "sys", "tsp"});
        }
        catch (Throwable e) {
            try {
                LOG.error(e);
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    private static class ExtensionDescriptor {
        @NotNull
        public final OCLanguageKind myLanguageKind;
        public final boolean myIsHeader;
        public final boolean myIsCaseSensitive;
        public final boolean myIsAmbiguous;

        ExtensionDescriptor(@NotNull OCLanguageKind languageKind, boolean isHeader, boolean isCaseSensitive, boolean isAmbiguous) {
            this.myLanguageKind = languageKind;
            this.myIsHeader = isHeader;
            this.myIsCaseSensitive = isCaseSensitive;
            this.myIsAmbiguous = isAmbiguous;
        }

        ExtensionDescriptor(@NotNull OCLanguageKind languageKind, boolean isHeader, boolean isCaseSensitive) {
            this(languageKind, isHeader, isCaseSensitive, false);
        }

        ExtensionDescriptor(@NotNull OCLanguageKind languageKind, boolean isHeader) {
            this(languageKind, isHeader, false);
        }
    }
}

