/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestInfoForFile;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsFramework;
import com.jetbrains.cidr.lang.OCTestFramework;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u0012\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/execution/testing/CidrShowTestInfoForProject;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getTestInfoTxt", "Lkotlin/Pair;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "update", "intellij.cidr.common"})
public final class CidrShowTestInfoForProject
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(AnAction.getEventProject((AnActionEvent)e) != null);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void builder2;
        Project project2 = AnAction.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Pair<StringBuilder, String> pair = this.getTestInfoTxt(project3);
        StringBuilder stringBuilder = (StringBuilder)pair.component1();
        String title = (String)pair.component2();
        LightVirtualFile infoFile = new LightVirtualFile(title, (FileType)PlainTextFileType.INSTANCE, (CharSequence)builder2);
        infoFile.setWritable(false);
        FileEditorManager.getInstance((Project)project3).openFile((VirtualFile)infoFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<StringBuilder, String> getTestInfoTxt(Project project2) {
        StringBuilder topBuilder = new StringBuilder();
        String title = "Tests in '" + project2.getName() + "' project\n";
        topBuilder.append(title);
        for (OCTestFramework framework : OCTestFrameworks.getFrameworks()) {
            StringBuilder builder2 = new StringBuilder();
            if (!(framework instanceof CidrTestFrameworkBase)) continue;
            builder2.append("\nFramework '" + ((CidrTestFrameworkBase)framework).getFrameworkId() + "':");
            HashMap<VirtualFile, CidrTestInfoForFile> testCache = ((CidrTestFrameworkBase)framework).getIndexedTests(project2);
            int testCount = 0;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (testCache) {
                boolean bl3 = false;
                for (VirtualFile vf : testCache.keySet()) {
                    CidrTestInfoForFile cidrTestInfoForFile = testCache.get(vf);
                    if (cidrTestInfoForFile == null || cidrTestInfoForFile.getFrameworkVersion() == CidrTestFrameworkVersion.NOT_AVAILABLE || !(framework instanceof CidrTestWithScopeElementsFramework)) continue;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    synchronized (cidrTestInfoForFile) {
                        boolean bl6 = false;
                        Map testMap = (Map)((CidrTestWithScopeElementsFramework)framework).myObjects.get((UserDataHolder)cidrTestInfoForFile);
                        if (testMap != null && !testMap.isEmpty()) {
                            builder2.append("\n  " + vf.getPath());
                            HashSet<String> configurationNames = new HashSet<String>();
                            for (String testName : CollectionsKt.toSortedSet((Iterable)testMap.keySet())) {
                                String configurationName;
                                CidrTestScopeElement cidrTestScopeElement = (CidrTestScopeElement)testMap.get(testName);
                                if (cidrTestScopeElement == null || !cidrTestScopeElement.isTest()) continue;
                                String string = cidrTestScopeElement.getConfigurationName();
                                if (string == null) {
                                    string = "(null)";
                                }
                                if (configurationNames.contains(configurationName = string)) continue;
                                builder2.append("\n    " + configurationName);
                                configurationNames.add(configurationName);
                            }
                            builder2.append("\n    test count:" + configurationNames.size());
                            if (((CidrTestFrameworkBase)framework).isPotentialTestHolderRoot(project2).value((Object)vf)) {
                                testCount += configurationNames.size();
                            } else {
                                builder2.append("\n    the file is not the source file, tests will be counted from source.");
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            builder2.append("\n  test count:" + testCount);
            if (testCount <= 0) continue;
            topBuilder.append((CharSequence)builder2);
        }
        return new Pair((Object)topBuilder, (Object)title);
    }
}

