/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import com.jetbrains.cidr.execution.debugger.memory.MemoryAddressGutterProvider;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class MemoryViewFileEditorProvider
implements FileEditorProvider,
DumbAware {
    private final FileEditorProvider myDelegate = new PsiAwareTextEditorProvider();

    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
        return file2 instanceof MemoryViewFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        FileEditor fileEditor = this.myDelegate.createEditor(project2, file2);
        if (fileEditor instanceof TextEditor && file2 instanceof MemoryViewFile) {
            this.setupMemoryViewEditor(project2, (MemoryViewFile)file2, (TextEditor)fileEditor);
        }
        return fileEditor;
    }

    protected void setupMemoryViewEditor(@NotNull Project project2, @NotNull MemoryViewFile file2, @NotNull TextEditor fileEditor) {
        CidrMemoryDoc<?> memoryDoc = file2.getMemoryDoc();
        if (memoryDoc == null) {
            return;
        }
        Editor editor = fileEditor.getEditor();
        editor.getSettings().setGutterIconsShown(false);
        editor.getSettings().setLineMarkerAreaShown(false);
        editor.getSettings().setLineNumbersShown(false);
        MemoryAddressGutterProvider gutterProvider = new MemoryAddressGutterProvider(memoryDoc);
        final EditorGutterComponentEx gutter = (EditorGutterComponentEx)editor.getGutter();
        gutter.registerTextAnnotation((TextAnnotationGutterProvider)gutterProvider, (EditorGutterAction)gutterProvider);
        gutter.setCanCloseAnnotations(false);
        final GotoAddressPanel gotoAddressPanel = GotoAddressPanel.createFor(editor, ((EditorImpl)editor).getDisposable(), memoryDoc);
        if (gotoAddressPanel != null) {
            fileEditor.putUserData(GotoAddressPanel.GOTO_ADDRESS_FILE_EDITOR_KEY, (Object)gotoAddressPanel);
            gutter.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    gotoAddressPanel.setSeparatorOffset(gutter.getWhitespaceSeparatorOffset());
                }
            });
            ApplicationManager.getApplication().invokeLater(() -> {
                FileEditorManager.getInstance((Project)project2).addTopComponent((FileEditor)fileEditor, (JComponent)((Object)gotoAddressPanel));
                gutter.revalidate();
            });
        }
    }

    @NotNull
    public String getEditorTypeId() {
        return "memory-view";
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project2, @NotNull VirtualFile file2) {
        return this.myDelegate.readState(element, project2, file2);
    }

    public void writeState(@NotNull FileEditorState _state, @NotNull Project project2, @NotNull Element element) {
        this.myDelegate.writeState(_state, project2, element);
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

