/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpaceKt;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.InternalMutableIntervalMap;
import com.jetbrains.cidr.execution.debugger.memory.Interval;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0096\u0002J\u0011\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JP\u0010\u001a\u001aB\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00030\u0003 \u001b* \u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\b0\b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/IntervalTreeMap;", "Ljava/util/TreeMap;", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "Lcom/jetbrains/cidr/execution/debugger/memory/Interval;", "Lcom/jetbrains/cidr/execution/debugger/memory/InternalMutableIntervalMap;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "map", "Ljava/util/NavigableMap;", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Ljava/util/NavigableMap;)V", "intervals", "", "getIntervals", "()Ljava/util/Collection;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "contains", "", "interval", "get", "address", "put", "remove", "", "removeAll", "span", "subMapView", "kotlin.jvm.PlatformType", "rangeSpan", "intellij.cidr.debugger"})
final class IntervalTreeMap
extends TreeMap<Address, Interval>
implements InternalMutableIntervalMap {
    @NotNull
    private final AddressRange range;

    @Override
    @NotNull
    public Collection<Interval> getIntervals() {
        return this.values();
    }

    @Override
    @NotNull
    public Interval get(@NotNull Address address) {
        return (Interval)this.floorEntry(AddressSpaceKt.access$requireAddressInArena(this, address)).getValue();
    }

    @Override
    @NotNull
    public InternalMutableIntervalMap get(@NotNull AddressRange range) {
        AddressRange rangeSpan = this.span(range);
        IntervalTreeMap intervalTreeMap = new IntervalTreeMap(rangeSpan, this.subMapView(rangeSpan));
        boolean bl = false;
        boolean bl2 = false;
        IntervalTreeMap it = intervalTreeMap;
        boolean bl3 = false;
        boolean bl4 = !it.isEmpty();
        boolean bl5 = false;
        boolean bl6 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean bl7 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return intervalTreeMap;
    }

    @Override
    public boolean contains(@NotNull Interval interval) {
        return Intrinsics.areEqual((Object)((Interval)this.get((Object)interval.getRange().getStart())), (Object)interval);
    }

    @Override
    @NotNull
    public AddressRange span(@NotNull AddressRange range) {
        Address address;
        Address start;
        AddressSpaceKt.access$requireAddressRangeIntersectsArena(this, range);
        Address address2 = this.floorKey(range.getStart());
        if (address2 == null) {
            address2 = start = this.getRange().getStart();
        }
        if ((address = this.higherKey(range.getEndInclusive())) == null || (address = address.minus(1)) == null) {
            address = this.getRange().getEndInclusive();
        }
        Address endInclusive = address;
        return (AddressRange)AddressUtil.checkNotEmpty((ClosedRange)AddressUtil.addressRangeInclusive(start, endInclusive));
    }

    private final NavigableMap<Address, Interval> subMapView(AddressRange rangeSpan) {
        return this.subMap(rangeSpan.getStart(), true, rangeSpan.getEndInclusive(), true);
    }

    @Override
    public void removeAll(@NotNull AddressRange range) {
        this.subMapView(this.span(range)).clear();
    }

    @Override
    public void remove(@NotNull Interval interval) {
        Object object = this.remove((Object)interval.getRange().getStart());
        boolean bl = false;
        boolean bl2 = false;
        Interval oldInterval = (Interval)object;
        boolean bl3 = false;
        boolean bl4 = Intrinsics.areEqual((Object)oldInterval, (Object)interval);
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Removed unexpected interval " + oldInterval;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    @Nullable
    public Interval put(@NotNull Interval interval) {
        AddressRange range = interval.getRange();
        Address start = range.getStart();
        boolean bl = this.getRange().contains(range);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Interval must be allocated within arena range";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Interval interval2 = this.put(start, interval);
        bl2 = false;
        bl3 = false;
        Interval oldInterval = interval2;
        boolean bl5 = false;
        boolean bl6 = oldInterval == null || oldInterval.getRange().contains(range);
        boolean bl7 = false;
        boolean bl8 = false;
        if (!bl6) {
            boolean bl9 = false;
            String string = "Attempting unsafe region replacement";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (start.compareTo(this.getRange().getStart()) > 0) {
            bl6 = Intrinsics.areEqual((Object)((Interval)this.get((Object)start.minus(1))).getRange().getEndInclusive(), (Object)start.minus(1));
            bl7 = false;
            bl8 = false;
            if (!bl6) {
                boolean bl10 = false;
                String string = "New region put next to a hole (must be adjacent)";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        bl6 = (Interval)this.get((Object)range.getEndInclusive()) == interval;
        bl7 = false;
        bl8 = false;
        if (!bl6) {
            boolean bl11 = false;
            String string = "New region overlaps a subsequent";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return interval2;
    }

    @Override
    @NotNull
    public AddressRange getRange() {
        return this.range;
    }

    public IntervalTreeMap(@NotNull AddressRange range, @NotNull NavigableMap<Address, Interval> map2) {
        super((SortedMap)map2);
        this.range = range;
    }

    public /* synthetic */ IntervalTreeMap(AddressRange addressRange, NavigableMap navigableMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            navigableMap = AddressSpaceKt.access$getEMPTY_NAVIGABLE_MAP$p();
        }
        this(addressRange, navigableMap);
    }
}

