/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallback;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrLocalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrNumberValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.ValuePresentationKt;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CachedDebuggerResult;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import icons.CidrDebuggerIcons;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrPhysicalValue
extends CidrValue {
    public static final Key THROW_ON_TYPE = Key.create((String)"THROW_ON_TYPE");
    public static final Key THROW_ON_ICON = Key.create((String)"THROW_ON_ICON");
    public static final Key THROW_ON_VALUE = Key.create((String)"THROW_ON_VALUE");
    public static final Key THROW_ON_VAR_DATA = Key.create((String)"THROW_ON_VAR_DATA");
    public static final Key THROW_ON_HAS_CHILDREN = Key.create((String)"THROW_ON_CHILDREN_COUNT");
    public static final Key THROW_ON_CHILDREN = Key.create((String)"THROW_ON_CHILDREN");
    @NotNull
    private final LLValue myVar;
    @Nullable
    private volatile LLValue myPresentationVar;
    @NotNull
    private final CachedDebuggerResult<LLValueData> myVarDataResult = new CachedDebuggerResult();
    @NotNull
    private final CachedDebuggerResult<LLValueData> myPresentationVarDataResult = new CachedDebuggerResult();
    @NotNull
    private final CachedDebuggerResult<ValueRenderer> myRendererResult = new CachedDebuggerResult();

    public CidrPhysicalValue(@NotNull LLValue var, @NotNull CidrDebugProcess process2, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        this(var, var.getName(), process2, position, frame);
    }

    public CidrPhysicalValue(@NotNull LLValue var, @NotNull String displayName2, @NotNull CidrDebugProcess process2, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        super(displayName2, process2, position, frame);
        this.myVar = var;
    }

    @NotNull
    public ValueRenderer getPreparedRenderer() {
        ValueRenderer result2 = this.myRendererResult.getResultIfAvailable();
        if (result2 == null) {
            CidrDebuggerLog.LOG.error("getPreparedRenderer() called before getRenderer()");
            return new ValueRenderer(this);
        }
        return result2;
    }

    @NotNull
    public ValueRenderer getRenderer(final @NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        return this.myRendererResult.getResult(new CachedDebuggerResult.NotNullCalculator<ValueRenderer>(){

            @Override
            @NotNull
            public ValueRenderer calculate() throws ExecutionException, DebuggerCommandException {
                return CidrPhysicalValue.this.doCreateRenderer(context2);
            }
        });
    }

    @NotNull
    protected ValueRenderer doCreateRenderer(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        return ValueRendererFactory.createRenderer(context2, this);
    }

    @Override
    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        return this.myVar.getReferenceExpression();
    }

    @NotNull
    public LLValue getVar() {
        return this.myVar;
    }

    @NotNull
    public LLValue getPresentationVar() {
        LLValue presentationVar = this.myPresentationVar;
        return presentationVar != null ? presentationVar : this.myVar;
    }

    public void setPresentationVar(@Nullable LLValue presentationVar) {
        this.myPresentationVar = presentationVar;
    }

    public String getType() {
        return this.myVar.getType();
    }

    public boolean isValueDataAvailable() {
        return this.myVarDataResult.getResultIfAvailable() != null;
    }

    @Override
    public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
        if (!this.isValueDataAvailable() && CidrDebuggerSettings.getInstance().MUTE_VARIABLES && (this.isFrameVariable() || CidrPhysicalValue.isFrameVariableNode(node2))) {
            String type = ValueRenderer.getShortenedType(this.getPresentationVar().getType());
            XRegularValuePresentation presentation = new XRegularValuePresentation("", type);
            node2.setFullValueEvaluator(this.createOnDemandValueEvaluator());
            node2.setPresentation(CidrDebuggerIcons.ValueMuted, (XValuePresentation)presentation, false);
        } else {
            super.computePresentation(node2, place);
        }
    }

    protected boolean isFrameVariable() {
        return false;
    }

    protected static boolean isFrameVariableNode(@NotNull XValueNode node2) {
        while (node2 instanceof XValueNodeImpl) {
            XValueNodeImpl nodeImpl = (XValueNodeImpl)node2;
            if (nodeImpl.getValueContainer() instanceof CidrLocalValue) {
                return true;
            }
            if (!Registry.is((String)"cidr.debugger.muteVariables.muteChildren", (boolean)false)) break;
            node2 = (XValueNode)ObjectUtils.tryCast((Object)nodeImpl.getParent(), XValueNode.class);
        }
        return false;
    }

    private XFullValueEvaluator createOnDemandValueEvaluator() {
        return new XFullValueEvaluator(CidrDebuggerBundle.message("debugger.variables.loadMutedValue.link", new Object[0])){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback instanceof HeadlessValueEvaluationCallback) {
                    XValueNodeImpl node2 = ((HeadlessValueEvaluationCallback)callback).getNode();
                    node2.clearFullValueEvaluator();
                    CidrPhysicalValue.super.computePresentation((XValueNode)node2, XValuePlace.TREE);
                }
                callback.evaluated("");
            }
        }.setShowValuePopup(false);
    }

    @NotNull
    public LLValueData getPreparedVarData() {
        LLValueData result2 = this.myVarDataResult.getResultIfAvailable();
        if (result2 == null) {
            CidrDebuggerLog.LOG.error("getPreparedVarData() called before getVarData()");
            return new LLValueData("", null, false, false, false);
        }
        return result2;
    }

    @NotNull
    public LLValueData getVarData(final @NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        return this.myVarDataResult.getResult(new CachedDebuggerResult.NotNullCalculator<LLValueData>(){

            @Override
            @NotNull
            public LLValueData calculate() throws ExecutionException, DebuggerCommandException {
                ThrowInTest.doThrow((UserDataHolder)CidrPhysicalValue.this, THROW_ON_VAR_DATA);
                return context2.getData(CidrPhysicalValue.this.myVar);
            }
        });
    }

    @NotNull
    public LLValueData getPresentationVarData(final @NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        final LLValue presentationVar = this.myPresentationVar;
        if (presentationVar == null) {
            return this.getVarData(context2);
        }
        return this.myPresentationVarDataResult.getResult(new CachedDebuggerResult.NotNullCalculator<LLValueData>(){

            @Override
            @NotNull
            public LLValueData calculate() throws ExecutionException, DebuggerCommandException {
                return context2.getData(presentationVar);
            }
        });
    }

    @Override
    @Nullable
    protected String doComputeType(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        LLValueData data;
        String pointer;
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_TYPE);
        String type = this.getRenderer(context2).getDisplayType();
        if (this.getProcess().getProject().getUserData(DO_NOT_SHOW_ADDRESSES) != Boolean.TRUE && (pointer = (data = this.getVarData(context2)).getPresentablePointer()) != null) {
            type = type + " | " + pointer;
        }
        return type;
    }

    @Nullable
    public String getShownAddress() {
        if (!this.isValueDataAvailable()) {
            return null;
        }
        return this.getPreparedVarData().getPresentablePointer();
    }

    @Override
    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_VALUE);
        return this.getRenderer(context2).computeValueAndEvaluator(context2);
    }

    @Override
    @NotNull
    protected XValuePresentation createValuePresentation(@NotNull EvaluationContext context2, @NotNull String value, @Nullable String type) throws ExecutionException, DebuggerCommandException {
        boolean isNumberFormattingEnabled;
        XValuePresentation valuePresentation = null;
        boolean bl = isNumberFormattingEnabled = Experiments.getInstance().isFeatureEnabled("cidr.debugger.value.numberFormatting.hex") || ApplicationManager.getApplication().isUnitTestMode();
        if (isNumberFormattingEnabled) {
            valuePresentation = this.createNumberValuePresentation(context2, value, type);
        }
        if (valuePresentation == null) {
            valuePresentation = super.createValuePresentation(context2, value, type);
        }
        return valuePresentation;
    }

    @Nullable
    protected XValuePresentation createNumberValuePresentation(@NotNull EvaluationContext context2, @NotNull String value, @Nullable String type) throws ExecutionException, DebuggerCommandException {
        long number;
        LLValueData valueData = this.getPresentationVarData(context2);
        if (valueData.isPointer()) {
            return null;
        }
        Pair<String, String> numberAndData = valueData.splitNumberAndData();
        String numberText = (String)numberAndData.first;
        if (numberText == null) {
            return null;
        }
        if (!value.startsWith(numberText)) {
            return null;
        }
        String text = value.substring(numberText.length());
        try {
            number = Long.decode(numberText);
        }
        catch (NumberFormatException ignored) {
            number = 0L;
        }
        boolean isHex = CidrDebuggerSettings.getInstance().HEX_FORMATTING_ENABLED;
        if (!isHex) {
            return new CidrNumberValuePresentation(value, type, numberText, text);
        }
        CidrDebuggerUtil.ReadActionResult sizeof = CidrDebuggerUtil.runInReadActionWithRetries(() -> {
            context2.checkExpiration();
            return this.getTypesHelper().getSizeOf(this);
        }, context2);
        int sizeBits = sizeof.wasCompleted && sizeof.value != null ? (Integer)sizeof.value * 8 : 64;
        boolean isHexAsSecondary = CidrDebuggerSettings.getInstance().HEX_AS_SECONDARY_FORMATTING_ENABLED;
        return ValuePresentationKt.createHexValuePresentation(value, type, numberText, text, number, sizeBits, isHexAsSecondary);
    }

    @Override
    protected boolean doComputeMayHaveChildren(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_HAS_CHILDREN);
        return this.getRenderer(context2).computeMayHaveChildren(context2);
    }

    @Override
    @Nullable
    protected Icon doComputeIcon(@NotNull EvaluationContext context2, boolean hasChildren) throws ExecutionException, DebuggerCommandException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_ICON);
        return this.getRenderer(context2).getIcon(hasChildren);
    }

    @Override
    public final void computeValueChildren(@NotNull XCompositeNode node2) {
        this.getProcess().postCommand(driver -> {
            if (node2.isObsolete()) {
                return;
            }
            try {
                ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_CHILDREN);
                EvaluationContext context2 = this.createEvaluationContext(driver, new XValueNodeExpirable((Obsolescent)node2));
                this.getRenderer(context2).computeChildren(context2, node2);
            }
            catch (DebuggerCommandException e) {
                node2.addChildren(CidrPhysicalValue.createErrorChildren(Collections.singletonList(e.getMessage())), true);
            }
            catch (ExecutionException e) {
                node2.addChildren(CidrPhysicalValue.createErrorChildren(Collections.singletonList(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)))), true);
                throw e;
            }
        });
        if (node2 instanceof XValueNodeImpl) {
            XValueNodeImpl valueNode = (XValueNodeImpl)node2;
            valueNode.invokeNodeUpdate(() -> {
                XFullValueEvaluator evaluator = valueNode.getFullValueEvaluator();
                if (evaluator != null && !evaluator.isShowValuePopup()) {
                    HeadlessValueEvaluationCallback callback = new HeadlessValueEvaluationCallback(valueNode);
                    evaluator.startEvaluation((XFullValueEvaluator.XFullValueEvaluationCallback)callback);
                }
            });
        }
    }

    @Override
    @NotNull
    public String getConsoleDescription(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        return this.getRenderer(context2).getConsoleDescription(context2).toString();
    }

    @NotNull
    public CidrDebuggerTypesHelper getTypesHelper() {
        return this.getProcess().getTypesHelper(this.getFrame());
    }

    public String toString() {
        return this.getVar().toString();
    }

    @Nullable
    public DebuggerDriver.DebuggerLanguage getLanguage() {
        return this.getFrame().getFrame().getLanguage();
    }

    public boolean isObjectiveCContext() {
        DebuggerDriver.DebuggerLanguage l = this.getLanguage();
        return l == DebuggerDriver.StandardDebuggerLanguage.OBJC || l == DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS;
    }

    public boolean isSwiftContext() {
        return this.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT;
    }

    public boolean isSwiftOptional() {
        return this.isSwiftContext() && CidrDebuggerTypesHelper.unwrapSwiftOptionalType(this.getType()) != null;
    }

    public boolean isSwiftVoid() {
        return this.isSwiftContext() && "()".equals(this.getType());
    }
}

