/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CidrWatchpointHandler
extends CidrCodePointHandlerBase<XBreakpoint<CidrWatchpointType.CidrWatchpointProperties>> {
    public CidrWatchpointHandler(CidrDebugProcess process2) {
        super(process2, CidrWatchpointType.class);
    }

    @Override
    protected Collection<LLCodepoint> addCodepointsInBackend(DebuggerDriver driver, XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint, long threadId, int frameIndex) throws ExecutionException {
        LLWatchpoint watchpoint;
        CidrWatchpointType.CidrWatchpointProperties properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties();
        if (properties == null || properties.getDebugProcess() != this.myProcess || !this.myProcess.supportsWatchpoints()) {
            return Collections.emptySet();
        }
        try {
            watchpoint = driver.addWatchpoint(threadId, frameIndex, properties.getLLValue(), properties.getExpr(), properties.getLifetime(), properties.getAccessType());
            properties.setError(null);
        }
        catch (DebuggerCommandException e) {
            properties.setError(e.getMessage());
            return Collections.emptyList();
        }
        return Collections.singleton(watchpoint);
    }

    public void cleanup() {
        XBreakpointManager manager2 = XDebuggerManager.getInstance((Project)this.myProcess.getProject()).getBreakpointManager();
        List breakpoints = (List)ReadAction.compute(() -> {
            ArrayList<XBreakpoint> breakpointsToRemove = new ArrayList<XBreakpoint>();
            for (XBreakpoint breakpoint : manager2.getBreakpoints(this.getBreakpointTypeClass())) {
                CidrWatchpointType.CidrWatchpointProperties properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties();
                if (properties == null || properties.getDebugProcess() != this.myProcess) continue;
                breakpointsToRemove.add(breakpoint);
            }
            return breakpointsToRemove;
        });
        if (!breakpoints.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> breakpoints.forEach(arg_0 -> ((XBreakpointManager)manager2).removeBreakpoint(arg_0)));
        }
    }

    public void handleWatchpointScope(int id) {
        Object breakpoint = this.getCodepoint(id);
        if (breakpoint == null) {
            return;
        }
        this.unregisterCodepointsMapping(breakpoint);
        XDebuggerUtil.getInstance().removeBreakpoint(this.myProcess.getProject(), breakpoint);
    }

    @Override
    protected void removeCodepointsInBackend(DebuggerDriver driver, List<Integer> ids, XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint) throws ExecutionException, DebuggerCommandException {
        CidrWatchpointType.CidrWatchpointProperties properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties();
        if (properties != null) {
            CidrDebuggerLog.LOG.assertTrue(properties.getDebugProcess() == this.myProcess);
        }
        driver.removeWatchpoint(ids);
    }
}

