/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.GLogOutputReaders;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.WinPipe;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerFatalException;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLSection;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolOffset;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Broadcasts;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.ProtocolResponses;
import com.jetbrains.cidr.execution.debugger.backend.lldb.lang.LLDBLanguage;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufServer;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufTimedOutException;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufUtils;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import com.pty4j.unix.Pty;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriver
extends DebuggerDriver
implements Consumer<GeneratedMessage> {
    public static final Logger LOG = CidrDebuggerLog.LOG;
    public static final Key<Boolean> ENABLE_STL_RENDERERS = Key.create((String)"LLDBDriver.synthethicsEnabled");
    private static final Key<Integer> LLVALUE_ID = Key.create((String)"LLDBDriver.LLVALUE_ID");
    private static final Key<LLValueDataLoader> LLVALUE_DATA_LOADER = Key.create((String)"LLDBDriver.LLVALUE_DATA_LOADER");
    private static final Key<LLValueData> LLVALUE_DATA = Key.create((String)"LLDBDriver.LLVALUE_DATA");
    private static final Key<Integer> CHILDREN_COUNT_CACHE = Key.create((String)"LLDBDriver.CHILDREN_COUNT_CACHE");
    private static final Key<Integer> MAX_REQUESTED_CHILDREN_COUNT_CACHE = Key.create((String)"LLDBDriver.MAX_REQUESTED_CHILDREN_COUNT_CACHE");
    public static final String NO_RESULT = "<no result>";
    private static final String LOCKED_DEVICE_RESPONSE = "process launch failed: Locked";
    private GeneralCommandLine myLLDBCommandLine;
    private BaseProcessHandler myLLDBFrontendHandler;
    private final ExecutionResult<ProtobufServer<ProtocolResponses.CompositeResponse>> myConnectedClient = new ExecutionResult();
    private final Set<Integer> myTemporaryBreakpoints = new HashSet<Integer>();
    private final OutputStream myProcessInputProxy = new OutputStream(){

        @Override
        public void write(int i2) throws IOException {
            OutputStream input = LLDBDriver.this.myProcessInput;
            if (input != null) {
                input.write(i2);
            }
        }

        @Override
        public void write(byte[] bytes, int i2, int i1) throws IOException {
            OutputStream input = LLDBDriver.this.myProcessInput;
            if (input != null) {
                input.write(bytes, i2, i1);
            }
        }

        @Override
        public void close() throws IOException {
            OutputStream input = LLDBDriver.this.myProcessInput;
            if (input != null) {
                input.close();
            }
        }

        @Override
        public void flush() throws IOException {
            OutputStream input = LLDBDriver.this.myProcessInput;
            if (input != null) {
                input.flush();
            }
        }
    };
    @Nullable
    private volatile OutputStream myProcessInput;
    private volatile Integer myAsyncAttachingTo;
    private final LLDBDriverConfiguration myStarter;
    private boolean myValuesFilteringEnabled;
    private ProtobufServer<ProtocolResponses.CompositeResponse> myProtobufServer;
    private final GLogOutputReaders myGLogOutputReaders;
    private final AtomicReference<DebuggerFatalException> myAsyncFatalException = new AtomicReference();
    @Nullable
    private ToolVersion myLLDBVersion;
    private volatile long myStoppedThreadID;
    @Nullable
    private Map<String, List<LLSection>> mySectionsMap;
    @Nullable
    private String myAutorunScriptName = null;
    @Nullable
    private String myStepIntoClassName = null;
    @Nullable
    private String myStepOverClassName = null;
    @Nullable
    private String myStepOutClassName = null;

    private void dispatchInput(String input, Model.DispatchTarget target) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.dispatchInput(input, target);
        this.getProtobufClient().sendMessage(request, ProtocolResponses.DispatchInput_Res.class, dispatchInput_res -> {}, null);
    }

    protected ProtobufServer<ProtocolResponses.CompositeResponse> getProtobufClient() throws ExecutionException {
        this.checkErrors();
        return this.myConnectedClient.get();
    }

    private void storeAsyncFatalException(DebuggerFatalException e) {
        this.myAsyncFatalException.compareAndSet(null, e);
    }

    @Override
    public void checkErrors() throws ExecutionException {
        DebuggerFatalException exception = this.myAsyncFatalException.get();
        if (exception != null) {
            this.myAsyncFatalException.compareAndSet(exception, null);
            throw new DebuggerFatalException((Throwable)((Object)exception));
        }
    }

    @NotNull
    public <R extends GeneratedMessage> R sendMessageAndWaitForReply(@NotNull GeneratedMessage message, @NotNull Class<R> responseClass) throws ExecutionException {
        final Ref responseRef = Ref.create();
        ThrowIfNotValid responseHandler = new ThrowIfNotValid<R>("Invalid response"){

            @Override
            public void consume(R message) {
                responseRef.set(message);
                super.consume(message);
            }
        };
        this.getProtobufClient().sendMessageAndWaitForReply(message, responseClass, responseHandler);
        responseHandler.throwIfNeeded();
        GeneratedMessage response = (GeneratedMessage)responseRef.get();
        if (response == null) {
            throw new ExecutionException("Null response to message " + message);
        }
        return (R)response;
    }

    public void setAutorunScriptName(@Nullable String autorunScriptName) {
        this.myAutorunScriptName = autorunScriptName;
    }

    public void setStepIntoClassName(@Nullable String stepIntoClassName) {
        this.myStepIntoClassName = stepIntoClassName;
    }

    public void setStepOverClassName(@Nullable String stepOverClassName) {
        this.myStepOverClassName = stepOverClassName;
    }

    public void setStepOutClassName(@Nullable String stepOutClassName) {
        this.myStepOutClassName = stepOutClassName;
    }

    @Deprecated
    public LLDBDriver(DebuggerDriver.Handler handler, LLDBDriverConfiguration starter) throws ExecutionException {
        this(handler, starter, ArchitectureType.UNKNOWN);
    }

    public LLDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull LLDBDriverConfiguration starter, @NotNull ArchitectureType architectureType) throws ExecutionException {
        super(handler);
        this.myStarter = starter;
        this.myGLogOutputReaders = new GLogOutputReaders(LLDBDriver.getLogDir(), "LLDBFrontend"){

            @Override
            protected void onTextAvailable(@NotNull String text, @NotNull GLogOutputReaders.LogType type) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(text.trim());
                }
            }
        };
        this.startDriver(architectureType);
    }

    @NotNull
    private static File getLogDir() {
        return new File(ApplicationManager.getApplication().isUnitTestMode() ? PathManager.getSystemPath() + "/testlog" : PathManager.getLogPath());
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return false;
    }

    @Override
    public boolean supportsDisasm() {
        return true;
    }

    @Override
    @NotNull
    public Language getConsoleLanguage() {
        return LLDBLanguage.INSTANCE;
    }

    @Override
    @NotNull
    public BaseProcessHandler getProcessHandler() {
        return this.myLLDBFrontendHandler;
    }

    @Override
    public boolean isInPromptMode() {
        return false;
    }

    public int getPort() {
        return this.myProtobufServer.getPort();
    }

    @Override
    @NotNull
    public HostMachine getHostMachine() {
        return this.myStarter.getHostMachine();
    }

    private void startDriver(@NotNull ArchitectureType architectureType) throws ExecutionException {
        try {
            this.myProtobufServer = new ProtobufServer<ProtocolResponses.CompositeResponse>((Consumer)this, (ProtobufServer.ProtobufParser)new ProtobufServer.ProtobufParser<ProtocolResponses.CompositeResponse>(){

                @Override
                public ProtocolResponses.CompositeResponse parse(byte[] buffer) throws IOException {
                    return ProtocolResponses.CompositeResponse.parseFrom(buffer);
                }

                @Override
                public boolean decompose(GeneratedMessage response) {
                    return response instanceof ProtocolResponses.CompositeResponse || response instanceof Broadcasts.CompositeBroadcast;
                }
            }){

                private boolean decomposeRequest(@NotNull GeneratedMessage request) {
                    return request instanceof Protocol.CompositeRequest;
                }

                @Override
                public <ResponseType extends GeneratedMessage> void sendMessageAndWaitForReply(@NotNull GeneratedMessage message, @NotNull Class<ResponseType> responseClass, @NotNull Consumer<ResponseType> responseHandler, long msTimeout) throws ProtobufTimedOutException, ExecutionFinishedException {
                    try (CidrEventSpan ignored = new CidrEventSpan("debug", (Function0<String>)((Function0)() -> "sendMessageAndWaitForReply (" + ProtobufUtils.unpackComposite(message, this::decomposeRequest).getClass().getSimpleName() + ")"), (Function0<String>)((Function0)() -> message.toString()));){
                        super.sendMessageAndWaitForReply(message, responseClass, responseHandler, msTimeout);
                    }
                }

                @Override
                protected void handleIOException(IOException e) {
                    CidrDebuggerLog.LOG.warn((Throwable)e);
                    if (!LLDBDriver.this.myConnectedClient.isDone()) {
                        LLDBDriver.this.myConnectedClient.setException(e);
                    } else {
                        LLDBDriver.this.storeAsyncFatalException(new DebuggerFatalException(e));
                    }
                }
            };
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
        this.myLLDBCommandLine = this.myStarter.createDriverCommandLine(this, architectureType);
        Map environment = this.myLLDBCommandLine.getEnvironment();
        environment.put("GLOG_log_dir", this.myGLogOutputReaders.getLogDir().getPath());
        if (LOG.isTraceEnabled()) {
            environment.put("GLOG_minloglevel", "0");
            environment.put("GLOG_logbufsecs", "0");
            environment.put("GLOG_v", "1");
            this.myGLogOutputReaders.init();
        } else {
            environment.put("GLOG_minloglevel", "2");
        }
        this.myLLDBFrontendHandler = this.createDebugProcessHandler(this.myLLDBCommandLine, this.myStarter);
        this.myLLDBFrontendHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                OutputStream processInput;
                if (!LLDBDriver.this.myConnectedClient.isDone()) {
                    LLDBDriver.this.myConnectedClient.setException(new ExecutionFinishedException());
                }
                if ((processInput = LLDBDriver.this.myProcessInput) != null) {
                    try {
                        processInput.close();
                    }
                    catch (IOException e) {
                        CidrDebuggerLog.LOG.warn((Throwable)e);
                    }
                }
                LLDBDriver.this.myProcessInput = null;
                LLDBDriver.this.myGLogOutputReaders.close();
                if (LLDBDriver.this.myProtobufServer != null) {
                    LLDBDriver.this.myProtobufServer.tearDown();
                }
                LLDBDriver.this.handleExited(event.getExitCode());
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text = event.getText();
                if (text == null) {
                    return;
                }
                if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                    CidrDebuggerLog.LOG.debug(PathUtil.getFileName((String)LLDBDriver.this.myLLDBCommandLine.getExePath()) + ": " + text);
                }
                if (ProcessOutputType.isStderr((Key)outputType) || ProcessOutputType.isStdout((Key)outputType)) {
                    LLDBDriver.this.handleDebuggerOutput(text, outputType);
                }
            }
        });
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) throws ExecutionException {
        if (this.myValuesFilteringEnabled == enabled) {
            return;
        }
        this.myValuesFilteringEnabled = enabled;
        LLDBDriver.doSetValuesFilteringEnabled(enabled, this.getProtobufClient());
    }

    private static void doSetValuesFilteringEnabled(boolean enabled, ProtobufServer<ProtocolResponses.CompositeResponse> client) throws ExecutionException {
        client.sendMessageAndWaitForReply(ProtobufMessageFactory.setValuesFilteringEnabled(enabled), ProtocolResponses.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid("couldn't set values filtering policy"));
    }

    @NotNull
    private String getLLDBArchitectureType(@Nullable String architectureType) {
        String lldbArchitecture = StringUtil.notNullize((String)architectureType);
        if (lldbArchitecture == ArchitectureType.UNKNOWN.getId()) {
            lldbArchitecture = "";
        }
        return lldbArchitecture;
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForLaunch(@NotNull Installer installer, @Nullable String architecture) throws ExecutionException {
        final GeneralCommandLine targetCommandLine = installer.install();
        String lldbArchitectureId = this.getLLDBArchitectureType(architecture);
        final Boolean useExternalConsole = targetCommandLine.getUserData(USE_EXTERNAL_CONSOLE_KEY) == Boolean.TRUE;
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget(installer.getExecutableFile().getPath(), lldbArchitectureId));
        return new DebuggerDriver.Inferior(0){

            @Override
            protected long startImpl() throws ExecutionException {
                return LLDBDriver.this.doLaunch(targetCommandLine, (ThrowableComputable<Protocol.CompositeRequest, ExecutionException>)() -> {
                    String stdoutPath = null;
                    String stderrPath = null;
                    if (LLDBDriver.this.myToRedirect && !useExternalConsole.booleanValue()) {
                        ProcessOutputReaders readers = LLDBDriver.this.initReaders(LocalHost.INSTANCE, targetCommandLine, !SystemInfo.isWindows);
                        stdoutPath = readers.getOutFileAbsolutePath();
                        stderrPath = readers.getErrFileAbsolutePath();
                    }
                    File inputFile = targetCommandLine.getInputFile();
                    String stdinPath = null;
                    try {
                        if (inputFile != null) {
                            if (!inputFile.isFile() || !inputFile.canRead()) {
                                throw new FileNotFoundException(CidrDebuggerBundle.message("debug.driver.cannotReadInputFile", inputFile.getPath()));
                            }
                            stdinPath = inputFile.getPath();
                        } else if (!useExternalConsole.booleanValue()) {
                            if (SystemInfo.isWindows) {
                                WinPipe pipe = WinPipe.createOutboundPipe("stdin");
                                LLDBDriver.this.myProcessInput = pipe.getOutputStream();
                                stdinPath = pipe.getName();
                            } else {
                                Pty pty = new Pty(true);
                                LLDBDriver.this.myProcessInput = (OutputStream)pty.getOutputStream();
                                stdinPath = pty.getSlaveName();
                            }
                        }
                    }
                    catch (IOException e) {
                        CidrDebuggerLog.LOG.error((Throwable)e);
                        throw new LLDBDriverException(CidrDebuggerBundle.message("debug.driver.cannotCreatePipe", e.getMessage()));
                    }
                    if (useExternalConsole.booleanValue()) {
                        LLDBDriver.this.handleTargetOutput("Output redirection disabled: Process is running in an external console" + System.lineSeparator(), (Key)ProcessOutputType.SYSTEM);
                    }
                    return ProtobufMessageFactory.launch(targetCommandLine, useExternalConsole, stdinPath, stdoutPath, stderrPath);
                }, false);
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(final int pid) throws ExecutionException {
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget("", ""));
        return new DebuggerDriver.Inferior(0){

            @Override
            protected long startImpl() throws ExecutionException {
                LLDBDriver.this.myAsyncAttachingTo = pid;
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(CidrDebuggerBundle.message("lldb.attach.failed", new Object[0]));
                LLDBDriver.this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.attach(pid), ProtocolResponses.Attach_Res.class, responseHandler);
                responseHandler.throwIfNeeded();
                return pid;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @NotNull
    public DebuggerDriver.Inferior loadForRemoteAttach(@NotNull String bundleOrExecutablePath, @Nullable String architectureId, final @NotNull GeneralCommandLine installedCommandLine, final int pid, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings, @Nullable String execSearchPaths) throws ExecutionException {
        this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget(bundleOrExecutablePath, StringUtil.notNullize((String)architectureId), "", sysroot != null ? sysroot.getAbsolutePath() : "", ""));
        if (execSearchPaths != null) {
            this.lldbSet("target.exec-search-paths", execSearchPaths);
        }
        this.addPathMapping(pathMappings);
        return new DebuggerDriver.Inferior(0){

            @Override
            protected long startImpl() throws ExecutionException {
                LLDBDriver.this.myAsyncAttachingTo = pid;
                String debugserverSocket = (String)installedCommandLine.getUserData(DebuggerDriver.DEBUGSERVER_SOCKET);
                CidrDebuggerLog.LOG.assertTrue(debugserverSocket != null);
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(CidrDebuggerBundle.message("lldb.attach.failed", new Object[0]));
                LLDBDriver.this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.remoteAttach(pid, debugserverSocket), ProtocolResponses.Attach_Res.class, responseHandler);
                responseHandler.throwIfNeeded();
                return pid;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(final @NotNull String name, final boolean wait) throws ExecutionException {
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget("", ""));
        return new DebuggerDriver.Inferior(0){

            @Override
            protected long startImpl() throws ExecutionException {
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(CidrDebuggerBundle.message("lldb.attach.failed", new Object[0]));
                LLDBDriver.this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.attachByName(name, wait), ProtocolResponses.AttachByName_Res.class, responseHandler);
                responseHandler.throwIfNeeded();
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @NotNull
    public DebuggerDriver.Inferior loadForRemoteLaunch(final @NotNull Installer installer, @Nullable String architectureId, @Nullable File symbolsDir, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException {
        final GeneralCommandLine targetCommandLine = installer.install();
        String exePath = installer.getExecutableFile().getPath();
        String remoteExePath = targetCommandLine.getExePath();
        String symbolsDirPath = symbolsDir != null ? symbolsDir.getAbsolutePath() : null;
        architectureId = StringUtil.notNullize((String)architectureId);
        CidrDebuggerLog.LOG.debug(StringUtil.join((String[])new String[]{"creating remote target: exepath: ", exePath, " remotePath: ", remoteExePath, " symbols dir path: ", symbolsDirPath, " arch: ", architectureId}));
        this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget(exePath, architectureId, "remote-ios", symbolsDirPath, remoteExePath));
        this.addPathMapping(pathMappings);
        return new DebuggerDriver.Inferior(0){

            @Override
            protected long startImpl() throws ExecutionException {
                return LLDBDriver.this.doLaunch(targetCommandLine, (ThrowableComputable<Protocol.CompositeRequest, ExecutionException>)() -> {
                    String debugserverSocket = (String)targetCommandLine.getUserData(DebuggerDriver.DEBUGSERVER_SOCKET);
                    CidrDebuggerLog.LOG.assertTrue(debugserverSocket != null);
                    LLDBDriver.this.myProcessInput = new ProcessInputDispatcher();
                    return ProtobufMessageFactory.remoteLaunch(installer.getExecutableFile().getAbsolutePath(), targetCommandLine, debugserverSocket);
                }, true);
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    @NotNull
    public DebuggerDriver.Inferior loadForAttachDebugServer(final @NotNull String connectionUrl, @Nullable File executable, @Nullable String architectureId, @NotNull List<DebuggerDriver.PathMapping> pathMappings, final @Nullable String plugin) throws ExecutionException {
        String exePath = executable != null ? executable.getPath() : "";
        architectureId = this.getLLDBArchitectureType(architectureId);
        if (CidrDebuggerLog.LOG.isDebugEnabled()) {
            CidrDebuggerLog.LOG.debug(StringUtil.join((String[])new String[]{"attaching remote process started under debug server: url: ", connectionUrl, " exePath: ", exePath, " arch: ", architectureId}));
        }
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget(exePath, architectureId));
        this.addPathMapping(pathMappings);
        return new DebuggerDriver.Inferior(0){

            @Override
            protected long startImpl() throws ExecutionException {
                ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't attach remote debug server");
                LLDBDriver.this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.connectProcess(connectionUrl, plugin), ProtocolResponses.ConnectProcess_Res.class, responseHandler);
                responseHandler.throwIfNeeded();
                LLDBDriver.this.resume();
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                LLDBDriver.this.detach();
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return LLDBDriver.this.abort();
            }
        };
    }

    private void addPathMapping(@NotNull List<DebuggerDriver.PathMapping> mappings) throws ExecutionException {
        if (mappings.isEmpty()) {
            return;
        }
        StringBuilder builder2 = new StringBuilder();
        for (DebuggerDriver.PathMapping each : mappings) {
            builder2.append("\"").append(each.from).append("\" ");
            builder2.append("\"").append(each.to).append("\" ");
        }
        this.myProtobufServer.sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "target modules search-paths add " + builder2), ProtocolResponses.HandleConsoleCommand_Res.class, new ThrowIfNotValid(CidrDebuggerBundle.message("debug.command.error.cannotAddModulesSearchPaths", new Object[0])), Integer.MAX_VALUE);
    }

    protected void sendCreateTargetRequest(@NotNull Protocol.CompositeRequest createTargetRequest) throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(CidrDebuggerBundle.message("lldb.target.create.fail", new Object[0]));
        this.getProtobufClient().sendMessageAndWaitForReply(createTargetRequest, ProtocolResponses.CreateTarget_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    private long doLaunch(@NotNull GeneralCommandLine targetCommandLine, @NotNull ThrowableComputable<Protocol.CompositeRequest, ExecutionException> launchRequestSupplier, boolean isRemoteTarget) throws ExecutionException {
        final Ref launchedPid = new Ref();
        ThrowIfNotValid<ProtocolResponses.Launch_Res> responseHandler = new ThrowIfNotValid<ProtocolResponses.Launch_Res>(CidrDebuggerBundle.message("lldb.launch.process.fail", new Object[0])){

            @Override
            public void consume(ProtocolResponses.Launch_Res message) {
                super.consume(message);
                if (this.isValid()) {
                    launchedPid.set((Object)message.getPid());
                }
            }
        };
        this.printTargetCommandLine(targetCommandLine);
        Protocol.CompositeRequest launchReq = (Protocol.CompositeRequest)launchRequestSupplier.compute();
        this.getProtobufClient().sendMessageAndWaitForReply(launchReq, ProtocolResponses.Launch_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)responseHandler);
        if (isRemoteTarget && !responseHandler.isValid() && LOCKED_DEVICE_RESPONSE.equals(responseHandler.getMessage())) {
            throw new LLDBDriverException(CidrDebuggerBundle.message("debug.lldb.lockedDeviceUserMessage", ApplicationNamesInfo.getInstance().getProductName()));
        }
        responseHandler.throwIfNeeded();
        return (Long)launchedPid.get();
    }

    private void detach() throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(CidrDebuggerBundle.message("lldb.detach.process.fail", new Object[0]));
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.detach(), ProtocolResponses.Detach_Res.class, responseHandler);
        if (!responseHandler.isValid() && !LLDBDriver.isDetachErrorShouldBeSuppressed(responseHandler.getMessage())) {
            responseHandler.throwIfNeeded();
        }
        this.handleDetached();
    }

    private static boolean isDetachErrorShouldBeSuppressed(@Nullable String message) {
        if (message == null) {
            return false;
        }
        if ("Sending disconnect packet failed.".equals(message)) {
            return true;
        }
        String errorWinPattern = "error: process \\d* in state = exited, but cannot detach it in this state.";
        return message.matches(errorWinPattern);
    }

    @Override
    public boolean interrupt() throws ExecutionException {
        Ref result2 = new Ref();
        Protocol.CompositeRequest req = ProtobufMessageFactory.suspend();
        this.getProtobufClient().sendMessageAndWaitForReply(req, ProtocolResponses.Suspend_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)suspend_res -> result2.set((Object)suspend_res.getCommonResponse().getIsValid())));
        return result2.isNull() ? false : (Boolean)result2.get();
    }

    @Override
    public boolean resume() throws ExecutionException {
        boolean[] res = new boolean[1];
        Protocol.CompositeRequest resume = ProtobufMessageFactory.resume();
        long timeout = ApplicationManager.getApplication().isUnitTestMode() ? 30000L : 0L;
        this.getProtobufClient().sendMessageAndWaitForReply(resume, ProtocolResponses.Continue_Res.class, continue_res -> {
            res[0] = continue_res.getCommonResponse().getIsValid();
        }, timeout);
        return res[0];
    }

    @Override
    public void stepOver(@Nullable Boolean stepByInstruction) throws ExecutionException {
        if (this.myStepOverClassName == null) {
            ThrowIfNotValid responseHandler = new ThrowIfNotValid(CidrDebuggerBundle.message("lldb.stepping.over.fail", new Object[0]));
            Protocol.CompositeRequest request = ProtobufMessageFactory.stepOver(this.myStoppedThreadID);
            this.getProtobufClient().sendMessageAndWaitForReply(request, ProtocolResponses.StepOver_Res.class, responseHandler);
            responseHandler.throwIfNeeded();
        } else {
            this.stepScripted(this.myStepOverClassName, CidrDebuggerBundle.message("lldb.stepping.over.fail", new Object[0]), 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo, @Nullable Boolean stepByInstruction) throws ExecutionException {
        if (forceStepIntoFramesWithNoDebugInfo) {
            this.lldbSetStepIntoNoDebug(true);
        }
        try {
            if (this.myStepIntoClassName == null) {
                ThrowIfNotValid responseHandler = new ThrowIfNotValid(CidrDebuggerBundle.message("lldb.stepping.into.fail", new Object[0]));
                Protocol.CompositeRequest request = ProtobufMessageFactory.stepInto(this.myStoppedThreadID);
                this.getProtobufClient().sendMessageAndWaitForReply(request, ProtocolResponses.StepInto_Res.class, responseHandler);
                responseHandler.throwIfNeeded();
            } else {
                this.stepScripted(this.myStepIntoClassName, CidrDebuggerBundle.message("lldb.stepping.into.fail", new Object[0]), 0L);
            }
        }
        finally {
            if (forceStepIntoFramesWithNoDebugInfo) {
                this.lldbSetStepIntoNoDebug(false);
            }
        }
    }

    @Override
    public void stepOut() throws ExecutionException {
        long timeout;
        long l = timeout = ApplicationManager.getApplication().isUnitTestMode() ? 30000L : 0L;
        if (this.myStepOutClassName == null) {
            ThrowIfNotValid responseHandler = new ThrowIfNotValid(CidrDebuggerBundle.message("lldb.stepping.out.fail", new Object[0]));
            Protocol.CompositeRequest request = ProtobufMessageFactory.stepOut(this.myStoppedThreadID);
            this.getProtobufClient().sendMessageAndWaitForReply(request, ProtocolResponses.StepOut_Res.class, responseHandler, timeout);
            responseHandler.throwIfNeeded();
        } else {
            this.stepScripted(this.myStepOutClassName, CidrDebuggerBundle.message("lldb.stepping.out.fail", new Object[0]), timeout);
        }
    }

    private void stepScripted(@NotNull String className, @NotNull String exceptionMsg, long timeout) throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(exceptionMsg);
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepScripted(this.myStoppedThreadID, className);
        this.getProtobufClient().sendMessageAndWaitForReply(request, ProtocolResponses.StepScripted_Res.class, responseHandler, timeout);
        responseHandler.throwIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTo(@NotNull String path, int line) throws ExecutionException {
        Set<Integer> set = this.myTemporaryBreakpoints;
        synchronized (set) {
            try {
                LLBreakpoint breakpoint = this.addBreakpoint(path, line);
                this.myTemporaryBreakpoints.add(breakpoint.getId());
            }
            catch (DebuggerCommandException e) {
                throw new ExecutionException("Cannot set a breakpoint", (Throwable)e);
            }
            if (!this.resume()) {
                throw new ExecutionException("Couldn't resume program");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTo(@NotNull Address address) throws ExecutionException {
        Set<Integer> set = this.myTemporaryBreakpoints;
        synchronized (set) {
            LLBreakpoint breakpoint = this.addBreakpoint(address);
            this.myTemporaryBreakpoints.add(breakpoint.getId());
            if (!this.resume()) {
                throw new ExecutionException("Couldn't resume program");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTemporaryBreakpoints() throws ExecutionException {
        Set<Integer> set = this.myTemporaryBreakpoints;
        synchronized (set) {
            for (int num : this.myTemporaryBreakpoints) {
                Protocol.CompositeRequest request = LLDBDriver.createRemoveBreakpointRequest(num);
                this.getProtobufClient().sendMessage(request, ProtocolResponses.RemoveBreakpoint_Res.class, res -> {
                    if (!res.getCommonResponse().getIsValid()) {
                        CidrDebuggerLog.LOG.error("Couldn't remove breakpoint. error: " + res.getCommonResponse().getErrorMessage());
                    }
                }, null);
            }
            this.myTemporaryBreakpoints.clear();
        }
    }

    private boolean abort() throws ExecutionException {
        Ref toThrow = Ref.create();
        Ref abort = Ref.create((Object)false);
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.kill(), ProtocolResponses.Kill_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
            if (commonResponse.getIsValid()) {
                abort.set((Object)true);
            } else {
                String errorMessage = commonResponse.getErrorMessage();
                if ("process not exist".equals(errorMessage)) {
                    abort.set((Object)false);
                } else {
                    if (StringUtil.isEmptyOrSpaces((String)errorMessage)) {
                        errorMessage = CidrDebuggerBundle.message("lldb.abort.process.fail", new Object[0]);
                    }
                    toThrow.set((Object)new LLDBDriverException(errorMessage));
                }
            }
        }));
        return (Boolean)abort.get();
    }

    @Override
    protected boolean doExit() throws ExecutionException {
        boolean sendExit = this.myConnectedClient.isDone();
        if (sendExit) {
            this.myConnectedClient.get().sendMessage(ProtobufMessageFactory.exit(), null, null);
        }
        return sendExit;
    }

    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameIndex, LLValue value, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        String expression = value.getReferenceExpression();
        Protocol.CompositeRequest request = ProtobufMessageFactory.addWatchpoint(LLDBDriver.valId(value), null, accessType == LLWatchpoint.AccessType.ANY || accessType == LLWatchpoint.AccessType.READ, accessType == LLWatchpoint.AccessType.ANY || accessType == LLWatchpoint.AccessType.WRITE, true);
        Ref result2 = Ref.create(null);
        Ref toThrow = Ref.create(null);
        this.getProtobufClient().sendMessageAndWaitForReply(request, ProtocolResponses.AddWatchpoint_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            if (!res.getCommonResponse().getIsValid()) {
                toThrow.set((Object)new DebuggerCommandException(res.getCommonResponse().getErrorMessage()));
            } else {
                result2.set((Object)new LLWatchpoint(res.getWatchpointId(), expression));
            }
        }));
        if (result2.isNull()) {
            throw (DebuggerCommandException)toThrow.get();
        }
        return (LLWatchpoint)result2.get();
    }

    @Override
    @NotNull
    public LLBreakpoint addBreakpoint(String path, int line, @Nullable String condition) throws ExecutionException {
        String convertedPath = this.myStarter.convertToProjectModelPath(path);
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(convertedPath, line + 1, condition);
        ProtocolResponses.AddBreakpoint_Res res = this.sendMessageAndWaitForReply(req, ProtocolResponses.AddBreakpoint_Res.class);
        Model.LLDBBreakpoint breakpoint = res.getBreakpoint();
        return this.makeBreakpoint(breakpoint);
    }

    protected LLBreakpoint addBreakpoint(@NotNull Address address) throws ExecutionException {
        return this.addBreakpoint(address, null);
    }

    protected LLBreakpoint addBreakpoint(@NotNull Address address, @Nullable String condition) throws ExecutionException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(address.getUnsignedLongValue(), condition);
        ProtocolResponses.AddBreakpoint_Res res = this.sendMessageAndWaitForReply(req, ProtocolResponses.AddBreakpoint_Res.class);
        Model.LLDBBreakpoint breakpoint = res.getBreakpoint();
        return this.makeBreakpoint(breakpoint);
    }

    private static String makeBreakpointLocationCanonicalName(@NotNull Model.LLDBBreakpoint breakpoint, @NotNull Model.LLDBBreakpointLocation location) {
        return "" + breakpoint.getId() + "." + location.getId();
    }

    private LLBreakpoint makeBreakpoint(@NotNull Model.LLDBBreakpoint breakpoint) {
        List locationList = ContainerUtil.map(breakpoint.getLocationList(), loc -> new LLBreakpointLocation(LLDBDriver.makeBreakpointLocationCanonicalName(breakpoint, loc), loc.getFilePath(), loc.getLine() - 1, loc.getIsResolved()));
        String orig_file_path = breakpoint.hasOrigFilePath() ? breakpoint.getOrigFilePath() : null;
        int orig_line = breakpoint.hasOrigLine() ? breakpoint.getOrigLine() : 0;
        String condition = breakpoint.hasCondition() ? breakpoint.getCondition() : null;
        return new LLBreakpoint(breakpoint.getId(), orig_file_path != null ? orig_file_path : "<address>", orig_line - 1, condition, locationList);
    }

    @Override
    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(symBreakpoint.getPattern(), symBreakpoint.isRegexpPattern(), symBreakpoint.getModule(), symBreakpoint.getCondition(), symBreakpoint.getThreadId());
        Ref result2 = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(req, ProtocolResponses.AddBreakpoint_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> result2.set((Object)new LLSymbolicBreakpoint(res.getBreakpoint().getId()))));
        return (LLSymbolicBreakpoint)result2.get();
    }

    @Override
    public void removeCodepoints(@NotNull Collection<Integer> ids) throws ExecutionException {
        for (Integer each : ids) {
            ThrowIfNotValid responseHandler = new ThrowIfNotValid(CidrDebuggerBundle.message("lldb.remove.breakpoint.fail", new Object[0]));
            Protocol.CompositeRequest req = LLDBDriver.createRemoveBreakpointRequest(each);
            this.getProtobufClient().sendMessageAndWaitForReply(req, ProtocolResponses.RemoveBreakpoint_Res.class, responseHandler);
            responseHandler.throwIfNeeded();
        }
    }

    private static Protocol.CompositeRequest createRemoveBreakpointRequest(int num) {
        return ProtobufMessageFactory.removeBreakpoint(num);
    }

    @NotNull
    private LLThread newLLThread(@NotNull Model.LLDBThread lldbThread) {
        Model.ThreadStopReasonInfo stopReasonInfo = lldbThread.getStopReasonInfo();
        boolean isStopped = stopReasonInfo != null && stopReasonInfo.getStopReason() != Model.ThreadStopReason.ThreadStopReasonInvalid;
        return new LLThread(lldbThread.getId(), isStopped ? "STOPPED" : null, lldbThread.getQueue(), lldbThread.getName());
    }

    @NotNull
    private LLFrame newLLFrame(@NotNull Model.LLDBFrame frame) {
        return new LLFrame(frame.getNumber(), frame.hasFunction() ? frame.getFunction() : null, frame.hasFile() ? this.myStarter.convertToLocalPath(frame.getFile()) : null, frame.hasLine() ? frame.getLine() - 1 : -1, frame.hasPc() ? frame.getPc() : 0L, frame.hasLanguage() ? LLDBDriver.convertLanguage(frame.getLanguage()) : null, frame.hasOptimized() && frame.getOptimized());
    }

    @Nullable
    private static DebuggerDriver.DebuggerLanguage convertLanguage(@Nullable Model.Language language) {
        if (language != null) {
            switch (language) {
                case LanguageC: 
                case LanguageC89: 
                case LanguageC99: 
                case LanguageC11: {
                    return DebuggerDriver.StandardDebuggerLanguage.C;
                }
                case LanguageC_plus_plus: 
                case LanguageC_plus_plus_03: 
                case LanguageC_plus_plus_11: 
                case LanguageC_plus_plus_14: {
                    return DebuggerDriver.StandardDebuggerLanguage.C_PLUS_PLUS;
                }
                case LanguageObjC: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC;
                }
                case LanguageObjC_plus_plus: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS;
                }
                case LanguageSwift: {
                    return DebuggerDriver.StandardDebuggerLanguage.SWIFT;
                }
                case LanguageRust: {
                    return DebuggerDriver.StandardDebuggerLanguage.RUST;
                }
                case LanguageFortran77: 
                case LanguageFortran90: 
                case LanguageFortran95: 
                case LanguageFortran03: 
                case LanguageFortran08: {
                    return DebuggerDriver.StandardDebuggerLanguage.FORTRAN;
                }
                case LanguageAda83: 
                case LanguageAda95: {
                    return DebuggerDriver.StandardDebuggerLanguage.ADA;
                }
                case LanguageCobol74: 
                case LanguageCobol85: {
                    return DebuggerDriver.StandardDebuggerLanguage.COBOL;
                }
                case LanguagePascal83: {
                    return DebuggerDriver.StandardDebuggerLanguage.PASCAL;
                }
                case LanguageModula2: 
                case LanguageModula3: {
                    return DebuggerDriver.StandardDebuggerLanguage.MODULA;
                }
                case LanguageD: {
                    return DebuggerDriver.StandardDebuggerLanguage.D;
                }
                case LanguageOpenCL: {
                    return DebuggerDriver.StandardDebuggerLanguage.OPENCL;
                }
                case LanguageGo: {
                    return DebuggerDriver.StandardDebuggerLanguage.GO;
                }
                case LanguageHaskell: {
                    return DebuggerDriver.StandardDebuggerLanguage.HASKELL;
                }
                case LanguageOCaml: {
                    return DebuggerDriver.StandardDebuggerLanguage.OCAML;
                }
                case UnsupportedLanguage: {
                    CidrDebuggerLog.LOG.warn("Unknown language reported by LLDB. Protocol needs to be updated");
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static Model.Language convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DebuggerCommandException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            switch ((DebuggerDriver.StandardDebuggerLanguage)language) {
                case C: {
                    return Model.Language.LanguageC;
                }
                case C_PLUS_PLUS: {
                    return Model.Language.LanguageC_plus_plus;
                }
                case OBJC: {
                    return Model.Language.LanguageObjC;
                }
                case OBJC_PLUS_PLUS: {
                    return Model.Language.LanguageObjC_plus_plus;
                }
                case SWIFT: {
                    return Model.Language.LanguageSwift;
                }
                case FORTRAN: {
                    return Model.Language.LanguageFortran08;
                }
                case RUST: {
                    return Model.Language.LanguageRust;
                }
                case ADA: {
                    return Model.Language.LanguageAda95;
                }
                case COBOL: {
                    return Model.Language.LanguageCobol85;
                }
                case PASCAL: {
                    return Model.Language.LanguagePascal83;
                }
                case MODULA: {
                    return Model.Language.LanguageModula3;
                }
                case D: {
                    return Model.Language.LanguageD;
                }
                case OPENCL: {
                    return Model.Language.LanguageOpenCL;
                }
                case GO: {
                    return Model.Language.LanguageGo;
                }
                case HASKELL: {
                    return Model.Language.LanguageHaskell;
                }
                case OCAML: {
                    return Model.Language.LanguageOCaml;
                }
            }
        }
        throw new DebuggerCommandException(language.toString() + " is not supported by LLDB");
    }

    @Override
    @NotNull
    public List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getThreads();
        ProtocolResponses.GetThreads_Res res = this.sendMessageAndWaitForReply(request, ProtocolResponses.GetThreads_Res.class);
        List threads = ContainerUtil.map(res.getThreadList(), thread -> this.newLLThread((Model.LLDBThread)thread));
        return threads;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getFrames(threadId, from, count, untilFirstLineWithCode);
        ProtocolResponses.GetFrames_Res res = this.sendMessageAndWaitForReply(request, ProtocolResponses.GetFrames_Res.class);
        List frames = ContainerUtil.map(res.getFrameList(), frame -> this.newLLFrame((Model.LLDBFrame)frame));
        return DebuggerDriver.ResultList.create(frames, res.getHasMore());
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        boolean staticsAndGlobals = this.myStarter.isStaticVarsLoadingEnabled();
        return this.getVariables(threadId, frameIndex, staticsAndGlobals, staticsAndGlobals);
    }

    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex, boolean statics, boolean globals) throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getVars(threadId, frameIndex, statics, globals);
        ArrayList<LLValue> result2 = new ArrayList<LLValue>();
        Ref errorMessage = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(request, ProtocolResponses.GetVars_Res.class, res -> {
            ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                String message = commonResponse.getErrorMessage();
                if (message != null) {
                    errorMessage.set((Object)message);
                }
            } else {
                for (Model.LLDBValue lldbValue : res.getValueList()) {
                    result2.add(this.createLLValue(lldbValue, null));
                }
            }
        }, 0L);
        if (!errorMessage.isNull() && !StringUtil.isEmpty((String)((String)errorMessage.get()))) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        return result2;
    }

    @Override
    @NotNull
    public LLValueData getData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        return LLDBDriver.getLLValueData(value);
    }

    @Override
    @Nullable
    public String getDescription(@NotNull LLValue value, int maxLength) throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.getValueDescription(LLDBDriver.valId(value), maxLength);
        Ref description2 = Ref.create();
        Ref exception = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply(req, ProtocolResponses.GetValueDescription_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                exception.set((Object)new DebuggerCommandException(commonResponse.getErrorMessage()));
                return;
            }
            if (res.hasDescription()) {
                description2.set((Object)res.getDescription());
            }
        }));
        if (!exception.isNull()) {
            throw (DebuggerCommandException)exception.get();
        }
        return (String)description2.get();
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
        Integer childrenCount = this.getChildrenCount(value, from + count + 1);
        if (childrenCount == 0) {
            return DebuggerDriver.ResultList.empty();
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getValueChildren(LLDBDriver.valId(value), from, count);
        Ref errorMessage = new Ref();
        ArrayList result2 = new ArrayList();
        this.getProtobufClient().sendMessageAndWaitForReply(request, ProtocolResponses.GetValueChildren_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                this.convertList(res.getValueList(), result2);
            }
        }, 0L);
        String message = (String)errorMessage.get();
        if (message != null) {
            throw new DebuggerCommandException(message);
        }
        boolean hasMore = from + count < childrenCount;
        return DebuggerDriver.ResultList.create(result2, hasMore);
    }

    @Override
    public void addSymbolsFile(File dSYM, File module2) throws ExecutionException {
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "target module add \"" + module2.getAbsolutePath() + "\""), ProtocolResponses.HandleConsoleCommand_Res.class, new ThrowIfNotValid("couldn't add module: " + module2.getAbsolutePath()));
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "target symbols add \"" + dSYM.getAbsolutePath() + "\""), ProtocolResponses.HandleConsoleCommand_Res.class, new ThrowIfNotValid("couldn't add dSYM: " + dSYM.getAbsolutePath()));
    }

    private void convertList(List<Model.LLDBValue> valuesList, List<LLValue> result2) {
        for (Model.LLDBValue val : valuesList) {
            LLValue value = this.createLLValue(val, null);
            result2.add(value);
        }
    }

    private static int valId(@NotNull LLValue var) throws ExecutionException {
        return (Integer)var.getUserData(LLVALUE_ID);
    }

    public List<LLValue> arraySlice(LLValue var, int offset, int count) throws ExecutionException, DebuggerCommandException {
        Ref errorMessage = Ref.create((Object)"unknown error");
        ArrayList<LLValue> vals = new ArrayList<LLValue>();
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.arraySlice(LLDBDriver.valId(var), offset, count), ProtocolResponses.GetArraySlice_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            if (!res.getCommonResponse().getIsValid()) {
                String message = res.getCommonResponse().getErrorMessage();
                if (message != null) {
                    errorMessage.set((Object)message);
                }
                return;
            }
            errorMessage.set(null);
            this.convertList(res.getValueList(), vals);
        }));
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        return vals;
    }

    @NotNull
    private LLValue createLLValue(@NotNull Model.LLDBValue lldbValue, @Nullable String expression) {
        LLValue.TypeClass typeClass;
        switch (lldbValue.getTypeClass()) {
            case TypeClassFunction: {
                typeClass = LLValue.TypeClass.FUNCTION;
                break;
            }
            case TypeClassBuiltin: {
                typeClass = LLValue.TypeClass.BUILTIN;
                break;
            }
            case TypeClassClass: 
            case TypeClassStruct: {
                typeClass = LLValue.TypeClass.CLASS_STRUCT;
                break;
            }
            case TypeClassObjCObjectPointer: {
                typeClass = LLValue.TypeClass.OBJC_POINTER;
                break;
            }
            default: {
                typeClass = null;
            }
        }
        String referenceExpression = lldbValue.getName();
        LLValue result2 = new LLValue(expression == null ? lldbValue.getName() : expression, lldbValue.getType(), typeClass, referenceExpression);
        result2.putUserData(LLVALUE_ID, lldbValue.getId());
        result2.putUserData(LLVALUE_DATA_LOADER, new LLValueDataLoader());
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static LLValueData getLLValueData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        LLValue lLValue = value;
        synchronized (lLValue) {
            LLValueDataLoader loader = (LLValueDataLoader)value.getUserData(LLVALUE_DATA_LOADER);
            if (loader != null) {
                LLValueData data = loader.loadData(value);
                value.putUserData(LLVALUE_DATA_LOADER, null);
                value.putUserData(LLVALUE_DATA, data);
                return data;
            }
            LLValueData data = (LLValueData)value.getUserData(LLVALUE_DATA);
            if (data == null) {
                throw new ExecutionException("Internal error, variable _p not initialized: " + (Object)((Object)value));
            }
            return data;
        }
    }

    @Override
    @NotNull
    public LLValue evaluate(long threadId, int frameIndex, @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.evaluateExpression(threadId, frameIndex, expression, LLDBDriver.convertLanguage(language));
        Ref result2 = new Ref();
        Ref errorMessage = new Ref();
        try (CidrEventSpan ignored = new CidrEventSpan("debug", "evaluate", expression);){
            this.getProtobufClient().sendMessageAndWaitForReply(req, ProtocolResponses.EvaluateExpression_Res.class, res -> {
                if (res.getCommonResponse().getIsValid()) {
                    if (res.hasResult()) {
                        Model.LLDBValue lldbValue = res.getResult();
                        LLValue value = this.createLLValue(lldbValue, expression);
                        result2.set((Object)value);
                    } else {
                        errorMessage.set((Object)NO_RESULT);
                    }
                } else {
                    String error = res.getCommonResponse().getErrorMessage();
                    errorMessage.set((Object)(error != null ? error : "Unknown evaluation error"));
                }
            }, 0L);
        }
        catch (ProtobufTimedOutException e) {
            throw new DebuggerEvaluationTimedOutException(expression);
        }
        if (!errorMessage.isNull()) {
            String message = (String)errorMessage.get();
            if (NO_RESULT.equals(message)) {
                LLValue resultValue = new LLValue("result", "void", null, "");
                resultValue.putUserData(LLVALUE_ID, 0);
                resultValue.putUserData(LLVALUE_DATA, new LLValueData("", null, false, false, false));
                resultValue.putUserData(CHILDREN_COUNT_CACHE, 0);
                return resultValue;
            }
            Pattern p = Pattern.compile("error: (.*)\nerror: \\d+ error[s]? parsing expression\n");
            Matcher matcher = p.matcher(message);
            if (matcher.find()) {
                message = matcher.group(1);
            }
            throw new DebuggerCommandException(message);
        }
        if (result2.isNull()) {
            throw new ExecutionException("Unknown evaluation error");
        }
        return (LLValue)((Object)result2.get());
    }

    @Override
    @NotNull
    public List<LLInstruction> disassembleFunction(@NotNull Address address, @NotNull AddressRange fallbackRange) throws ExecutionException, DebuggerCommandException {
        Address endAddr;
        Model.LLDBContextInfo contextInfo;
        assert (fallbackRange.contains(address));
        try {
            contextInfo = this.sendMessageAndWaitForReply(ProtobufMessageFactory.contextInfo(address.getUnsignedLongValue()), ProtocolResponses.ContextInfo_Res.class).getContextInfo();
        }
        catch (LLDBDriverException ex) {
            return this.disassembleRange(fallbackRange, null);
        }
        if (contextInfo == null) {
            return this.disassembleRange(fallbackRange, null);
        }
        Address startAddr = Address.fromUnsignedLong(contextInfo.getStartAddr());
        AddressRange range = AddressUtil.addressRangeExclusive(startAddr, endAddr = Address.fromUnsignedLong(contextInfo.getEndAddr()));
        if (!range.contains(address)) {
            return this.disassembleRange(fallbackRange, null);
        }
        String functionName = contextInfo.getName();
        AddressRange saneRange = range.getSize() > 65536L ? range.intersectWith(fallbackRange) : range;
        return this.disassembleRange(saneRange, functionName);
    }

    @Override
    @NotNull
    public List<LLInstruction> disassemble(@NotNull AddressRange range) throws ExecutionException {
        return this.disassembleRange(range, null);
    }

    protected List<LLInstruction> disassembleRange(@NotNull AddressRange range, @Nullable String functionName) throws ExecutionException {
        long start = range.getStart().unsignedLongValue();
        long end = AddressUtil.getEndCoerced(range).unsignedLongValue();
        ProtocolResponses.Disassemble_Res disassembleRes = this.sendMessageAndWaitForReply(ProtobufMessageFactory.disassemble(start, end), ProtocolResponses.Disassemble_Res.class);
        ArrayList<LLInstruction> instructions = new ArrayList<LLInstruction>(disassembleRes.getInstructionsCount());
        for (Model.LLDBInstruction instruction : disassembleRes.getInstructionsList()) {
            long addr = instruction.getAddr();
            LLSymbolOffset functionOffset = functionName == null ? null : new LLSymbolOffset(functionName, addr - start);
            LLInstruction llInstruction = LLInstruction.create(Address.fromUnsignedLong(addr), (Iterable<Byte>)instruction.getOpcodes(), instruction.getMnemonic(), instruction.getOperands(), instruction.getComment(), functionOffset);
            instructions.add(llInstruction);
        }
        return instructions;
    }

    @Override
    @NotNull
    public List<LLModule> getLoadedModules() throws ExecutionException {
        Map<String, List<LLSection>> sectionsMap = this.doGetSectionsMap();
        return sectionsMap.keySet().stream().map(LLModule::new).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<LLSection> getModuleSections(@NotNull LLModule module2) throws ExecutionException, DebuggerCommandException {
        Map<String, List<LLSection>> sectionsMap = this.doGetSectionsMap();
        if (!sectionsMap.containsKey(module2.getName())) {
            throw new DebuggerCommandException("Can't find module " + module2);
        }
        return sectionsMap.get(module2.getName());
    }

    @NotNull
    protected Map<String, List<LLSection>> doGetSectionsMap() throws ExecutionException {
        if (this.mySectionsMap == null) {
            this.mySectionsMap = new HashMap<String, List<LLSection>>();
            this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.dumpSections(), ProtocolResponses.DumpSections_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
                for (Model.LLDBModule module2 : res.getModulesList()) {
                    List llSections = module2.getSectionsList().stream().map(m -> new LLSection(m.getName(), m.getFlagsList(), AddressUtil.addressRangeExclusive(Address.fromUnsignedLong(m.getStart()), Address.fromUnsignedLong(m.getEnd())))).collect(Collectors.toList());
                    this.mySectionsMap.put(module2.getName(), llSections);
                }
            }));
        }
        return this.mySectionsMap;
    }

    @Override
    @NotNull
    public List<LLMemoryHunk> dumpMemory(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        Ref result2 = Ref.create();
        Ref exception = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.dumpMemory(range.getStart().unsignedLongValue(), range.getEndInclusive().getUnsignedLongValue() + 1L), ProtocolResponses.DumpMemory_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            if (!res.getCommonResponse().getIsValid()) {
                exception.set((Object)new DebuggerCommandException(res.getCommonResponse().getErrorMessage()));
            } else if ((long)res.getData().size() != range.getSize()) {
                exception.set((Object)new DebuggerCommandException("Unable to read memory " + range));
            } else {
                result2.set((Object)res.getData());
            }
        }));
        if (!exception.isNull()) {
            throw (DebuggerCommandException)exception.get();
        }
        LLMemoryHunk hunk = new LLMemoryHunk(range, ((ByteString)result2.get()).toByteArray());
        LinkedList<LLMemoryHunk> list = new LinkedList<LLMemoryHunk>();
        list.add(hunk);
        return list;
    }

    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String executable, @Nullable List<String> params, @Nullable String workingDir, int timeoutSecs) throws ExecutionException {
        Ref result2 = new Ref();
        Ref errorMessage = new Ref();
        LinkedList<String> args = new LinkedList<String>();
        args.add(executable);
        if (params != null) {
            args.addAll(params);
        }
        String command = StringUtil.join(args, s -> StringUtil.escapeCharCharacters((String)s), (String)" ");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.executeShellCommand(command, workingDir, timeoutSecs), ProtocolResponses.ExecuteShellCommand_Res.class, res -> {
            ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
            if (!commonResponse.getIsValid()) {
                String message = commonResponse.getErrorMessage();
                errorMessage.set((Object)(message != null && !StringUtil.isEmpty((String)message) ? message : "Invalid shell command response"));
            } else {
                result2.set((Object)new DebuggerDriver.ShellCommandResult(res.getOutput(), res.getStatus(), res.getSignal()));
            }
        }, (long)(timeoutSecs + 10) * 1000L);
        if (!errorMessage.isNull()) {
            throw new ExecutionException((String)errorMessage.get());
        }
        return (DebuggerDriver.ShellCommandResult)result2.get();
    }

    @Override
    public void executeConsoleCommand(String command) throws ExecutionException {
        this.executeConsoleCommand(-1L, -1, command);
    }

    @Override
    public void executeConsoleCommand(long threadId, int frameIndex, String command) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleConsoleCommand(threadId, frameIndex, command);
        this.getProtobufClient().sendMessageAndWaitForReply(request, ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            if (res.hasOut()) {
                this.handleDebuggerOutput(res.getOut(), ProcessOutputTypes.STDOUT);
            }
            if (res.hasErr()) {
                this.handleDebuggerOutput(res.getErr(), ProcessOutputTypes.STDERR);
            }
        }));
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<String> completeConsoleCommand(@NotNull String command, int pos) throws ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleCompletion(command, pos);
        ProtocolResponses.HandleCompletion_Res reply = this.sendMessageAndWaitForReply(request, ProtocolResponses.HandleCompletion_Res.class);
        return DebuggerDriver.ResultList.create(reply.getCompletionList(), false);
    }

    @Override
    public void handleSignal(String signalName, boolean stop, boolean pass, boolean notify) throws ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(CidrDebuggerBundle.message("lldb.handle.signal.fail", new Object[0]));
        Protocol.CompositeRequest handleSignalReq = ProtobufMessageFactory.handleSignal(signalName, stop, pass, notify);
        this.getProtobufClient().sendMessageAndWaitForReply(handleSignalReq, ProtocolResponses.HandleSignal_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    protected String getPromptText() {
        return "lldb";
    }

    @Override
    public OutputStream getProcessInput() {
        return this.myProcessInputProxy;
    }

    public OutputStream getProcessInputInternalStream() {
        return this.myProcessInput;
    }

    @Override
    public void removeWatchpoint(List<Integer> ids) throws ExecutionException {
        int num = ids.get(0);
        ThrowIfNotValid responseHandler = new ThrowIfNotValid(CidrDebuggerBundle.message("lldb.remove.watchpoint.fail", new Object[0]));
        Protocol.CompositeRequest req = ProtobufMessageFactory.removeWatchpoint(num);
        this.getProtobufClient().sendMessageAndWaitForReply(req, ProtocolResponses.RemoveWatchpoint_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    @NotNull
    public Integer getChildrenCount(@NotNull LLValue var, int max) throws ExecutionException, DebuggerCommandException {
        Integer cached = (Integer)var.getUserData(CHILDREN_COUNT_CACHE);
        if (cached != null) {
            Integer max_cache = (Integer)var.getUserData(MAX_REQUESTED_CHILDREN_COUNT_CACHE);
            assert (max_cache != null);
            if (cached < max_cache) {
                return cached;
            }
            if (max < max_cache) {
                return max;
            }
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getChildrenCount(LLDBDriver.valId(var), max);
        Ref errorMessage = new Ref();
        Ref result2 = Ref.create((Object)0);
        this.getProtobufClient().sendMessageAndWaitForReply(request, ProtocolResponses.GetChildrenCount_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                result2.set((Object)res.getCount());
            }
        }, 0L);
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        var.putUserData(MAX_REQUESTED_CHILDREN_COUNT_CACHE, max);
        var.putUserData(CHILDREN_COUNT_CACHE, result2.get());
        return (Integer)result2.get();
    }

    public long getValueAddress(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getValueAddress(LLDBDriver.valId(var));
        Ref errorMessage = new Ref();
        Ref result2 = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply(request, ProtocolResponses.GetValueAddress_Res.class, res -> {
            boolean isValid = res.getCommonResponse().getIsValid();
            if (!isValid) {
                errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
            } else {
                result2.set((Object)res.getAddress());
            }
        }, 0L);
        if (!errorMessage.isNull()) {
            throw new DebuggerCommandException((String)errorMessage.get());
        }
        return (Long)result2.get();
    }

    protected void lldbSet(@NotNull String setting, boolean enabled) throws ExecutionException {
        this.lldbSet(setting, enabled ? "true" : "false");
    }

    protected void lldbSet(@NotNull String setting, @Nullable String value) throws ExecutionException {
        String settingCommand = value != null ? "set " + setting + " " + value : "remove " + setting;
        this.myProtobufServer.sendMessageAndWaitUntilSent(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "settings " + settingCommand), ProtocolResponses.HandleConsoleCommand_Res.class, new ThrowIfNotValid("couldn't set " + setting + " = " + value));
    }

    @NotNull
    @Contract(pure=true)
    protected String createTypeSummaryConsoleCommand(@NotNull String summaryString, @Nullable String category, String ... typeNames) {
        return String.format("type summary add --skip-pointers --summary-string %s --category %s %s", LLDBDriver.stringify(summaryString), category != null ? category : "default", Arrays.stream(typeNames).map(DebuggerDriver::stringify).collect(Collectors.joining(" ")));
    }

    private void lldbSetStepIntoNoDebug(boolean value) throws ExecutionException {
        this.lldbSet("target.process.thread.step-in-avoid-nodebug", !value);
    }

    private void haveConnection(@NotNull String version) {
        this.handlePrompt();
        try {
            String[] typeSummaryConsoleCommands;
            this.myLLDBVersion = LLDBDriverConfiguration.parseVersion(version);
            this.lldbSetStepIntoNoDebug(false);
            this.lldbSet("target.process.thread.step-out-avoid-nodebug", true);
            if (CidrDebuggerLog.LOG.isTraceEnabled()) {
                String logPath = LLDBDriver.getLogDir() + "/lldb.log";
                this.myProtobufServer.sendMessageAndWaitUntilSent(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "log enable -f " + logPath + " lldb default"), ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {}));
            }
            if (this.myAutorunScriptName != null) {
                this.executeConsoleCommandAndHandleOutput(String.format("command script import \"%s\"", this.myAutorunScriptName));
            }
            for (String typeSummaryConsoleCommand : typeSummaryConsoleCommands = new String[]{this.createTypeSummaryConsoleCommand("${var%d} ${var}", "cplusplus", "char", "signed char"), this.createTypeSummaryConsoleCommand("${var%u} ${var}", "cplusplus", "unsigned char")}) {
                this.myProtobufServer.sendMessageAndWaitUntilSent(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, typeSummaryConsoleCommand), ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {}));
            }
            this.myProtobufServer.sendMessageAndWaitUntilSent(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, "type category enable objc"), ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {}));
            this.myProtobufServer.sendMessageAndWaitUntilSent(ProtobufMessageFactory.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED), ProtocolResponses.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid("couldn't set values filtering policy"));
            if (this.myLLDBCommandLine.getUserData(ENABLE_STL_RENDERERS) == Boolean.TRUE) {
                this.executeConsoleCommandAndHandleOutput("script import lldb_formatters.jetbrains_stl_formatters");
            }
            this.myConnectedClient.set(this.myProtobufServer);
        }
        catch (Exception e) {
            this.myConnectedClient.setException(e);
        }
    }

    private void executeConsoleCommandAndHandleOutput(String command) throws ProtobufTimedOutException {
        this.myProtobufServer.sendMessageAndWaitUntilSent(ProtobufMessageFactory.handleConsoleCommand(-1L, -1, command), ProtocolResponses.HandleConsoleCommand_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
            if (res.hasOut() || res.hasErr()) {
                String message = "Error during data formatters setup:";
                if (res.hasOut()) {
                    message = message + "\n" + res.getOut();
                }
                if (res.hasErr()) {
                    message = message + "\n" + res.getErr();
                }
                this.handleTargetOutput(message, ProcessOutputTypes.SYSTEM);
            }
        }));
    }

    public void consume(@NotNull GeneratedMessage generatedMessage) {
        try (CidrEventSpan ignored = new CidrEventSpan("debug", (Function0<String>)((Function0)() -> "consume (" + generatedMessage.getClass().getSimpleName() + ")"), (Function0<String>)((Function0)() -> generatedMessage.toString()));){
            this.handleMessage(generatedMessage);
        }
    }

    private void handleMessage(@NotNull GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Broadcasts.Initialized_Message) {
            Broadcasts.Initialized_Message init = (Broadcasts.Initialized_Message)generatedMessage;
            this.haveConnection(init.getVersionString());
        } else if (generatedMessage instanceof Broadcasts.ProcessExited_Broadcast) {
            Broadcasts.ProcessExited_Broadcast exit = (Broadcasts.ProcessExited_Broadcast)generatedMessage;
            int exitCode = exit.getExitCode();
            this.handleTargetFinished(exitCode, exit.hasExitDescription() ? exit.getExitDescription() : null);
        } else if (generatedMessage instanceof Broadcasts.ProcessRunning_Broadcast) {
            Integer attachedTo = this.myAsyncAttachingTo;
            this.myAsyncAttachingTo = null;
            if (attachedTo != null) {
                this.handleAttached(attachedTo);
            }
            this.handleRunning();
        } else if (generatedMessage instanceof Broadcasts.ProcessInterrupted_Broadcast) {
            Model.ThreadStopReason stopReason;
            try {
                this.removeTemporaryBreakpoints();
            }
            catch (ExecutionException attachedTo) {
                // empty catch block
            }
            Broadcasts.ProcessInterrupted_Broadcast interrupted_broadcast = (Broadcasts.ProcessInterrupted_Broadcast)generatedMessage;
            Model.LLDBThread lldbThread = interrupted_broadcast.getThread();
            LLThread thread = this.newLLThread(lldbThread);
            LLFrame frame = this.newLLFrame(interrupted_broadcast.getFrame());
            DebuggerDriver.StopPlace stopPlace = new DebuggerDriver.StopPlace(thread, frame);
            this.myStoppedThreadID = stopPlace.thread.getId();
            Model.ThreadStopReasonInfo stopReasonInfo = lldbThread.getStopReasonInfo();
            Model.ThreadStopReason threadStopReason = stopReason = stopReasonInfo == null ? null : stopReasonInfo.getStopReason();
            if (stopReason == Model.ThreadStopReason.ThreadStopReasonBreakpoint && stopReasonInfo.hasCodepointId()) {
                this.handleBreakpoint(stopPlace, stopReasonInfo.getCodepointId());
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonWatchpoint && stopReasonInfo.hasCodepointId()) {
                this.handleWatchpoint(stopPlace, stopReasonInfo.getCodepointId());
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonSignal) {
                int signal = stopReasonInfo.getSignal();
                String signalName = stopReasonInfo.getSignalName();
                if (LLDBDriver.isTargetTerminationSignal(signal)) {
                    this.handleTargetTerminated();
                } else {
                    this.handleSignal(stopPlace, !signalName.isEmpty() ? signalName : String.valueOf(signal), stopReasonInfo.getStopDescription());
                }
            } else if (stopReason == Model.ThreadStopReason.ThreadStopReasonException) {
                this.handleException(stopPlace, stopReasonInfo.getStopDescription());
            } else {
                this.handleInterrupted(stopPlace);
            }
        } else if (generatedMessage instanceof Broadcasts.ChangePrompt_Broadcast) {
            this.handlePrompt(((Broadcasts.ChangePrompt_Broadcast)generatedMessage).getPrompt());
        } else if (generatedMessage instanceof Broadcasts.ReadyForCommands_Broadcast) {
            this.handlePrompt(((Broadcasts.ReadyForCommands_Broadcast)generatedMessage).getReady() == 0);
        } else if (generatedMessage instanceof Broadcasts.CommandsInterpreter_Broadcast) {
            this.handleDebuggerOutput(((Broadcasts.CommandsInterpreter_Broadcast)generatedMessage).getMessage(), ProcessOutputTypes.STDOUT);
        } else if (generatedMessage instanceof Broadcasts.TargetProcessOutput_Broadcast) {
            Broadcasts.TargetProcessOutput_Broadcast outputBroadcast = (Broadcasts.TargetProcessOutput_Broadcast)generatedMessage;
            this.handleTargetOutput(outputBroadcast.getText(), LLDBDriver.outputType2ProcessOutputKey(outputBroadcast.getOutputType()));
        } else if (generatedMessage instanceof Broadcasts.LogMessage_Broadcast) {
            String message = ((Broadcasts.LogMessage_Broadcast)generatedMessage).getMessage();
            CidrDebuggerLog.LOG.info(message);
        } else if (generatedMessage instanceof Broadcasts.ModulesLoaded_Broadcast) {
            Broadcasts.ModulesLoaded_Broadcast msg = (Broadcasts.ModulesLoaded_Broadcast)generatedMessage;
            List lst = ContainerUtil.map(msg.getModulesList(), module2 -> new LLModule(module2.trim()));
            this.handleModulesLoaded(lst);
        } else if (generatedMessage instanceof Broadcasts.BreakpointChanged_Broadcast) {
            Broadcasts.BreakpointChanged_Broadcast msg = (Broadcasts.BreakpointChanged_Broadcast)generatedMessage;
            Model.LLDBBreakpoint brk = msg.getBreakpoint();
            switch (msg.getEventType()) {
                case Added: {
                    this.handleBreakpointAdded(this.makeBreakpoint(brk));
                    break;
                }
                case Removed: {
                    this.handleBreakpointRemoved(this.makeBreakpoint(brk));
                    break;
                }
                case LocationsAdded: 
                case LocationsRemoved: 
                case LocationsResolved: {
                    this.handleBreakpointUpdated(this.makeBreakpoint(brk));
                    break;
                }
            }
        }
    }

    private static Key outputType2ProcessOutputKey(Model.OutputType outputType) {
        return outputType == Model.OutputType.OutputTypeStdout ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR;
    }

    private class ProcessInputDispatcher
    extends OutputStream {
        private ProcessInputDispatcher() {
        }

        @Override
        public void write(int i2) throws IOException {
            LOG.error("Shouldn't be here");
        }

        @Override
        public void write(byte @NotNull [] bytes, int i2, int i1) throws IOException {
            try {
                String input = new String(bytes, i2, i1, LLDBDriver.this.myLLDBCommandLine.getCharset());
                LLDBDriver.this.dispatchInput(input, Model.DispatchTarget.DispatchTargetProcess);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
    }

    private class LLValueDataLoader {
        private LLValueDataLoader() {
        }

        @NotNull
        public LLValueData loadData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
            Protocol.CompositeRequest req = ProtobufMessageFactory.getValueData(LLDBDriver.valId(value), 1000);
            Ref lldbDataRef = Ref.create();
            Ref exception = Ref.create();
            Ref debugResRef = Ref.create();
            LLDBDriver.this.getProtobufClient().sendMessageAndWaitForReply(req, ProtocolResponses.GetValueData_Res.class, (Consumer<ProtocolResponses.CompositeResponse>)((Consumer)res -> {
                debugResRef.set(res);
                ProtocolResponses.CommonResponse commonResponse = res.getCommonResponse();
                if (!commonResponse.getIsValid()) {
                    exception.set((Object)new DebuggerCommandException(commonResponse.getErrorMessage()));
                    return;
                }
                lldbDataRef.set((Object)res.getValue());
            }));
            if (!exception.isNull()) {
                throw (DebuggerCommandException)exception.get();
            }
            Model.LLDBValueData lldbData = (Model.LLDBValueData)lldbDataRef.get();
            if (lldbData == null) {
                throw new ExecutionException("No LLDBValueData: req=" + req + "; res=" + debugResRef.get());
            }
            return new LLValueData(lldbData.getValue(), lldbData.hasDescription() ? lldbData.getDescription() : null, lldbData.getHasLongerDescription(), lldbData.getMayHaveChildren(), lldbData.getIsSynthetic());
        }
    }

    protected static class ThrowIfNotValid<T extends GeneratedMessage>
    implements Consumer<T> {
        private String myMessage;
        private boolean myIsValid = false;

        public ThrowIfNotValid(String mes) {
            this.myMessage = mes;
        }

        public void consume(T message) {
            Map allFields = message.getAllFields();
            for (Object val : allFields.values()) {
                String errorMessage;
                if (!(val instanceof ProtocolResponses.CommonResponse)) continue;
                ProtocolResponses.CommonResponse commonResponse = (ProtocolResponses.CommonResponse)val;
                this.myIsValid = commonResponse.getIsValid();
                if (this.myIsValid || !commonResponse.hasErrorMessage() || StringUtil.isEmptyOrSpaces((String)(errorMessage = commonResponse.getErrorMessage()))) continue;
                this.myMessage = errorMessage;
            }
        }

        public void throwIfNeeded() throws LLDBDriverException {
            if (!this.myIsValid) {
                throw new LLDBDriverException(this.myMessage);
            }
        }

        public String getMessage() {
            return this.myMessage;
        }

        public boolean isValid() {
            return this.myIsValid;
        }
    }
}

