/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBTokenType;
import org.jetbrains.annotations.NotNull;

public class GDBParser
implements PsiParser {
    private static final String[] GDB_EXPRESSION_COMMANDS = new String[]{"print", "p", "print-object", "po", "call"};

    @NotNull
    public ASTNode parse(@NotNull IElementType root, PsiBuilder builder2) {
        PsiBuilder.Marker mark = builder2.mark();
        GDBParser.parseGDBCommand(builder2);
        mark.done(root);
        return builder2.getTreeBuilt();
    }

    private static void parseGDBCommand(PsiBuilder builder2) {
        PsiBuilder.Marker command = builder2.mark();
        if (builder2.getTokenType() == GDBTokenType.IDENTIFIER) {
            String commandName = builder2.getTokenText();
            PsiBuilder.Marker commandNameMarker = builder2.mark();
            builder2.advanceLexer();
            commandNameMarker.done((IElementType)GDBTokenType.COMMAND_NAME);
            if (GDBParser.isExpressionCommand(commandName)) {
                GDBParser.parseExpression(builder2);
            } else {
                GDBParser.parseCommandArguments(builder2);
            }
        } else {
            GDBParser.eatEverything(builder2);
        }
        command.done((IElementType)GDBTokenType.DBG_COMMAND);
    }

    private static boolean isExpressionCommand(String commandName) {
        return ArrayUtil.contains((String)commandName, (String[])GDB_EXPRESSION_COMMANDS);
    }

    private static void eatEverything(PsiBuilder builder2) {
        while (!builder2.eof()) {
            builder2.advanceLexer();
        }
    }

    private static void parseExpression(PsiBuilder builder2) {
        PsiBuilder.Marker body = builder2.mark();
        GDBParser.eatEverything(builder2);
        body.done((IElementType)GDBTokenType.EXPRESSION_PLACEHOLDER);
    }

    private static void parseCommandArguments(PsiBuilder builder2) {
        PsiBuilder.Marker body = builder2.mark();
        while (!builder2.eof()) {
            if (builder2.getTokenType() == GDBTokenType.IDENTIFIER) {
                PsiBuilder.Marker subCommand = builder2.mark();
                builder2.advanceLexer();
                subCommand.done((IElementType)GDBTokenType.COMMAND_ARGUMENTS);
                continue;
            }
            if (builder2.getTokenType() == GDBTokenType.DASH && builder2.rawLookup(1) == GDBTokenType.IDENTIFIER) {
                PsiBuilder.Marker option = builder2.mark();
                builder2.advanceLexer();
                builder2.advanceLexer();
                option.done((IElementType)GDBTokenType.COMMAND_ARGUMENTS);
                continue;
            }
            if (builder2.getTokenType() == GDBTokenType.DASHDASH) {
                PsiBuilder.Marker dashDash = builder2.mark();
                builder2.advanceLexer();
                dashDash.done((IElementType)GDBTokenType.COMMAND_ARGS_END);
                GDBParser.eatEverything(builder2);
                continue;
            }
            builder2.advanceLexer();
        }
        body.done((IElementType)GDBTokenType.COMMAND_ARGUMENTS);
    }
}

