/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import gnu.trove.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.jetbrains.annotations.NotNull;

public class MacOSDebugSymbols {
    public static TLongHashSet load(@NotNull GeneralCommandLine cl) throws IOException {
        try {
            if (Registry.is((String)"cidr.debugger.gdb.workaround.macOS.generateDsymBundle", (boolean)false)) {
                MacOSDebugSymbols.generateDsymBundle(cl.getExePath());
            }
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"/usr/bin/otool"});
            commandLine.addParameter("-I");
            commandLine.addParameter(cl.getExePath());
            return MacOSDebugSymbols.parseIndirectSymTable(commandLine.createProcess().getInputStream());
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateDsymBundle(@NotNull String exePath) throws IOException, ExecutionException {
        File executable = new File(exePath);
        File dsymBundle = new File(executable.getParentFile(), executable.getName() + ".dSYM");
        if (!dsymBundle.exists() || executable.lastModified() > dsymBundle.lastModified()) {
            File tmpDir = FileUtil.createTempDirectory((String)executable.getName(), null);
            try {
                File newDSYMBundle = new File(tmpDir, dsymBundle.getName());
                GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"/usr/bin/dsymutil"});
                commandLine.addParameter(exePath);
                commandLine.addParameter("-o");
                commandLine.addParameter(newDSYMBundle.getAbsolutePath());
                String output = StringUtil.notNullize((String)ExecUtil.readFirstLine((InputStream)commandLine.createProcess().getInputStream(), null));
                if (output.matches("^error.*")) {
                    throw new IOException("Cannot create dsym bundle for " + exePath);
                }
                if (dsymBundle.exists()) {
                    FileUtil.delete((File)dsymBundle);
                }
                FileUtil.rename((File)newDSYMBundle, (File)dsymBundle);
            }
            finally {
                FileUtil.delete((File)tmpDir);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static TLongHashSet parseIndirectSymTable(InputStream input) throws ExecutionException {
        Scanner scanner = new Scanner(input);
        TLongHashSet symbols = new TLongHashSet();
        try {
            block2: while (scanner.hasNext()) {
                if (scanner.findInLine("Indirect symbols for \\(__TEXT,__stubs\\)") != null) {
                    int snum = scanner.nextInt();
                    scanner.nextLine();
                    MacOSDebugSymbols.nextTitle(scanner, "address");
                    MacOSDebugSymbols.nextTitle(scanner, "index");
                    scanner.nextLine();
                    int i2 = 0;
                    while (true) {
                        if (i2 >= snum) continue block2;
                        symbols.add(DebuggerDriver.parseAddress(scanner.next()).unsignedLongValue());
                        scanner.nextInt();
                        scanner.nextLine();
                        ++i2;
                    }
                }
                scanner.nextLine();
            }
            return symbols;
        }
        catch (NoSuchElementException e) {
            throw new ExecutionException("Cannot parse indirect symbol table: " + e);
        }
    }

    private static void nextTitle(@NotNull Scanner scanner, @NotNull String expected) throws ExecutionException {
        String str = scanner.next();
        if (!expected.equals(str)) {
            throw new ExecutionException("Invalid section title:" + str);
        }
    }
}

