/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.application.ReadAction;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfigurationBuildConfigurationEditor;
import com.jetbrains.cidr.execution.CidrRunConfigurationEditorUtil;
import com.jetbrains.cidr.ui.ComboBoxModelKt;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ComboBoxEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
implements CidrRunConfigurationBuildConfigurationEditor {
    private final CidrRunConfigurationEditorUtil.ComboBox myComboBox;
    @NotNull
    private final BCH myConfigHelper;
    @NotNull
    private final JComboBox myTargetCombo;

    ComboBoxEditor(@NotNull BCH configHelper, @NotNull JComboBox targetCombo) {
        CidrLog.LOG.assertTrue(((CidrBuildConfigurationHelper)configHelper).allowEditBuildConfiguration());
        this.myConfigHelper = configHelper;
        this.myTargetCombo = targetCombo;
        this.myComboBox = CidrRunConfigurationEditorUtil.createCombo();
        this.myComboBox.setRenderer((ListCellRenderer)((Object)CidrRunConfigurationEditorUtil.getTargetsRenderer(this.myConfigHelper)));
        this.myTargetCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2 && ComboBoxEditor.this.myTargetCombo.getItemCount() > 0) {
                    return;
                }
                CidrBuildTarget target = e.getStateChange() == 1 ? (CidrBuildTarget)ComboBoxModelKt.getItemValue((ItemEvent)e) : null;
                ReadAction.run(() -> {
                    ComboBoxEditor.this.myComboBox.setModel(new DefaultComboBoxModel<Object>(ComboBoxEditor.this.myConfigHelper.getConfigurations(target).toArray()));
                    ComboBoxEditor.this.myComboBox.setSelectedItem(null);
                    ComboBoxEditor.this.myComboBox.setSelectedItem(ComboBoxEditor.this.myConfigHelper.getDefaultConfiguration(target));
                });
            }
        });
    }

    @Override
    public void createAdditionalControls(@NotNull JPanel panel2, @NotNull GridBag bag) {
        JLabel label = new JLabel(((CidrBuildConfigurationHelper)this.myConfigHelper).getConfigurationTitle() + ":");
        panel2.add((Component)label, bag.nextLine().next());
        panel2.add((Component)((Object)this.myComboBox), bag.next().coverLine());
        label.setLabelFor((Component)((Object)this.myComboBox));
    }

    @Override
    @Nullable
    public String getSelectedConfiguration() {
        CidrBuildConfiguration selectedConfiguration = (CidrBuildConfiguration)ComboBoxModelKt.getSelectedItemValue((JComboBox)((Object)this.myComboBox));
        return selectedConfiguration != null ? selectedConfiguration.getName() : (String)ComboBoxModelKt.getSelectedInvalidItemValue((JComboBox)((Object)this.myComboBox));
    }

    @Override
    public void selectConfiguration(@Nullable Object item, @Nullable Object invalidItemValue) {
        CidrRunConfigurationEditorUtil.setSelectedItem((JComboBox)((Object)this.myComboBox), item, invalidItemValue);
    }
}

