/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationBinder;
import com.jetbrains.cidr.execution.CidrTargetRunLineMarkerProvider;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTargetRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>>
extends CidrContextRunConfigurationProducer<BC, TARGET, CONFIGURATION> {
    private static CidrTargetRunConfigurationProducer INSTANCE = null;

    protected CidrTargetRunConfigurationProducer(@NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        super(binder);
    }

    @Deprecated
    protected CidrTargetRunConfigurationProducer(@NotNull ConfigurationType configurationType, @NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        super(configurationType, binder);
    }

    protected boolean setupConfigurationFromContext(@NotNull CONFIGURATION newConfigurationWithTemplateDefaults, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        BuildTargetAndConfigurationData btc;
        Location location = context2.getLocation();
        if (location != null && CidrTargetRunLineMarkerProvider.isInEntryPointBody(location.getPsiElement()) && (btc = this.findBuiltTargetAndConfiguration(newConfigurationWithTemplateDefaults, this.getExecutableTargetsForFile(location.getPsiElement().getContainingFile()), true)) != null) {
            if (btc.target != null) {
                newConfigurationWithTemplateDefaults.setName(btc.target.targetName);
            }
            return true;
        }
        return false;
    }

    public boolean isConfigurationFromContext(@NotNull CONFIGURATION savedConfiguration, @NotNull ConfigurationContext context2) {
        Location location = context2.getLocation();
        if (location != null && CidrTargetRunLineMarkerProvider.isInEntryPointBody(location.getPsiElement()) && this.getConfigurationType().equals(savedConfiguration.getType())) {
            BuildTargetAndConfigurationData fromContext = this.findBuiltTargetAndConfiguration(savedConfiguration, this.getExecutableTargetsForFile(location.getPsiElement().getContainingFile()), false);
            BuildTargetAndConfigurationData saved = ((CidrRunConfiguration)savedConfiguration).getTargetAndConfigurationData();
            return saved != null && fromContext != null && Objects.equals(saved.target, fromContext.target);
        }
        return false;
    }

    @Nullable
    public static synchronized CidrTargetRunConfigurationProducer getInstance(@NotNull Project project2) {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        for (RunConfigurationProducer cp : RunConfigurationProducer.getProducers((Project)project2)) {
            if (!(cp instanceof CidrTargetRunConfigurationProducer)) continue;
            INSTANCE = (CidrTargetRunConfigurationProducer)cp;
            return INSTANCE;
        }
        return null;
    }
}

