/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PredefinedVariables {
    public static final String JETBRAINS_IDE = "JETBRAINS_IDE";

    @NotNull
    public static List<String> getIDEVariables() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        if (applicationInfo == null) {
            return Collections.singletonList(JETBRAINS_IDE);
        }
        String ideName = StringUtil.toUpperCase((String)ApplicationNamesInfo.getInstance().getProductName()) + "_IDE".replaceAll("\\W", "_");
        return ContainerUtil.immutableList((Object[])new String[]{JETBRAINS_IDE, ideName});
    }

    @NotNull
    public static String getVersionNumber() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        if (applicationInfo == null || ApplicationManager.getApplication().isUnitTestMode()) {
            return PredefinedVariables.toVersionNumber("2017.1");
        }
        return PredefinedVariables.toVersionNumber(applicationInfo.getFullVersion());
    }

    static String toVersionNumber(@NotNull String version) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(version.split("\\D")));
        while (parts.size() < 3) {
            parts.add("00");
        }
        String major = (String)parts.get(0);
        String minor = (String)parts.get(1);
        String bugfix = (String)parts.get(2);
        if (major.length() < 4) {
            major = StringUtil.repeat((String)"0", (int)(4 - major.length())) + major;
        }
        if (minor.length() < 2) {
            minor = StringUtil.repeat((String)"0", (int)(2 - minor.length())) + minor;
        }
        if (bugfix.length() < 2) {
            bugfix = StringUtil.repeat((String)"0", (int)(2 - bugfix.length())) + bugfix;
        }
        return major + minor + bugfix;
    }
}

