/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrPathManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + CidrPathManager.class.getPackage().getName()));
    private static Path ourCidrRootPath;
    private static final Map<Class<?>, Ref<Path>> ourPluginPathsCache;
    private static final Set<Path> ourFileWithExecutableUpdated;

    public static Path getCidrSourcesRoot() {
        if (ourCidrRootPath == null) {
            ourCidrRootPath = Paths.get(PathManager.getHomePath(), System.getProperty("cidr.root.path", "CIDR"));
        }
        return ourCidrRootPath;
    }

    @NotNull
    public static String getPlatformRelativePath(@NotNull String relativePath) {
        return (SystemInfo.isWindows ? "win/" : (SystemInfo.isMac ? "mac/" : "linux/")) + relativePath;
    }

    @NotNull
    public static File getBinFile(@NotNull Class<?> clazz, @NotNull String inSourcesPath, @NotNull String relativePath, @Nullable String relativePathToAdditionalBinaries) {
        return CidrPathManager.getBinPath(clazz, inSourcesPath, relativePath, relativePathToAdditionalBinaries).toFile();
    }

    @NotNull
    public static Path getBinPath(@NotNull Class<?> clazz, @NotNull String inSourcesPath, @NotNull String relativePath, @Nullable String relativePathToAdditionalBinaries) {
        Path pluginPath = CidrPathManager.getPluginPath(clazz);
        if (pluginPath != null) {
            Path result2 = CidrPathManager.ensureFileIsExecutable(pluginPath.resolve("bin/" + relativePath));
            if (relativePathToAdditionalBinaries != null) {
                CidrPathManager.ensureFilesInDirAreExecutable(pluginPath.resolve("bin/" + relativePathToAdditionalBinaries));
            }
            return result2;
        }
        if (PluginManagerCore.isRunningFromSources()) {
            Path result3 = CidrPathManager.ensureFileIsExecutable(CidrPathManager.getCidrSourcesRoot().resolve(inSourcesPath + "/" + relativePath));
            if (relativePathToAdditionalBinaries != null) {
                CidrPathManager.ensureFilesInDirAreExecutable(CidrPathManager.getCidrSourcesRoot().resolve(inSourcesPath + "/" + relativePathToAdditionalBinaries));
            }
            return result3;
        }
        return Paths.get(PathManager.getBinPath(), relativePath);
    }

    private static void ensureFilesInDirAreExecutable(@NotNull Path dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path child : stream) {
                CidrPathManager.ensureFileIsExecutable(child);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static Path ensureFileIsExecutable(@NotNull Path file2) {
        if (ourFileWithExecutableUpdated.contains(file2)) {
            return file2;
        }
        if (Files.isRegularFile(file2, new LinkOption[0]) && !Files.isExecutable(file2)) {
            LOG.info("Setting executable flag for " + file2);
            EnumSet<PosixFilePermission> perms = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.GROUP_EXECUTE);
            try {
                perms.addAll(Files.getPosixFilePermissions(file2, new LinkOption[0]));
                Files.setPosixFilePermissions(file2, perms);
            }
            catch (IOException e) {
                LOG.warn("Cannot set executable flag for " + file2, (Throwable)e);
            }
        }
        ourFileWithExecutableUpdated.add(file2);
        return file2;
    }

    @Nullable
    private static Path getPluginPath(@NotNull Class<?> clazz) {
        Ref result2 = ourPluginPathsCache.get(clazz);
        if (result2 == null) {
            result2 = new Ref();
            ClassLoader loader = clazz.getClassLoader();
            if (loader instanceof PluginClassLoader) {
                IdeaPluginDescriptor plugin;
                PluginId id = ((PluginClassLoader)loader).getPluginId();
                IdeaPluginDescriptor ideaPluginDescriptor = plugin = id == null ? null : PluginManagerCore.getPlugin((PluginId)id);
                if (plugin != null) {
                    result2.set((Object)plugin.getPluginPath());
                }
            }
            ourPluginPathsCache.putIfAbsent(clazz, (Ref<Path>)result2);
        }
        return (Path)result2.get();
    }

    static {
        ourPluginPathsCache = new ConcurrentHashMap();
        ourFileWithExecutableUpdated = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

