/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartFMap;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomResolveConverter;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.DummyEvaluatedXmlName;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ElementPresentationTemplate;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildInvocationHandler;
import com.intellij.util.xml.impl.CollectionChildDescriptionImpl;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.ConvertAnnotationImpl;
import com.intellij.util.xml.impl.CustomDomChildrenDescriptionImpl;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomCreator;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.DynamicGenericInfo;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.GetInvocation;
import com.intellij.util.xml.impl.IndexedElementInvocationHandler;
import com.intellij.util.xml.impl.Invocation;
import com.intellij.util.xml.impl.InvocationCache;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.impl.SetInvocation;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.impl.VirtualDomParentStrategy;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.util.xml.stubs.ElementStub;
import com.intellij.util.xml.stubs.StubParentStrategy;
import com.intellij.util.xml.stubs.XIncludeStub;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomInvocationHandler
extends UserDataHolderBase
implements InvocationHandler,
DomElement {
    private static final Logger LOG = Logger.getInstance(DomInvocationHandler.class);
    public static final Method ACCEPT_METHOD = ReflectionUtil.getMethod(DomElement.class, (String)"accept", (Class[])new Class[]{DomElementVisitor.class});
    public static final Method ACCEPT_CHILDREN_METHOD = ReflectionUtil.getMethod(DomElement.class, (String)"acceptChildren", (Class[])new Class[]{DomElementVisitor.class});
    private static final JavaMethod ourGetValue = JavaMethod.getMethod(GenericValue.class, (JavaMethodSignature)new JavaMethodSignature("getValue", new Class[0]));
    private final Type myType;
    private final DomManagerImpl myManager;
    private final EvaluatedXmlName myTagName;
    private final AbstractDomChildDescriptionImpl myChildDescription;
    private DomParentStrategy myParentStrategy;
    private volatile long myLastModCount;
    private volatile DomElement myProxy;
    private DomGenericInfoEx myGenericInfo;
    private final InvocationCache myInvocationCache;
    private volatile Converter myScalarConverter = null;
    private volatile SmartFMap<Method, Invocation> myAccessorInvocations = SmartFMap.emptyMap();
    @Nullable
    protected DomStub myStub;

    protected DomInvocationHandler(Type type, DomParentStrategy parentStrategy, @NotNull EvaluatedXmlName tagName, AbstractDomChildDescriptionImpl childDescription, DomManagerImpl manager2, boolean dynamic, @Nullable DomStub stub) {
        this.myManager = manager2;
        this.myParentStrategy = parentStrategy;
        this.myTagName = tagName;
        this.myChildDescription = childDescription;
        this.myStub = stub;
        this.myLastModCount = manager2.getPsiModificationCount();
        this.myType = this.narrowType(type);
        this.myInvocationCache = manager2.getApplicationComponent().getInvocationCache(this.getRawType());
        this.refreshGenericInfo(dynamic);
        if (stub != null) {
            stub.setHandler(this);
        }
    }

    protected Type narrowType(@NotNull Type nominalType) {
        return nominalType;
    }

    @Nullable
    public DomElement getParent() {
        DomInvocationHandler handler = this.getParentHandler();
        return handler == null ? null : handler.getProxy();
    }

    protected final void assertValid() {
        String s = this.checkValidity();
        if (s != null) {
            throw new AssertionError((Object)(this.myType.toString() + " @" + this.hashCode() + "\nclass=" + ((Object)((Object)this)).getClass() + "\nxml=" + this.getXmlElement() + "; " + s));
        }
    }

    @Nullable
    final DomInvocationHandler getParentHandler() {
        return this.getParentStrategy().getParentHandler();
    }

    @Nullable
    public DomStub getStub() {
        return this.myStub;
    }

    @NotNull
    public final Type getDomElementType() {
        return this.myType;
    }

    @Nullable
    protected String getValue() {
        XmlTag tag = this.getXmlTag();
        return tag == null ? null : DomInvocationHandler.getTagValue(tag);
    }

    protected void setValue(@Nullable String value) {
        XmlTag tag = this.ensureTagExists();
        this.myManager.runChange(() -> DomInvocationHandler.setTagValue(tag, value));
        this.myManager.fireEvent(new DomEvent(this.getProxy(), false));
    }

    public void copyFrom(DomElement other) {
        if (other == this.getProxy()) {
            return;
        }
        assert (other.getDomElementType().equals(this.myType)) : "Can't copy from " + other.getDomElementType() + " to " + this.myType;
        if (other.getXmlElement() == null) {
            this.undefine();
            return;
        }
        this.myManager.performAtomicChange(() -> {
            this.ensureXmlElementExists();
            DomInvocationHandler otherInvocationHandler = DomManagerImpl.getDomInvocationHandler(other);
            assert (otherInvocationHandler != null) : other;
            DomGenericInfoEx genericInfo = otherInvocationHandler.getGenericInfo();
            for (AttributeChildDescriptionImpl description2 : genericInfo.getAttributeChildrenDescriptions()) {
                description2.getDomAttributeValue(this).setStringValue(description2.getDomAttributeValue(other).getRawText());
            }
            for (AttributeChildDescriptionImpl description2 : genericInfo.getFixedChildrenDescriptions()) {
                List list = description2.getValues(this.getProxy());
                List otherValues = description2.getValues(other);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    DomElement otherValue = (DomElement)otherValues.get(i2);
                    DomElement value = (DomElement)list.get(i2);
                    if (!DomUtil.hasXml((DomElement)otherValue)) {
                        value.undefine();
                        continue;
                    }
                    value.copyFrom(otherValue);
                }
            }
            for (AttributeChildDescriptionImpl description2 : genericInfo.getCollectionChildrenDescriptions()) {
                for (DomElement value : description2.getValues(this.getProxy())) {
                    value.undefine();
                }
                for (DomElement otherValue : description2.getValues(other)) {
                    description2.addValue(this.getProxy(), otherValue.getDomElementType()).copyFrom(otherValue);
                }
            }
            String stringValue = otherInvocationHandler.getValue();
            if (StringUtil.isNotEmpty((String)stringValue)) {
                this.setValue(stringValue);
            }
        });
        if (!this.myManager.isInsideAtomicChange()) {
            this.myManager.fireEvent(new DomEvent(this.getProxy(), false));
        }
    }

    public <T extends DomElement> T createStableCopy() {
        XmlTag tag = this.getXmlTag();
        if (tag != null && tag.isPhysical()) {
            DomInvocationHandler existing = this.myManager.getDomHandler((XmlElement)tag);
            if (!this.equals((Object)existing)) {
                throw new IllegalStateException((Object)((Object)this) + " != " + (Object)((Object)existing));
            }
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)this.myManager.getProject()).createSmartPsiElementPointer((PsiElement)tag);
            return this.myManager.createStableValue(new StableCopyFactory((SmartPsiElementPointer<? extends XmlTag>)pointer, this.myType, ((Object)((Object)this)).getClass()));
        }
        return (T)this.createPathStableCopy();
    }

    protected DomElement createPathStableCopy() {
        throw new UnsupportedOperationException();
    }

    public final <T extends DomElement> T createMockCopy(boolean physical) {
        Object copy2 = this.myManager.createMockElement(this.getRawType(), this.getProxy().getModule(), physical);
        copy2.copyFrom(this.getProxy());
        return (T)copy2;
    }

    @NotNull
    public String getXmlElementNamespace() {
        DomInvocationHandler parent = this.getParentHandler();
        assert (parent != null) : "this operation should be performed on the DOM having a physical parent, your DOM may be not very fresh";
        XmlElement element = parent.getXmlElement();
        assert (element != null);
        return this.getXmlName().getNamespace(element, this.getFile());
    }

    @Nullable
    public String getXmlElementNamespaceKey() {
        return this.getXmlName().getXmlName().getNamespaceKey();
    }

    public final Module getModule() {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getFile());
        return module2 != null ? module2 : (Module)DomUtil.getFile((DomElement)this).getUserData(DomManager.MOCK_ELEMENT_MODULE);
    }

    public XmlTag ensureTagExists() {
        this.assertValid();
        XmlTag tag = this.getXmlTag();
        if (tag != null) {
            return tag;
        }
        tag = this.setEmptyXmlTag();
        this.setXmlElement((XmlElement)tag);
        DomElement element = this.getProxy();
        this.myManager.fireEvent(new DomEvent(element, true));
        this.addRequiredChildren();
        return this.getXmlTag();
    }

    public XmlElement getXmlElement() {
        return this.getParentStrategy().getXmlElement();
    }

    public boolean exists() {
        return this.getParentStrategy().isPhysical();
    }

    private DomParentStrategy getParentStrategy() {
        this.myParentStrategy = this.myParentStrategy.refreshStrategy(this);
        return this.myParentStrategy;
    }

    public XmlElement ensureXmlElementExists() {
        return this.ensureTagExists();
    }

    protected final XmlTag createChildTag(EvaluatedXmlName tagName) {
        String localName = tagName.getXmlName().getLocalName();
        if (localName.contains(":")) {
            try {
                return XmlElementFactory.getInstance((Project)this.myManager.getProject()).createTagFromText((CharSequence)("<" + localName + "/>"));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        XmlElement element = this.getXmlElement();
        assert (element != null);
        return this.getXmlTag().createChildTag(localName, tagName.getNamespace(element, this.getFile()), null, false);
    }

    public final boolean isValid() {
        return this.checkValidity() == null;
    }

    String toStringEx() {
        return this.myType.toString() + " @" + this.hashCode() + "&handler=" + super.toString() + "&cd=" + this.myChildDescription + "&ps=" + this.myParentStrategy;
    }

    @Nullable
    protected String checkValidity() {
        ProgressManager.checkCanceled();
        DomParentStrategy parentStrategy = this.getParentStrategy();
        String error = parentStrategy.checkValidity();
        if (error != null) {
            return "Strategy: " + error;
        }
        long modCount = this.myManager.getPsiModificationCount();
        if (this.myLastModCount == modCount) {
            return null;
        }
        XmlElement xmlElement = parentStrategy.getXmlElement();
        if (xmlElement != null) {
            DomInvocationHandler actual = this.myManager.getDomHandler(xmlElement);
            if (!this.equals((Object)actual)) {
                return "element changed: " + this.toStringEx() + "!=" + (actual == null ? null : actual.toStringEx());
            }
            this.myLastModCount = modCount;
            return null;
        }
        DomInvocationHandler parent = this.getParentHandler();
        if (parent == null) {
            return "no parent: " + this.getDomElementType();
        }
        error = parent.checkValidity();
        if (error != null) {
            return "parent: " + error;
        }
        this.myLastModCount = modCount;
        return null;
    }

    @NotNull
    public final DomGenericInfoEx getGenericInfo() {
        return this.myGenericInfo;
    }

    protected abstract void undefineInternal();

    public final void undefine() {
        this.undefineInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deleteTag(XmlTag tag) {
        boolean changing = this.myManager.setChanging(true);
        try {
            tag.delete();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myManager.setChanging(changing);
        }
    }

    protected final void fireUndefinedEvent() {
        this.myManager.fireEvent(new DomEvent(this.getProxy(), false));
    }

    protected abstract XmlTag setEmptyXmlTag();

    protected void addRequiredChildren() {
        for (AbstractDomChildrenDescription description2 : this.getGenericInfo().getChildrenDescriptions()) {
            if (description2 instanceof DomAttributeChildDescription) {
                Required required = (Required)description2.getAnnotation(Required.class);
                if (required == null || !required.value()) continue;
                ((DomElement)description2.getValues(this.getProxy()).get(0)).ensureXmlElementExists();
                continue;
            }
            if (!(description2 instanceof DomFixedChildDescription)) continue;
            DomFixedChildDescription childDescription = (DomFixedChildDescription)description2;
            List values = null;
            int count = childDescription.getCount();
            for (int i2 = 0; i2 < count; ++i2) {
                Required required = (Required)childDescription.getAnnotation(i2, Required.class);
                if (required == null || !required.value()) continue;
                if (values == null) {
                    values = description2.getValues(this.getProxy());
                }
                ((DomElement)values.get(i2)).ensureTagExists();
            }
        }
    }

    @NotNull
    public final String getXmlElementName() {
        return this.myTagName.getXmlName().getLocalName();
    }

    @NotNull
    public final EvaluatedXmlName getXmlName() {
        return this.myTagName;
    }

    public void accept(DomElementVisitor visitor) {
        ProgressManager.checkCanceled();
        this.myManager.getApplicationComponent().getVisitorDescription(visitor.getClass()).acceptElement(visitor, this.getProxy());
    }

    public void acceptChildren(DomElementVisitor visitor) {
        ProgressManager.checkCanceled();
        DomElement element = this.getProxy();
        List descriptions = this.getGenericInfo().getChildrenDescriptions();
        int descriptionsSize = descriptions.size();
        for (int i2 = 0; i2 < descriptionsSize; ++i2) {
            AbstractDomChildrenDescription description2 = (AbstractDomChildrenDescription)descriptions.get(i2);
            List values = description2.getValues(element);
            int valuesSize = values.size();
            for (int j = 0; j < valuesSize; ++j) {
                DomElement value = (DomElement)values.get(j);
                value.accept(visitor);
            }
        }
    }

    @NotNull
    protected final Converter getScalarConverter() {
        Converter converter = this.myScalarConverter;
        if (converter == null) {
            this.myScalarConverter = converter = this.createConverter(ourGetValue);
        }
        return converter;
    }

    @NotNull
    private Converter createConverter(final JavaMethod method) {
        Converter converter;
        Type returnType = method.getGenericReturnType();
        Type type = returnType == Void.TYPE ? method.getGenericParameterTypes()[0] : returnType;
        Class parameter = DomUtil.substituteGenericType((Type)type, (Type)this.myType);
        if (parameter == null) {
            LOG.error(type + " " + this.myType);
        }
        if ((converter = this.getConverter(new AnnotatedElement(){

            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return DomInvocationHandler.this.myInvocationCache.getMethodAnnotation(method, annotationClass);
            }
        }, parameter)) == null && type instanceof TypeVariable) {
            converter = this.getConverter((AnnotatedElement)this, DomUtil.getGenericValueParameter((Type)this.myType));
        }
        if (converter == null) {
            converter = this.myManager.getConverterManager().getConverterByClass(parameter);
        }
        if (converter == null) {
            throw new AssertionError((Object)("No converter specified: String<->" + parameter.getName() + "; method=" + method + "; place=" + this.myChildDescription));
        }
        return converter;
    }

    public AbstractDomChildDescriptionImpl getChildDescription() {
        return this.myChildDescription;
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Annotation annotation;
        AbstractDomChildDescriptionImpl childDescription = this.getChildDescription();
        if (childDescription != null && (annotation = childDescription.getAnnotation(annotationClass)) != null) {
            return (T)annotation;
        }
        return this.getClassAnnotation(annotationClass);
    }

    protected <T extends Annotation> T getClassAnnotation(Class<T> annotationClass) {
        return this.myInvocationCache.getClassAnnotation(annotationClass);
    }

    @Nullable
    private Converter getConverter(AnnotatedElement annotationProvider, Class parameter) {
        Resolve resolveAnnotation = (Resolve)annotationProvider.getAnnotation(Resolve.class);
        if (resolveAnnotation != null) {
            Class aClass = resolveAnnotation.value();
            if (!DomElement.class.equals((Object)aClass)) {
                return DomResolveConverter.createConverter((Class)aClass);
            }
            LOG.assertTrue(parameter != null, (Object)"You should specify @Resolve#value() parameter");
            return DomResolveConverter.createConverter((Class)parameter);
        }
        ConverterManager converterManager = this.myManager.getConverterManager();
        Convert convertAnnotation = (Convert)annotationProvider.getAnnotation(Convert.class);
        if (convertAnnotation != null) {
            if (convertAnnotation instanceof ConvertAnnotationImpl) {
                return ((ConvertAnnotationImpl)convertAnnotation).getConverter();
            }
            return converterManager.getConverterInstance(convertAnnotation.value());
        }
        return null;
    }

    @NotNull
    public final DomElement getProxy() {
        DomElement proxy = this.myProxy;
        if (proxy == null) {
            Class[] classArray;
            Class<?> rawType = this.getRawType();
            Class<Object> implementation = this.myManager.getApplicationComponent().getImplementation(rawType);
            boolean isInterface = rawType.isInterface();
            if (implementation == null && !isInterface) {
                implementation = rawType;
            }
            if (isInterface) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = rawType;
            } else {
                classArray = ArrayUtil.EMPTY_CLASS_ARRAY;
            }
            this.myProxy = proxy = (DomElement)AdvancedProxy.createProxy((InvocationHandler)this, implementation, (Class[])classArray);
        }
        return proxy;
    }

    @NotNull
    public final XmlFile getFile() {
        return this.getParentStrategy().getContainingFile(this);
    }

    @NotNull
    public DomNameStrategy getNameStrategy() {
        Class<?> rawType = this.getRawType();
        DomNameStrategy strategy2 = DomImplUtil.getDomNameStrategy(rawType, this.isAttribute());
        if (strategy2 != null) {
            return strategy2;
        }
        DomInvocationHandler handler = this.getParentHandler();
        return handler == null ? DomNameStrategy.HYPHEN_STRATEGY : handler.getNameStrategy();
    }

    protected boolean isAttribute() {
        return false;
    }

    @NotNull
    public ElementPresentation getPresentation() {
        ElementPresentationTemplate template = this.getChildDescription().getPresentationTemplate();
        if (template != null) {
            return template.createPresentation(this.getProxy());
        }
        return new ElementPresentation(){

            public String getElementName() {
                return ElementPresentationManager.getElementName((Object)DomInvocationHandler.this.getProxy());
            }

            public String getTypeName() {
                return ElementPresentationManager.getTypeNameForObject((Object)DomInvocationHandler.this.getProxy());
            }

            public Icon getIcon() {
                return ElementPresentationManager.getIconOld((Object)DomInvocationHandler.this.getProxy());
            }
        };
    }

    public final GlobalSearchScope getResolveScope() {
        return DomUtil.getFile((DomElement)this).getResolveScope();
    }

    private static <T extends DomElement> T _getParentOfType(Class<T> requiredClass, DomElement element) {
        while (element != null && !requiredClass.isInstance(element)) {
            element = element.getParent();
        }
        return (T)element;
    }

    public final <T extends DomElement> T getParentOfType(Class<T> requiredClass, boolean strict) {
        return DomInvocationHandler._getParentOfType(requiredClass, strict ? this.getParent() : this.getProxy());
    }

    @NotNull
    final DomInvocationHandler getFixedChild(Pair<? extends FixedChildDescriptionImpl, Integer> info) {
        List<XmlTag> tags;
        FixedChildDescriptionImpl description2 = (FixedChildDescriptionImpl)info.first;
        XmlName xmlName = description2.getXmlName();
        EvaluatedXmlName evaluatedXmlName = this.createEvaluatedXmlName(xmlName);
        if (this.myStub != null && description2.isStubbed()) {
            List<DomStub> stubs = this.myStub.getChildrenByName(xmlName);
            DomStub stub = stubs.isEmpty() ? null : stubs.get(0);
            StubParentStrategy strategy2 = stub == null ? new StubParentStrategy.Empty(this.myStub) : new StubParentStrategy(stub);
            return new IndexedElementInvocationHandler(evaluatedXmlName, description2, 0, strategy2, this.myManager, (ElementStub)stub);
        }
        XmlTag tag = this.getXmlTag();
        int index = (Integer)info.second;
        if (tag != null && (tags = DomImplUtil.findSubTags(tag.getSubTags(), evaluatedXmlName, this.getFile())).size() > index) {
            XmlTag child = tags.get(index);
            DomInvocationHandler handler = this.myManager.getDomHandler((XmlElement)child);
            if (!(handler instanceof IndexedElementInvocationHandler)) {
                DomInvocationHandler take2 = this.myManager.getDomHandler((XmlElement)child);
                throw new AssertionError((Object)("Expected indexed DOM, but got " + (Object)((Object)handler) + ". Parent=" + tag + "; child=" + child + "; index=" + index + "; second attempt=" + (Object)((Object)take2)));
            }
            return handler;
        }
        return new IndexedElementInvocationHandler(evaluatedXmlName, description2, index, new VirtualDomParentStrategy(this), this.myManager, null);
    }

    @NotNull
    final DomInvocationHandler getAttributeChild(AttributeChildDescriptionImpl description2) {
        EvaluatedXmlName evaluatedXmlName = this.createEvaluatedXmlName(description2.getXmlName());
        if (this.myStub != null && description2.isStubbed()) {
            AttributeStub stub = this.myStub.getAttributeStub(description2.getXmlName());
            StubParentStrategy strategy2 = StubParentStrategy.createAttributeStrategy(stub, this.myStub);
            return new AttributeChildInvocationHandler(evaluatedXmlName, description2, this.myManager, strategy2, stub);
        }
        XmlTag tag = this.getXmlTag();
        if (tag != null) {
            String ns = evaluatedXmlName.getNamespace((XmlElement)tag, this.getFile());
            XmlAttribute attribute = tag.getAttribute(description2.getXmlName().getLocalName(), ns.equals(tag.getNamespace()) ? null : ns);
            if (attribute != null) {
                PsiUtilCore.ensureValid((PsiElement)attribute);
                DomInvocationHandler handler = this.myManager.getDomHandler((XmlElement)attribute);
                if (!(handler instanceof AttributeChildInvocationHandler)) {
                    throw new AssertionError((Object)("Expected indexed DOM, but got " + (Object)((Object)handler) + "; ns=" + ns + "; description=" + description2 + "; attribute=" + attribute.getName() + "; XML consistent=" + (PhysicalDomParentStrategy.getParentTag((XmlElement)attribute) == tag) + "; DOM consistent =" + this.equals((Object)DomCreator.getParentDom(tag)) + "; re-creation=" + (Object)((Object)DomCreator.createAttributeHandler(attribute))));
                }
                return handler;
            }
        }
        return new AttributeChildInvocationHandler(evaluatedXmlName, description2, this.myManager, new VirtualDomParentStrategy(this), null);
    }

    @Nullable
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.findInvocation(method).invoke(this, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    @NotNull
    private Invocation findInvocation(Method method) {
        Invocation invocation = (Invocation)this.myAccessorInvocations.get((Object)method);
        if (invocation != null) {
            return invocation;
        }
        invocation = this.myInvocationCache.getInvocation(method);
        if (invocation != null) {
            return invocation;
        }
        invocation = this.createAccessorInvocation(method);
        this.myAccessorInvocations = this.myAccessorInvocations.plus((Object)method, (Object)invocation);
        return invocation;
    }

    @NotNull
    private Invocation createAccessorInvocation(Method method) {
        Invocation invocation;
        JavaMethod javaMethod = this.myInvocationCache.getInternedMethod(method);
        if (this.myInvocationCache.isTagValueGetter(javaMethod)) {
            invocation = new GetInvocation(this.createConverter(javaMethod));
        } else if (this.myInvocationCache.isTagValueSetter(javaMethod)) {
            invocation = new SetInvocation(this.createConverter(javaMethod));
        } else {
            throw new RuntimeException("No implementation for method " + method.toString() + " in class " + this.myType);
        }
        return invocation;
    }

    private static void setTagValue(XmlTag tag, String value) {
        tag.getValue().setText(value);
    }

    private static String getTagValue(XmlTag tag) {
        return tag.getValue().getTrimmedText();
    }

    public final String toString() {
        if (ReflectionUtil.isAssignable(GenericValue.class, this.getRawType())) {
            return ((GenericValue)this.getProxy()).getStringValue();
        }
        return this.myType.toString() + " @" + this.hashCode();
    }

    public final Class<?> getRawType() {
        return ReflectionUtil.getRawType((Type)this.myType);
    }

    @Nullable
    public XmlTag getXmlTag() {
        return (XmlTag)this.getXmlElement();
    }

    @Nullable
    protected XmlElement recomputeXmlElement(@NotNull DomInvocationHandler parentHandler) {
        return null;
    }

    protected final void detach() {
        this.setXmlElement(null);
    }

    protected final void setXmlElement(XmlElement element) {
        this.refreshGenericInfo(element != null && !this.isAttribute());
        this.myStub = null;
        this.myParentStrategy = element == null ? this.myParentStrategy.clearXmlElement() : this.myParentStrategy.setXmlElement(element);
    }

    private void refreshGenericInfo(boolean dynamic) {
        StaticGenericInfo staticInfo = this.myManager.getApplicationComponent().getStaticGenericInfo(this.myType);
        this.myGenericInfo = dynamic ? new DynamicGenericInfo(this, staticInfo) : staticInfo;
    }

    @NotNull
    public final DomManagerImpl getManager() {
        return this.myManager;
    }

    public final DomElement addCollectionChild(CollectionChildDescriptionImpl description2, Type type, int index) throws IncorrectOperationException {
        EvaluatedXmlName name = this.createEvaluatedXmlName(description2.getXmlName());
        XmlTag tag = this.addEmptyTag(name, index);
        CollectionElementInvocationHandler handler = new CollectionElementInvocationHandler(type, tag, description2, this, null);
        this.myManager.fireEvent(new DomEvent(this.getProxy(), false));
        this.getManager().getTypeChooserManager().getTypeChooser(description2.getType()).distinguishTag(tag, type);
        handler.addRequiredChildren();
        return handler.getProxy();
    }

    protected final void createFixedChildrenTags(EvaluatedXmlName tagName, FixedChildDescriptionImpl description2, int count) {
        XmlTag tag = this.ensureTagExists();
        List<XmlTag> subTags = DomImplUtil.findSubTags(tag, tagName, this.getFile());
        if (subTags.size() < count) {
            this.getFixedChild((Pair<? extends FixedChildDescriptionImpl, Integer>)Pair.create((Object)description2, (Object)(count - 1))).ensureTagExists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlTag addEmptyTag(EvaluatedXmlName tagName, int index) throws IncorrectOperationException {
        XmlTag tag = this.ensureTagExists();
        List<XmlTag> subTags = DomImplUtil.findSubTags(tag, tagName, this.getFile());
        if (subTags.size() < index) {
            index = subTags.size();
        }
        boolean changing = this.myManager.setChanging(true);
        try {
            XmlTag newTag = this.createChildTag(tagName);
            if (index == 0) {
                if (subTags.isEmpty()) {
                    XmlTag xmlTag = (XmlTag)tag.add((PsiElement)newTag);
                    return xmlTag;
                }
                XmlTag xmlTag = (XmlTag)tag.addBefore((PsiElement)newTag, (PsiElement)subTags.get(0));
                return xmlTag;
            }
            XmlTag xmlTag = (XmlTag)tag.addAfter((PsiElement)newTag, (PsiElement)subTags.get(index - 1));
            return xmlTag;
        }
        finally {
            this.myManager.setChanging(changing);
        }
    }

    @NotNull
    public final EvaluatedXmlName createEvaluatedXmlName(XmlName xmlName) {
        return this.getXmlName().evaluateChildName(xmlName);
    }

    public List<? extends DomElement> getCollectionChildren(AbstractCollectionChildDescription description2) {
        return this.getCollectionChildren(description2, true);
    }

    public List<? extends DomElement> getCollectionChildren(AbstractCollectionChildDescription description2, boolean processIncludes) {
        XmlTag tag;
        if (this.myStub != null && description2.isStubbed()) {
            if (description2 instanceof DomChildDescriptionImpl) {
                XmlName xmlName = ((DomChildDescriptionImpl)((Object)description2)).getXmlName();
                SmartList result2 = new SmartList();
                List stubs = this.myStub.getChildrenStubs();
                for (Stub stub2 : stubs) {
                    if (stub2 instanceof DomStub && ((DomStub)stub2).matches(xmlName)) {
                        result2.add((Object)((DomStub)stub2).getOrCreateHandler((DomChildDescriptionImpl)((Object)description2), this.myManager).getProxy());
                        continue;
                    }
                    if (!processIncludes || !(stub2 instanceof XIncludeStub)) continue;
                    ((XIncludeStub)stub2).resolve(this, (List<DomElement>)result2, xmlName);
                }
                return result2;
            }
            if (description2 instanceof CustomDomChildrenDescriptionImpl) {
                List stubs = this.myStub.getChildrenStubs();
                return ContainerUtil.mapNotNull((Collection)stubs, (Function)((NullableFunction)stub -> {
                    if (stub instanceof ElementStub && ((ElementStub)((Object)stub)).isCustom()) {
                        DummyEvaluatedXmlName name = new DummyEvaluatedXmlName(((ElementStub)((Object)stub)).getName(), "");
                        return new CollectionElementInvocationHandler((EvaluatedXmlName)name, (CustomDomChildrenDescriptionImpl)description2, this.myManager, (ElementStub)((Object)stub)).getProxy();
                    }
                    return null;
                }));
            }
        }
        if ((tag = this.getXmlTag()) == null) {
            return Collections.emptyList();
        }
        List<XmlTag> subTags = this.getCollectionSubTags(description2, tag, processIncludes);
        if (subTags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DomElement> elements = new ArrayList<DomElement>(subTags.size());
        for (XmlTag subTag : subTags) {
            DomInvocationHandler handler = this.myManager.getDomHandler((XmlElement)subTag);
            if (handler == null) {
                String msg = "No child for subTag '" + subTag.getName() + "' in tag '" + tag.getName() + "'; subtag count=" + subTags.size() + ", description=" + description2 + ", subtag.class=" + subTag.getClass().getName();
                DomInvocationHandler anyDom = this.myManager.getDomHandler((XmlElement)subTag);
                if (anyDom != null) {
                    msg = msg + "\n sub-dom=" + (Object)((Object)anyDom) + " with " + anyDom.getChildDescription();
                }
                throw new AssertionError((Object)msg);
            }
            elements.add(handler.getProxy());
        }
        return Collections.unmodifiableList(elements);
    }

    private List<XmlTag> getCollectionSubTags(@NotNull AbstractCollectionChildDescription description2, @NotNull XmlTag tag, boolean processIncludes) {
        if (description2 instanceof CollectionChildDescriptionImpl) {
            return ((CollectionChildDescriptionImpl)description2).getCollectionSubTags(this, tag, processIncludes);
        }
        return DomImplUtil.getCustomSubTags(this, tag.getSubTags(), this.getFile());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        DomInvocationHandler that = (DomInvocationHandler)((Object)o);
        if (!this.myChildDescription.equals(that.myChildDescription)) {
            return false;
        }
        return this.getParentStrategy().equals(that.getParentStrategy());
    }

    public int hashCode() {
        return this.myChildDescription.hashCode();
    }

    private static class StableCopyFactory<T extends DomElement>
    implements NullableFactory<T> {
        private final SmartPsiElementPointer<? extends XmlTag> myPointer;
        private final Type myType;
        private final Class<? extends DomInvocationHandler> myHandlerClass;

        StableCopyFactory(SmartPsiElementPointer<? extends XmlTag> pointer, Type type, Class<? extends DomInvocationHandler> aClass) {
            this.myPointer = pointer;
            this.myType = type;
            this.myHandlerClass = aClass;
        }

        public T create() {
            XmlTag tag = (XmlTag)this.myPointer.getElement();
            if (tag == null || !tag.isValid()) {
                return null;
            }
            DomElement element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
            if (element == null || !element.getDomElementType().equals(this.myType)) {
                return null;
            }
            DomInvocationHandler handler = DomManagerImpl.getDomInvocationHandler(element);
            if (handler == null || !((Object)((Object)handler)).getClass().equals(this.myHandlerClass)) {
                return null;
            }
            return (T)element;
        }
    }
}

