/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomElementsNavigationManager;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DomElementsNavigationManagerImpl
extends DomElementsNavigationManager {
    private final Map<String, DomElementNavigationProvider> myProviders = new HashMap<String, DomElementNavigationProvider>();
    private final Project myProject;
    private final DomElementNavigationProvider myTextEditorProvider = new MyDomElementNavigateProvider();

    public DomElementsNavigationManagerImpl(Project project2) {
        this.myProject = project2;
        this.myProviders.put(this.myTextEditorProvider.getProviderName(), this.myTextEditorProvider);
    }

    public Set<DomElementNavigationProvider> getDomElementsNavigateProviders(DomElement domElement) {
        HashSet<DomElementNavigationProvider> result2 = new HashSet<DomElementNavigationProvider>();
        for (DomElementNavigationProvider navigateProvider : this.myProviders.values()) {
            if (!navigateProvider.canNavigate(domElement)) continue;
            result2.add(navigateProvider);
        }
        return result2;
    }

    public DomElementNavigationProvider getDomElementsNavigateProvider(String providerName) {
        return this.myProviders.get(providerName);
    }

    public void registerDomElementsNavigateProvider(DomElementNavigationProvider provider2) {
        this.myProviders.put(provider2.getProviderName(), provider2);
    }

    private class MyDomElementNavigateProvider
    extends DomElementNavigationProvider {
        private MyDomElementNavigateProvider() {
        }

        public String getProviderName() {
            return DomElementsNavigationManager.DEFAULT_PROVIDER_NAME;
        }

        public void navigate(DomElement domElement, boolean requestFocus) {
            if (!domElement.isValid()) {
                return;
            }
            DomFileElement fileElement = DomUtil.getFileElement((DomElement)domElement);
            if (fileElement == null) {
                return;
            }
            VirtualFile file2 = fileElement.getFile().getVirtualFile();
            if (file2 == null) {
                return;
            }
            XmlElement xmlElement = domElement.getXmlElement();
            if (xmlElement instanceof XmlAttribute) {
                xmlElement = ((XmlAttribute)xmlElement).getValueElement();
            }
            OpenFileDescriptor fileDescriptor = xmlElement != null ? new OpenFileDescriptor(DomElementsNavigationManagerImpl.this.myProject, file2, xmlElement.getTextOffset()) : new OpenFileDescriptor(DomElementsNavigationManagerImpl.this.myProject, file2);
            FileEditorManagerEx.getInstanceEx((Project)DomElementsNavigationManagerImpl.this.myProject).openTextEditor(fileDescriptor, requestFocus);
        }

        public boolean canNavigate(DomElement domElement) {
            return domElement != null && domElement.isValid();
        }
    }
}

