/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptor;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.Nullable;

public class DomElementsHighlightingUtil {
    private DomElementsHighlightingUtil() {
    }

    @Nullable
    public static ProblemDescriptor createProblemDescriptors(InspectionManager manager2, DomElementProblemDescriptor problemDescriptor) {
        ProblemHighlightType type = DomElementsHighlightingUtil.getProblemHighlightType(problemDescriptor);
        return (ProblemDescriptor)DomElementsHighlightingUtil.createProblemDescriptors(problemDescriptor, s -> manager2.createProblemDescriptor((PsiElement)s.second, (TextRange)s.first, problemDescriptor.getDescriptionTemplate(), type, true, problemDescriptor.getFixes()));
    }

    private static ProblemHighlightType getProblemHighlightType(DomElementProblemDescriptor problemDescriptor) {
        TextRange range;
        if (problemDescriptor.getHighlightType() != null) {
            return problemDescriptor.getHighlightType();
        }
        if (problemDescriptor instanceof DomElementResolveProblemDescriptor && (range = ((DomElementResolveProblemDescriptor)problemDescriptor).getPsiReference().getRangeInElement()).getStartOffset() != range.getEndOffset()) {
            return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        }
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    @Nullable
    public static Annotation createAnnotation(DomElementProblemDescriptor problemDescriptor) {
        return (Annotation)DomElementsHighlightingUtil.createProblemDescriptors(problemDescriptor, s -> {
            String text = problemDescriptor.getDescriptionTemplate();
            if (StringUtil.isEmpty((String)text)) {
                text = null;
            }
            HighlightSeverity severity = problemDescriptor.getHighlightSeverity();
            TextRange range = (TextRange)s.first;
            if (text == null) {
                range = TextRange.from((int)range.getStartOffset(), (int)0);
            }
            range = range.shiftRight(((PsiElement)s.second).getTextRange().getStartOffset());
            String tooltip = text == null ? null : XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)text));
            Annotation annotation = new Annotation(range.getStartOffset(), range.getEndOffset(), severity, text, tooltip);
            if (problemDescriptor instanceof DomElementResolveProblemDescriptor) {
                annotation.setTextAttributes(CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
            }
            for (LocalQuickFix fix : problemDescriptor.getFixes()) {
                if (!(fix instanceof IntentionAction)) continue;
                annotation.registerFix((IntentionAction)fix);
            }
            return annotation;
        });
    }

    @Nullable
    private static <T> T createProblemDescriptors(DomElementProblemDescriptor problemDescriptor, Function<? super Pair<TextRange, PsiElement>, ? extends T> creator) {
        Pair<TextRange, PsiElement> range = ((DomElementProblemDescriptorImpl)problemDescriptor).getProblemRange();
        return (T)(range == DomElementProblemDescriptorImpl.NO_PROBLEM || !((PsiElement)range.second).isPhysical() ? null : creator.fun(range));
    }
}

