/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlFileImpl;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsHighlightingUtil;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolderImpl;
import com.intellij.util.xml.highlighting.DomHighlightStatus;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.highlighting.DomHighlightingHelperImpl;
import com.intellij.util.xml.highlighting.MockAnnotatingDomInspection;
import com.intellij.util.xml.highlighting.MockDomInspection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementAnnotationsManagerImpl
extends DomElementAnnotationsManager {
    static final Object LOCK = new Object();
    private final EventDispatcher<DomElementAnnotationsManager.DomHighlightingListener> myDispatcher = EventDispatcher.create(DomElementAnnotationsManager.DomHighlightingListener.class);
    private static final DomElementsProblemsHolder EMPTY_PROBLEMS_HOLDER = new DomElementsProblemsHolder(){

        @NotNull
        public List<DomElementProblemDescriptor> getProblems(DomElement domElement) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean withChildren, HighlightSeverity minSeverity) {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getAllProblems() {
            return Collections.emptyList();
        }

        public List<DomElementProblemDescriptor> getAllProblems(@NotNull DomElementsInspection inspection) {
            return Collections.emptyList();
        }

        public boolean isInspectionCompleted(@NotNull DomElementsInspection inspectionClass) {
            return false;
        }
    };
    private final Map<XmlTag, DomElementsProblemsHolderImpl> myHolders = ContainerUtil.createWeakMap();

    public DomElementAnnotationsManagerImpl(@NotNull Project project2) {
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

            public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
                DomElementAnnotationsManagerImpl.this.dropAnnotationsCache();
            }

            public void profileChanged(InspectionProfile profile) {
                DomElementAnnotationsManagerImpl.this.dropAnnotationsCache();
            }
        });
        connection.subscribe(PsiModificationTracker.TOPIC, this::dropAnnotationsCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropAnnotationsCache() {
        Object object = LOCK;
        synchronized (object) {
            this.myHolders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<DomElementProblemDescriptor> appendProblems(@NotNull DomFileElement element, @NotNull DomElementAnnotationHolder annotationHolder, Class<? extends DomElementsInspection> inspectionClass) {
        DomElementAnnotationHolderImpl holderImpl = (DomElementAnnotationHolderImpl)annotationHolder;
        Object object = LOCK;
        synchronized (object) {
            DomElementsProblemsHolderImpl holder = this._getOrCreateProblemsHolder(element);
            holder.appendProblems(holderImpl, inspectionClass);
        }
        ((DomElementAnnotationsManager.DomHighlightingListener)this.myDispatcher.getMulticaster()).highlightingFinished(element);
        return Collections.unmodifiableList(holderImpl);
    }

    @NotNull
    private DomElementsProblemsHolderImpl _getOrCreateProblemsHolder(DomFileElement element) {
        XmlTag rootTag = element.getRootElement().getXmlTag();
        if (rootTag == null) {
            return new DomElementsProblemsHolderImpl(element);
        }
        return this.myHolders.computeIfAbsent(rootTag, __ -> new DomElementsProblemsHolderImpl(element));
    }

    public boolean isHolderUpToDate(DomElement element) {
        return !this.isHolderOutdated(DomUtil.getFile((DomElement)element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outdateProblemHolder(DomElement element) {
        XmlTag rootTag = DomElementAnnotationsManagerImpl.getRootTagIfParsed(DomUtil.getFile((DomElement)element));
        Object object = LOCK;
        synchronized (object) {
            if (rootTag != null) {
                this.myHolders.remove(rootTag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHolderOutdated(XmlFile file2) {
        Object object = LOCK;
        synchronized (object) {
            XmlTag rootTag = DomElementAnnotationsManagerImpl.getRootTagIfParsed(file2);
            return rootTag == null || !this.myHolders.containsKey(rootTag);
        }
    }

    @Nullable
    private static XmlTag getRootTagIfParsed(@NotNull XmlFile file2) {
        return ((XmlFileImpl)file2).isContentsLoaded() ? file2.getRootTag() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DomElementsProblemsHolder getProblemHolder(DomElement element) {
        if (element == null || !element.isValid()) {
            return EMPTY_PROBLEMS_HOLDER;
        }
        DomFileElement fileElement = DomUtil.getFileElement((DomElement)element);
        Object object = LOCK;
        synchronized (object) {
            DomElementsProblemsHolder readyHolder;
            XmlTag tag = fileElement.getRootElement().getXmlTag();
            if (tag != null && (readyHolder = (DomElementsProblemsHolder)this.myHolders.get(tag)) != null) {
                return readyHolder;
            }
            return EMPTY_PROBLEMS_HOLDER;
        }
    }

    @NotNull
    public DomElementsProblemsHolder getCachedProblemHolder(DomElement element) {
        return this.getProblemHolder(element);
    }

    public List<ProblemDescriptor> createProblemDescriptors(InspectionManager manager2, DomElementProblemDescriptor problemDescriptor) {
        return ContainerUtil.createMaybeSingletonList((Object)DomElementsHighlightingUtil.createProblemDescriptors(manager2, problemDescriptor));
    }

    public boolean isHighlightingFinished(DomElement[] domElements) {
        for (DomElement domElement : domElements) {
            if (this.getHighlightStatus(domElement) == DomHighlightStatus.INSPECTIONS_FINISHED) continue;
            return false;
        }
        return true;
    }

    public void addHighlightingListener(DomElementAnnotationsManager.DomHighlightingListener listener, Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public DomHighlightingHelper getHighlightingHelper() {
        return DomHighlightingHelperImpl.INSTANCE;
    }

    @NotNull
    public <T extends DomElement> List<DomElementProblemDescriptor> checkFileElement(@NotNull DomFileElement<T> domFileElement, @NotNull DomElementsInspection<T> inspection, boolean onTheFly) {
        DomElementsProblemsHolder problemHolder = this.getProblemHolder((DomElement)domFileElement);
        if (this.isHolderUpToDate((DomElement)domFileElement) && problemHolder.isInspectionCompleted(inspection)) {
            return problemHolder.getAllProblems(inspection);
        }
        DomElementAnnotationHolderImpl holder = new DomElementAnnotationHolderImpl(onTheFly, domFileElement);
        inspection.checkFileElement(domFileElement, (DomElementAnnotationHolder)holder);
        return this.appendProblems(domFileElement, holder, inspection.getClass());
    }

    public List<DomElementsInspection> getSuitableDomInspections(DomFileElement fileElement, boolean enabledOnly) {
        Class rootType = fileElement.getRootElementClass();
        InspectionProfile profile = this.getInspectionProfile(fileElement);
        SmartList inspections = new SmartList();
        for (InspectionToolWrapper toolWrapper : profile.getInspectionTools((PsiElement)fileElement.getFile())) {
            InspectionProfileEntry entry;
            if (enabledOnly && !profile.isToolEnabled(HighlightDisplayKey.find((String)toolWrapper.getShortName()), (PsiElement)fileElement.getFile()) || !((entry = toolWrapper.getTool()) instanceof DomElementsInspection) || !ContainerUtil.exists((Iterable)((DomElementsInspection)entry).getDomClasses(), cls -> cls.isAssignableFrom(rootType))) continue;
            inspections.add((DomElementsInspection)entry);
        }
        return inspections;
    }

    protected InspectionProfile getInspectionProfile(DomFileElement fileElement) {
        return InspectionProjectProfileManager.getInstance((Project)fileElement.getManager().getProject()).getCurrentProfile();
    }

    @Nullable
    public <T extends DomElement> DomElementsInspection<T> getMockInspection(DomFileElement<? extends T> root) {
        if (root.getFileDescription().isAutomaticHighlightingEnabled()) {
            return new MockAnnotatingDomInspection(root.getRootElementClass());
        }
        if (this.getSuitableDomInspections(root, false).isEmpty()) {
            return new MockDomInspection(root.getRootElementClass());
        }
        return null;
    }

    private static boolean areInspectionsFinished(DomElementsProblemsHolderImpl holder, List<? extends DomElementsInspection> suitableInspections) {
        for (DomElementsInspection domElementsInspection : suitableInspections) {
            if (holder.isInspectionCompleted(domElementsInspection)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DomHighlightStatus getHighlightStatus(DomElement element) {
        Object object = LOCK;
        synchronized (object) {
            DomElementsProblemsHolder holder;
            DomFileElement root = DomUtil.getFileElement((DomElement)element);
            if (!this.isHolderOutdated(root.getFile()) && (holder = this.getProblemHolder(element)) instanceof DomElementsProblemsHolderImpl) {
                DomElementsProblemsHolderImpl holderImpl = (DomElementsProblemsHolderImpl)holder;
                List<DomElementsInspection> suitableInspections = this.getSuitableDomInspections(root, true);
                DomElementsInspection mockInspection = this.getMockInspection(root);
                boolean annotatorsFinished = mockInspection == null || holderImpl.isInspectionCompleted(mockInspection);
                boolean inspectionsFinished = DomElementAnnotationsManagerImpl.areInspectionsFinished(holderImpl, suitableInspections);
                if (annotatorsFinished) {
                    if (suitableInspections.isEmpty() || inspectionsFinished) {
                        return DomHighlightStatus.INSPECTIONS_FINISHED;
                    }
                    return DomHighlightStatus.ANNOTATORS_FINISHED;
                }
            }
            return DomHighlightStatus.NONE;
        }
    }
}

