/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.plugin.ui.filters.Filter;
import com.intellij.structuralsearch.plugin.ui.filters.FilterTable;
import com.intellij.ui.SimpleColoredComponent;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public abstract class FilterAction
extends AnAction
implements Filter {
    private static final AtomicInteger myFilterCount = new AtomicInteger();
    protected final SimpleColoredComponent myLabel = new SimpleColoredComponent();
    protected final FilterTable myTable;
    private final int myPosition;
    private boolean myApplicable = true;

    protected FilterAction(@NotNull Supplier<String> text, FilterTable table) {
        super(text);
        this.myTable = table;
        this.myPosition = myFilterCount.incrementAndGet();
    }

    @Override
    public final int position() {
        return this.myPosition;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        this.initFilter();
        this.myApplicable = false;
        this.myTable.addFilter(this);
    }

    public final SimpleColoredComponent getRenderer() {
        this.myLabel.clear();
        this.setLabel(this.myLabel);
        return this.myLabel;
    }

    protected abstract void setLabel(SimpleColoredComponent var1);

    public abstract boolean hasFilter();

    protected void initFilter() {
    }

    public abstract void clearFilter();

    public void reset() {
        this.myApplicable = true;
    }

    protected abstract boolean isApplicable(List<? extends PsiElement> var1, boolean var2, boolean var3);

    public boolean isAvailable() {
        return this.myApplicable && !this.hasFilter();
    }

    public boolean checkApplicable(List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        this.myApplicable = this.isApplicable(nodes, completePattern, target);
        return this.myApplicable;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(!this.hasFilter() && this.myApplicable);
    }
}

