/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class StructuralSearchTemplatesCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        String prefix;
        Boolean test;
        StructuralSearchDialog dialog = (StructuralSearchDialog)((Object)parameters.getEditor().getUserData(StructuralSearchDialog.STRUCTURAL_SEARCH_DIALOG));
        if (!(dialog != null || (test = (Boolean)parameters.getEditor().getUserData(StructuralSearchDialog.TEST_STRUCTURAL_SEARCH_DIALOG)) != null && test.booleanValue())) {
            return;
        }
        Document document2 = parameters.getEditor().getDocument();
        int end = parameters.getOffset();
        int line = document2.getLineNumber(end);
        int start = document2.getLineStartOffset(line);
        String shortPrefix = TextFieldWithAutoCompletionListProvider.getCompletionPrefix((CompletionParameters)parameters);
        CharSequence text = document2.getCharsSequence();
        if (StringUtil.startsWithChar((CharSequence)shortPrefix, (char)'$')) {
            shortPrefix = shortPrefix.substring(1);
            LinkedHashSet variableNames = TemplateImplUtil.parseVariableNames((CharSequence)text);
            for (String name : variableNames) {
                if (!name.startsWith(shortPrefix) || name.equals(shortPrefix)) continue;
                result2.addElement((LookupElement)LookupElementBuilder.create((String)('$' + name + '$')).withInsertHandler((context2, item) -> {
                    char c;
                    int offset = context2.getTailOffset();
                    if (text.length() > offset + 1 && (c = text.charAt(offset)) == '$') {
                        document2.deleteString(offset, offset + 1);
                    }
                }));
            }
        }
        String string = prefix = parameters.isExtendedCompletion() ? shortPrefix : text.subSequence(start, end).toString();
        if (StringUtil.containsChar((String)prefix, (char)'$')) {
            return;
        }
        result2.runRemainingContributors(parameters, cr -> {
            if (cr.getLookupElement().getObject() instanceof String) {
                return;
            }
            result2.passResult(cr);
        });
        CompletionResultSet insensitive = result2.withPrefixMatcher((PrefixMatcher)new CamelHumpMatcher(prefix));
        ConfigurationManager configurationManager = ConfigurationManager.getInstance(parameters.getPosition().getProject());
        for (String configurationName : configurationManager.getAllConfigurationNames()) {
            for (Configuration configuration : configurationManager.findConfigurationsByName(configurationName)) {
                if (configuration == null) continue;
                MatchOptions matchOptions = configuration.getMatchOptions();
                LookupElementBuilder element = LookupElementBuilder.create((Object)configuration, (String)matchOptions.getSearchPattern()).withLookupString(configurationName).withTailText(" (" + StringUtil.toLowerCase((String)matchOptions.getFileType().getName()) + (configuration instanceof SearchConfiguration ? " search" : " replace") + " template" + (configuration.isPredefined() ? "" : ", user defined") + ")", true).withCaseSensitivity(false).withPresentableText(configurationName);
                if (dialog != null) {
                    element = element.withInsertHandler((context2, item) -> context2.setLaterRunnable(() -> dialog.loadConfiguration((Configuration)item.getObject())));
                }
                insensitive.addElement((LookupElement)element);
            }
        }
    }
}

