/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.inspection.StructuralSearchProfileActionProvider;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceCommand;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationCellRenderer;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.ConfigurationUtil;
import com.intellij.structuralsearch.plugin.ui.FileTypeChooser;
import com.intellij.structuralsearch.plugin.ui.LinkComboBox;
import com.intellij.structuralsearch.plugin.ui.ScopePanel;
import com.intellij.structuralsearch.plugin.ui.SearchCommand;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog;
import com.intellij.structuralsearch.plugin.ui.Spacer;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchTemplateBuilder;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.ToolbarLabel;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterPanel;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.IconUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.textCompletion.TextCompletionUtil;
import com.intellij.util.ui.JBRectangle;
import com.intellij.util.ui.TextTransferable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchDialog
extends DialogWrapper
implements DocumentListener {
    @NonNls
    private static final String SEARCH_DIMENSION_SERVICE_KEY = "#com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog";
    @NonNls
    private static final String REPLACE_DIMENSION_SERVICE_KEY = "#com.intellij.structuralsearch.plugin.ui.StructuralReplaceDialog";
    @NonNls
    private static final String RECURSIVE_STATE = "structural.search.recursive";
    @NonNls
    private static final String SHORTEN_FQN_STATE = "structural.search.shorten.fqn";
    @NonNls
    private static final String REFORMAT_STATE = "structural.search.reformat";
    @NonNls
    private static final String USE_STATIC_IMPORT_STATE = "structural.search.use.static.import";
    @NonNls
    private static final String FILTERS_VISIBLE_STATE = "structural.search.filters.visible";
    public static final Key<StructuralSearchDialog> STRUCTURAL_SEARCH_DIALOG = Key.create((String)"STRUCTURAL_SEARCH_DIALOG");
    public static final Key<String> STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID = Key.create((String)"STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID");
    public static final Key<Runnable> STRUCTURAL_SEARCH_ERROR_CALLBACK = Key.create((String)"STRUCTURAL_SEARCH_ERROR_CALLBACK");
    private static final Key<Configuration> STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION = Key.create((String)"STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION");
    public static final Key<Boolean> TEST_STRUCTURAL_SEARCH_DIALOG = Key.create((String)"TEST_STRUCTURAL_SEARCH_DIALOG");
    private final SearchContext mySearchContext;
    Editor myEditor;
    boolean myReplace;
    Configuration myConfiguration;
    @NonNls
    LanguageFileType myFileType = StructuralSearchUtil.getDefaultFileType();
    Language myDialect = null;
    PatternContext myPatternContext = null;
    final List<RangeHighlighter> myRangeHighlighters = new SmartList();
    private final DocumentListener myRestartHighlightingListener = new DocumentListener(){
        final Runnable runnable = () -> ReadAction.nonBlocking(() -> StructuralSearchDialog.this.addMatchHighlights()).withDocumentsCommitted(StructuralSearchDialog.this.getProject()).expireWith(StructuralSearchDialog.this.getDisposable()).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());

        public void documentChanged(@NotNull DocumentEvent event) {
            if (StructuralSearchDialog.this.myAlarm.isDisposed()) {
                return;
            }
            StructuralSearchDialog.this.myAlarm.cancelRequest(this.runnable);
            StructuralSearchDialog.this.myAlarm.addRequest(this.runnable, 100);
        }
    };
    private final Alarm myAlarm;
    private boolean myUseLastConfiguration;
    private final boolean myEditConfigOnly;
    private boolean myDoingOkAction;
    private boolean myFilterIsShowing;
    final FileTypeChooser myFileTypeChooser = new FileTypeChooser();
    ActionToolbarImpl myOptionsToolbar;
    EditorTextField mySearchCriteriaEdit;
    EditorTextField myReplaceCriteriaEdit;
    OnePixelSplitter mySearchEditorPanel;
    FilterPanel myFilterPanel;
    private LinkComboBox myTargetComboBox;
    private ScopePanel myScopePanel;
    private JCheckBox myOpenInNewTab;
    JComponent myReplacePanel;
    Balloon myBalloon = null;

    public StructuralSearchDialog(SearchContext searchContext, boolean replace) {
        this(searchContext, replace, false);
    }

    public StructuralSearchDialog(@NotNull SearchContext searchContext, boolean replace, boolean editConfigOnly) {
        super(searchContext.getProject(), true);
        if (!editConfigOnly) {
            this.setModal(false);
            this.setOKButtonText(FindBundle.message((String)"find.dialog.find.button", (Object[])new Object[0]));
        }
        this.myReplace = replace;
        this.myEditConfigOnly = editConfigOnly;
        this.mySearchContext = searchContext;
        this.myEditor = searchContext.getEditor();
        this.addRestartHighlightingListenerToCurrentEditor();
        FileEditorManagerListener listener = new FileEditorManagerListener(){
            FileEditor myNewEditor;
            final Runnable runnable = () -> {
                StructuralSearchDialog.this.removeRestartHighlightingListenerFromCurrentEditor();
                StructuralSearchDialog.this.removeMatchHighlights();
                if (this.myNewEditor instanceof TextEditor) {
                    StructuralSearchDialog.this.myEditor = ((TextEditor)this.myNewEditor).getEditor();
                    StructuralSearchDialog.this.addMatchHighlights();
                    StructuralSearchDialog.this.addRestartHighlightingListenerToCurrentEditor();
                } else {
                    StructuralSearchDialog.this.myEditor = null;
                }
            };

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (StructuralSearchDialog.this.myAlarm.isDisposed()) {
                    return;
                }
                StructuralSearchDialog.this.myAlarm.cancelRequest(this.runnable);
                this.myNewEditor = event.getNewEditor();
                StructuralSearchDialog.this.myAlarm.addRequest(this.runnable, 100);
            }
        };
        MessageBusConnection connection = this.getProject().getMessageBus().connect(this.getDisposable());
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener);
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                StructuralSearchDialog.this.close(1);
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project2) {
                StructuralSearchDialog.this.close(1);
            }
        });
        this.myConfiguration = this.createConfiguration(null);
        this.setTitle(this.getDefaultTitle());
        this.init();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
    }

    private void addRestartHighlightingListenerToCurrentEditor() {
        if (this.myEditor != null) {
            this.myEditor.getDocument().addDocumentListener(this.myRestartHighlightingListener);
        }
    }

    private void removeRestartHighlightingListenerFromCurrentEditor() {
        if (this.myEditor != null) {
            this.myEditor.getDocument().removeDocumentListener(this.myRestartHighlightingListener);
        }
    }

    public void setUseLastConfiguration(boolean useLastConfiguration) {
        this.myUseLastConfiguration = useLastConfiguration;
    }

    private EditorTextField createEditor(boolean replace) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (profile != null);
        Document document2 = UIUtil.createDocument(this.getProject(), this.myFileType, this.myDialect, this.myPatternContext, "", profile);
        document2.addDocumentListener((DocumentListener)this, this.myDisposable);
        document2.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)(this.myPatternContext == null ? "" : this.myPatternContext.getId()));
        MyEditorTextField textField = new MyEditorTextField(document2, replace);
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        textField.setFont(scheme.getFont(EditorFontType.PLAIN));
        textField.setPreferredSize(new Dimension(550, 150));
        textField.setMinimumSize(new Dimension(200, 50));
        return textField;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        this.initiateValidation();
    }

    void initiateValidation() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            boolean success = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                try {
                    CompiledPattern compiledPattern = this.compilePattern();
                    this.checkReplacementPattern();
                    JRootPane component = this.getRootPane();
                    if (component == null) {
                        return;
                    }
                    this.initializeFilterPanel();
                    if (compiledPattern != null) {
                        this.addMatchHighlights();
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        this.setSearchTargets(this.myConfiguration.getMatchOptions());
                        this.getOKAction().setEnabled(compiledPattern != null);
                    }, ModalityState.stateForComponent((Component)component));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    Logger.getInstance(StructuralSearchDialog.class).error((Throwable)e);
                }
            });
            if (!success) {
                this.initiateValidation();
            }
        }, 100);
    }

    private void initializeFilterPanel() {
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        CompiledPattern compiledPattern = PatternCompiler.compilePattern(this.getProject(), matchOptions, false, false);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (compiledPattern != null) {
                SubstitutionShortInfoHandler.updateEditorInlays(this.mySearchCriteriaEdit.getEditor());
                if (this.myReplace) {
                    SubstitutionShortInfoHandler.updateEditorInlays(this.myReplaceCriteriaEdit.getEditor());
                }
            }
            this.myFilterPanel.setCompiledPattern(compiledPattern);
            if (this.myFilterPanel.getVariable() == null) {
                this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
            }
        }, ModalityState.stateForComponent((Component)this.myFilterPanel.getComponent()));
    }

    private Configuration createConfiguration(Configuration template) {
        if (this.myReplace) {
            return template == null ? new ReplaceConfiguration(StructuralSearchDialog.getUserDefined(), StructuralSearchDialog.getUserDefined()) : new ReplaceConfiguration(template);
        }
        return template == null ? new SearchConfiguration(StructuralSearchDialog.getUserDefined(), StructuralSearchDialog.getUserDefined()) : new SearchConfiguration(template);
    }

    private void setTextFromContext() {
        SelectionModel selectionModel;
        String selectedText;
        Editor editor = this.myEditor;
        if (editor != null && (selectedText = (selectionModel = editor.getSelectionModel()).getSelectedText()) != null) {
            if (this.loadConfiguration(selectedText)) {
                return;
            }
            String text = selectedText.trim();
            this.setTextForEditor(text.trim(), this.mySearchCriteriaEdit);
            if (this.myReplace) {
                this.setTextForEditor(text, this.myReplaceCriteriaEdit);
            }
            this.myScopePanel.setScopesFromContext();
            ApplicationManager.getApplication().invokeLater(() -> this.startTemplate());
            return;
        }
        Configuration previousConfiguration = (Configuration)this.getProject().getUserData(STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION);
        if (previousConfiguration != null) {
            this.loadConfiguration(previousConfiguration);
        } else {
            Configuration configuration = ConfigurationManager.getInstance(this.getProject()).getMostRecentConfiguration();
            if (configuration != null) {
                this.loadConfiguration(configuration);
            }
        }
    }

    private void setTextForEditor(String text, EditorTextField editor) {
        editor.setText(text);
        editor.selectAll();
        Project project2 = this.getProject();
        Document document2 = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        documentManager.commitDocument(document2);
        PsiFile file2 = documentManager.getPsiFile(document2);
        if (file2 == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, (String)SSRBundle.message("command.name.adjust.line.indent", new Object[0]), (String)"Structural Search", () -> CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file2, new TextRange(0, document2.getTextLength())), (PsiFile[])new PsiFile[]{file2});
    }

    private void startSearching() {
        if (this.myReplace) {
            new ReplaceCommand(this.myConfiguration, this.mySearchContext).startSearching();
        } else {
            new SearchCommand(this.myConfiguration, this.mySearchContext).startSearching();
        }
    }

    @NotNull
    @Nls
    @NlsContexts.DialogTitle String getDefaultTitle() {
        return this.myReplace ? SSRBundle.message("structural.replace.title", new Object[0]) : SSRBundle.message("structural.search.title", new Object[0]);
    }

    protected JComponent createCenterPanel() {
        this.mySearchEditorPanel = new OnePixelSplitter(false, 1.0f);
        this.mySearchEditorPanel.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.mySearchCriteriaEdit = this.createEditor(false);
        this.mySearchEditorPanel.setFirstComponent((JComponent)this.mySearchCriteriaEdit);
        JPanel wrapper = new JPanel(new BorderLayout());
        Color color = UIManager.getColor("Borders.ContrastBorderColor");
        wrapper.setBorder(IdeBorderFactory.createBorder((Color)color));
        wrapper.add((Component)this.mySearchEditorPanel, "Center");
        this.myReplacePanel = this.createReplacePanel();
        this.myReplacePanel.setVisible(this.myReplace);
        this.myScopePanel = new ScopePanel(this.getProject(), this.myDisposable);
        if (!this.myEditConfigOnly) {
            this.myScopePanel.setRecentDirectories(FindInProjectSettings.getInstance((Project)this.getProject()).getRecentDirectories());
            this.myScopePanel.setScopeConsumer((NullableConsumer<? super SearchScope>)((NullableConsumer)scope -> this.initiateValidation()));
        } else {
            this.myScopePanel.setVisible(false);
        }
        this.myFilterPanel = new FilterPanel(this.getProject(), this.myFileType, this.getDisposable());
        this.myFilterPanel.setConstraintChangedCallback(() -> this.initiateValidation());
        this.myFilterPanel.getComponent().setMinimumSize(new Dimension(300, 50));
        this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
        JLabel searchTargetLabel = new JLabel(SSRBundle.message("search.target.label", new Object[0]));
        this.myTargetComboBox = new LinkComboBox(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.myTargetComboBox.setItemConsumer((NullableConsumer<? super String>)((NullableConsumer)item -> {
            MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
            for (String name : matchOptions.getVariableConstraintNames()) {
                matchOptions.getVariableConstraint(name).setPartOfSearchResults(name.equals(item));
            }
            this.initiateValidation();
        }));
        JPanel centerPanel = new JPanel(null);
        GroupLayout layout = new GroupLayout(centerPanel);
        centerPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(wrapper).addComponent(this.myReplacePanel).addComponent(this.myScopePanel).addGroup(layout.createSequentialGroup().addComponent(searchTargetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent((Component)((Object)this.myTargetComboBox), -2, -1, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(wrapper).addGap(8).addComponent(this.myReplacePanel).addComponent(this.myScopePanel, -2, -1, -2).addGap(16).addGroup(layout.createParallelGroup().addComponent(searchTargetLabel).addComponent((Component)((Object)this.myTargetComboBox), -2, -1, -2)));
        return centerPanel;
    }

    private JComponent createReplacePanel() {
        ToolbarLabel replacementTemplateLabel = new ToolbarLabel(SSRBundle.message("replacement.template.label", new Object[0]));
        DefaultActionGroup labelGroup = new DefaultActionGroup(new AnAction[]{new Spacer(), replacementTemplateLabel});
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar labelToolbar = actionManager.createActionToolbar("StructuralSearchDialog", (ActionGroup)labelGroup, true);
        CheckboxAction shortenFqn = new CheckboxAction(SSRBundle.message("shorten.fully.qualified.names.checkbox", new Object[0])){

            public void update(@NotNull AnActionEvent e) {
                super.update(e);
                StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
                e.getPresentation().setEnabledAndVisible(profile != null && profile.supportsShortenFQNames());
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (!StructuralSearchDialog.this.myReplace) {
                    return false;
                }
                return StructuralSearchDialog.this.myConfiguration.getReplaceOptions().isToShortenFQN();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                StructuralSearchDialog.this.myConfiguration.getReplaceOptions().setToShortenFQN(state);
            }
        };
        CheckboxAction staticImport = new CheckboxAction(SSRBundle.message("use.static.import.checkbox", new Object[0])){

            public void update(@NotNull AnActionEvent e) {
                super.update(e);
                StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
                e.getPresentation().setEnabledAndVisible(profile != null && profile.supportsUseStaticImports());
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (!StructuralSearchDialog.this.myReplace) {
                    return false;
                }
                return StructuralSearchDialog.this.myConfiguration.getReplaceOptions().isToUseStaticImport();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                StructuralSearchDialog.this.myConfiguration.getReplaceOptions().setToUseStaticImport(state);
            }
        };
        CheckboxAction reformat = new CheckboxAction(SSRBundle.message("reformat.checkbox", new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (!StructuralSearchDialog.this.myReplace) {
                    return false;
                }
                return StructuralSearchDialog.this.myConfiguration.getReplaceOptions().isToReformatAccordingToStyle();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                StructuralSearchDialog.this.myConfiguration.getReplaceOptions().setToReformatAccordingToStyle(state);
            }
        };
        DefaultActionGroup replacementActionGroup = new DefaultActionGroup(new AnAction[]{shortenFqn, staticImport, reformat});
        ActionToolbar replacementToolbar = actionManager.createActionToolbar("StructuralSearchDialog", (ActionGroup)replacementActionGroup, true);
        OnePixelSplitter replaceEditorPanel = new OnePixelSplitter(false, 1.0f);
        replaceEditorPanel.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.myReplaceCriteriaEdit = this.createEditor(true);
        replaceEditorPanel.setFirstComponent((JComponent)this.myReplaceCriteriaEdit);
        JPanel wrapper = new JPanel(new BorderLayout());
        Color color = UIManager.getColor("Borders.ContrastBorderColor");
        wrapper.setBorder(IdeBorderFactory.createBorder((Color)color));
        wrapper.add((Component)replaceEditorPanel, "Center");
        JPanel replacePanel = new JPanel(null);
        GroupLayout layout = new GroupLayout(replacePanel);
        replacePanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(labelToolbar.getComponent(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(replacementToolbar.getComponent(), -2, -1, -2)).addComponent(wrapper));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(labelToolbar.getComponent()).addComponent(replacementToolbar.getComponent())).addGap(4).addComponent(wrapper));
        return replacePanel;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        List<PatternContext> contexts;
        DumbAwareAction historyAction = new DumbAwareAction(SSRBundle.messagePointer("history.button", new Object[0]), SSRBundle.messagePointer("history.button.description", new Object[0]), AllIcons.Actions.SearchWithHistory){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Object source = e.getInputEvent().getSource();
                if (!(source instanceof Component)) {
                    return;
                }
                JBPopupFactory.getInstance().createPopupChooserBuilder(ConfigurationManager.getInstance(StructuralSearchDialog.this.getProject()).getHistoryConfigurations()).setRenderer((ListCellRenderer)((Object)new ConfigurationCellRenderer())).setItemChosenCallback(c -> StructuralSearchDialog.this.loadConfiguration((Configuration)c)).setSelectionMode(0).createPopup().showUnderneathOf((Component)source);
            }
        };
        ToolbarLabel searchTemplateLabel = new ToolbarLabel(SSRBundle.message("search.template", new Object[0])){

            @Override
            @NotNull
            public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
                JLabel label = (JLabel)super.createCustomComponent(presentation, place);
                UIUtil.installCompleteMatchInfo(label, () -> StructuralSearchDialog.this.myConfiguration, link -> StructuralSearchDialog.this.showFilterPanel((String)link));
                return label;
            }
        };
        DefaultActionGroup historyActionGroup = new DefaultActionGroup(new AnAction[]{historyAction, searchTemplateLabel});
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar historyToolbar = actionManager.createActionToolbar("StructuralSearchDialog", (ActionGroup)historyActionGroup, true);
        CheckboxAction recursive = new CheckboxAction(SSRBundle.message("recursive.matching.checkbox", new Object[0])){

            public void update(@NotNull AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabledAndVisible(!StructuralSearchDialog.this.myReplace);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                return StructuralSearchDialog.this.myConfiguration instanceof SearchConfiguration && StructuralSearchDialog.this.myConfiguration.getMatchOptions().isRecursiveSearch();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (StructuralSearchDialog.this.myConfiguration instanceof SearchConfiguration) {
                    StructuralSearchDialog.this.myConfiguration.getMatchOptions().setRecursiveSearch(state);
                    StructuralSearchDialog.this.initiateValidation();
                }
            }
        };
        CheckboxAction matchCase = new CheckboxAction(FindBundle.message((String)"find.popup.case.sensitive", (Object[])new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                return StructuralSearchDialog.this.myConfiguration.getMatchOptions().isCaseSensitiveMatch();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                StructuralSearchDialog.this.myConfiguration.getMatchOptions().setCaseSensitiveMatch(state);
                StructuralSearchDialog.this.initiateValidation();
            }
        };
        this.myFileType = UIUtil.detectFileType(this.mySearchContext);
        this.myDialect = this.myFileType.getLanguage();
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        if (profile != null && !(contexts = profile.getPatternContexts()).isEmpty()) {
            this.myPatternContext = contexts.get(0);
        }
        this.myFileTypeChooser.setSelectedItem(this.myFileType, this.myDialect, this.myPatternContext);
        this.myFileTypeChooser.setFileTypeInfoConsumer(info -> {
            this.myOptionsToolbar.updateActionsImmediately();
            this.myFileType = info.getFileType();
            this.myFilterPanel.setFileType(this.myFileType);
            this.myDialect = info.getDialect();
            this.myPatternContext = info.getContext();
            String contextId = this.myPatternContext == null ? "" : this.myPatternContext.getId();
            StructuralSearchProfile profile1 = StructuralSearchUtil.getProfileByFileType(this.myFileType);
            assert (profile1 != null);
            Document searchDocument = UIUtil.createDocument(this.getProject(), this.myFileType, this.myDialect, this.myPatternContext, this.mySearchCriteriaEdit.getText(), profile1);
            searchDocument.addDocumentListener((DocumentListener)this, this.myDisposable);
            this.mySearchCriteriaEdit.setNewDocumentAndFileType((FileType)this.myFileType, searchDocument);
            searchDocument.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)contextId);
            Document replaceDocument = UIUtil.createDocument(this.getProject(), this.myFileType, this.myDialect, this.myPatternContext, this.myReplaceCriteriaEdit.getText(), profile1);
            replaceDocument.addDocumentListener((DocumentListener)this, this.myDisposable);
            this.myReplaceCriteriaEdit.setNewDocumentAndFileType((FileType)this.myFileType, replaceDocument);
            replaceDocument.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)contextId);
            this.initiateValidation();
        });
        DefaultActionGroup templateActionGroup = new DefaultActionGroup();
        templateActionGroup.add((AnAction)new DumbAwareAction(SSRBundle.message("save.template.text.button", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ConfigurationManager.getInstance(StructuralSearchDialog.this.getProject()).showSaveTemplateAsDialog(StructuralSearchDialog.this.getConfiguration());
            }
        });
        templateActionGroup.add((AnAction)new DumbAwareAction(SSRBundle.message("save.inspection.action.text", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                StructuralSearchProfileActionProvider.createNewInspection(StructuralSearchDialog.this.getConfiguration(), StructuralSearchDialog.this.getProject());
            }
        });
        templateActionGroup.addSeparator();
        templateActionGroup.addAll(new AnAction[]{new CopyConfigurationAction(), new PasteConfigurationAction(), new DumbAwareAction(SSRBundle.message("copy.existing.template.button", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                SelectTemplateDialog dialog = new SelectTemplateDialog(StructuralSearchDialog.this.getProject(), false, StructuralSearchDialog.this.myReplace);
                if (!dialog.showAndGet()) {
                    return;
                }
                Configuration[] configurations = dialog.getSelectedConfigurations();
                if (configurations.length == 1) {
                    StructuralSearchDialog.this.loadConfiguration(configurations[0]);
                }
            }
        }, Separator.getInstance(), new SwitchAction()});
        templateActionGroup.setPopup(true);
        Presentation presentation = templateActionGroup.getTemplatePresentation();
        presentation.setIcon(AllIcons.General.Settings);
        presentation.setText(SSRBundle.message("tools.button", new Object[0]));
        Icon modified = IconUtil.cropIcon((Icon)AllIcons.General.Modified, (Rectangle)new JBRectangle(3, 3, 7, 7));
        final LayeredIcon filterModifiedIcon = new LayeredIcon(2);
        filterModifiedIcon.setIcon(AllIcons.General.Filter, 0);
        filterModifiedIcon.setIcon(modified, 1, 4);
        DumbAwareToggleAction filterAction = new DumbAwareToggleAction(SSRBundle.message("filter.button", new Object[0]), SSRBundle.message("filter.button.description", new Object[0]), (Icon)filterModifiedIcon){

            public void update(@NotNull AnActionEvent e) {
                super.update(e);
                Presentation presentation = e.getPresentation();
                presentation.setIcon((Icon)(StructuralSearchDialog.this.myFilterIsShowing ? filterModifiedIcon : AllIcons.General.Filter));
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                return StructuralSearchDialog.this.isFilterPanelVisible();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                StructuralSearchDialog.this.setFilterPanelVisible(state);
            }
        };
        DefaultActionGroup optionsActionGroup = new DefaultActionGroup(new AnAction[]{recursive, matchCase, this.myFileTypeChooser, filterAction, templateActionGroup});
        this.myOptionsToolbar = (ActionToolbarImpl)actionManager.createActionToolbar("StructuralSearchDialog", (ActionGroup)optionsActionGroup, true);
        this.myOptionsToolbar.setLayoutPolicy(0);
        this.myOptionsToolbar.setForceMinimumSize(true);
        JPanel northPanel = new JPanel(null);
        GroupLayout layout = new GroupLayout(northPanel);
        northPanel.setLayout(layout);
        layout.setHonorsVisibility(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(historyToolbar.getComponent(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent((Component)this.myOptionsToolbar, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(historyToolbar.getComponent()).addComponent((Component)this.myOptionsToolbar));
        return northPanel;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        if (this.myEditConfigOnly) {
            return null;
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.myOpenInNewTab = new JCheckBox(SSRBundle.message("open.in.new.tab.checkbox", new Object[0]));
        this.myOpenInNewTab.setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
        panel2.add((Component)this.myOpenInNewTab, "East");
        return panel2;
    }

    Project getProject() {
        return this.mySearchContext.getProject();
    }

    @Nullable
    public Point getInitialLocation() {
        DimensionService dimensionService = DimensionService.getInstance();
        Dimension size = dimensionService.getSize(this.myReplace ? REPLACE_DIMENSION_SERVICE_KEY : SEARCH_DIMENSION_SERVICE_KEY, this.getProject());
        if (size != null) {
            this.setSize(size.width, this.myEditConfigOnly ? size.height - this.myScopePanel.getPreferredSize().height : size.height);
        } else {
            this.pack();
            Dimension otherSize = dimensionService.getSize(this.myReplace ? SEARCH_DIMENSION_SERVICE_KEY : REPLACE_DIMENSION_SERVICE_KEY, this.getProject());
            if (otherSize != null) {
                this.setSize(otherSize.width, this.getSize().height);
            }
        }
        if (this.myEditConfigOnly) {
            return super.getInitialLocation();
        }
        Point location = dimensionService.getLocation(SEARCH_DIMENSION_SERVICE_KEY, this.getProject());
        return location == null ? super.getInitialLocation() : location;
    }

    public void show() {
        if (!this.myUseLastConfiguration) {
            this.setTextFromContext();
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        this.setFilterPanelVisible(properties.getBoolean(FILTERS_VISIBLE_STATE, true));
        super.show();
        StructuralSearchPlugin.getInstance(this.getProject()).setDialog(this);
    }

    private void startTemplate() {
        if (!Registry.is((String)"ssr.template.from.selection.builder")) {
            return;
        }
        Document document2 = this.mySearchCriteriaEdit.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document2);
        assert (psiFile != null);
        TemplateBuilder builder2 = new StructuralSearchTemplateBuilder(psiFile).buildTemplate();
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (String)SSRBundle.message("command.name.live.search.template.builder", new Object[0]), (String)"Structural Search", () -> builder2.run(Objects.requireNonNull(this.mySearchCriteriaEdit.getEditor()), true), (PsiFile[])new PsiFile[0]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchCriteriaEdit;
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.removeMatchHighlights();
    }

    protected void doOKAction() {
        this.myDoingOkAction = true;
        this.removeMatchHighlights();
        CompiledPattern compiledPattern = this.compilePattern();
        this.myDoingOkAction = false;
        if (compiledPattern == null) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myConfiguration.removeUnusedVariables();
        super.doOKAction();
        if (this.myEditConfigOnly) {
            return;
        }
        SearchScope scope = this.myScopePanel.getScope();
        if (scope instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)scope;
            FindInProjectSettings.getInstance((Project)this.getProject()).addDirectory(directoryScope.getDirectory().getPresentableUrl());
        }
        FindSettings findSettings = FindSettings.getInstance();
        findSettings.setShowResultsInSeparateView(this.myOpenInNewTab.isSelected());
        try {
            ConfigurationManager.getInstance(this.getProject()).addHistoryConfiguration(this.myConfiguration);
            this.startSearching();
        }
        catch (MalformedPatternException ex) {
            this.reportMessage(SSRBundle.message("this.pattern.is.malformed.message", ex.getMessage()), true, (JComponent)this.mySearchCriteriaEdit);
        }
    }

    public Configuration getConfiguration() {
        this.saveConfiguration();
        return this.myConfiguration.copy();
    }

    private CompiledPattern compilePattern() {
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        Project project2 = this.getProject();
        try {
            CompiledPattern compiledPattern = PatternCompiler.compilePattern(project2, matchOptions, true, !this.myEditConfigOnly);
            this.reportMessage(null, false, (JComponent)this.mySearchCriteriaEdit);
            return compiledPattern;
        }
        catch (MalformedPatternException e) {
            String message;
            this.removeMatchHighlights();
            String string = StringUtil.isEmpty((String)matchOptions.getSearchPattern()) ? null : (message = SSRBundle.message("this.pattern.is.malformed.message", e.getMessage() != null ? e.getMessage() : ""));
            if (!e.isErrorElement || !Registry.is((String)"ssr.in.editor.problem.highlighting")) {
                this.reportMessage(message, true, (JComponent)this.mySearchCriteriaEdit);
            }
            return null;
        }
        catch (UnsupportedPatternException e) {
            this.removeMatchHighlights();
            this.reportMessage(SSRBundle.message("this.pattern.is.unsupported.message", e.getMessage()), true, (JComponent)this.mySearchCriteriaEdit);
            return null;
        }
        catch (NoMatchFoundException e) {
            this.removeMatchHighlights();
            this.reportMessage(e.getMessage(), false, this.myScopePanel);
            return null;
        }
    }

    private void checkReplacementPattern() {
        block4: {
            if (!this.myReplace) {
                return;
            }
            try {
                Replacer.checkReplacementPattern(this.getProject(), this.myConfiguration.getReplaceOptions());
                this.reportMessage(null, false, (JComponent)this.myReplaceCriteriaEdit);
            }
            catch (UnsupportedPatternException ex) {
                this.reportMessage(SSRBundle.message("unsupported.replacement.pattern.message", ex.getMessage()), true, (JComponent)this.myReplaceCriteriaEdit);
            }
            catch (MalformedPatternException ex) {
                if (ex.isErrorElement && Registry.is((String)"ssr.in.editor.problem.highlighting")) break block4;
                this.reportMessage(SSRBundle.message("malformed.replacement.pattern.message", ex.getMessage()), true, (JComponent)this.myReplaceCriteriaEdit);
            }
        }
    }

    void removeMatchHighlights() {
        if (this.myEditConfigOnly) {
            return;
        }
        Editor editor = this.myEditor;
        if (editor == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project2 = this.getProject();
            if (project2.isDisposed()) {
                return;
            }
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
            for (RangeHighlighter highlighter : this.myRangeHighlighters) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
            }
            WindowManager.getInstance().getStatusBar(project2).setInfo("");
            this.myRangeHighlighters.clear();
        });
    }

    void addMatchHighlights() {
        if (this.myEditConfigOnly) {
            return;
        }
        Project project2 = this.getProject();
        Editor editor = this.myEditor;
        if (editor == null) {
            return;
        }
        Document document2 = editor.getDocument();
        PsiFile file2 = (PsiFile)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2));
        if (file2 == null) {
            return;
        }
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        matchOptions.setScope((SearchScope)new LocalSearchScope((PsiElement)file2, IdeBundle.message((String)"scope.current.file", (Object[])new Object[0])));
        CollectingMatchResultSink sink = new CollectingMatchResultSink();
        try {
            new Matcher(project2, matchOptions).findMatches(sink);
            List<MatchResult> matches = sink.getMatches();
            this.removeMatchHighlights();
            this.addMatchHighlights(matches, editor, file2, matches.size() + " results found in current file");
        }
        catch (StructuralSearchException e) {
            this.reportMessage(e.getMessage().replace("a3cd264774bf4efb9ab609b250c5165c", ""), true, (JComponent)this.mySearchCriteriaEdit);
            this.removeMatchHighlights();
        }
    }

    private void addMatchHighlights(@NotNull List<MatchResult> matchResults, @NotNull Editor editor, @NotNull PsiFile file2, @Nullable String statusBarText) {
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project2 = this.getProject();
            if (project2.isDisposed()) {
                return;
            }
            if (!matchResults.isEmpty()) {
                for (MatchResult result2 : matchResults) {
                    PsiElement match = result2.getMatch();
                    if (match == null || match.getContainingFile() != file2) continue;
                    int start = -1;
                    int end = -1;
                    if ("__multi_line__".equals(result2.getName())) {
                        for (MatchResult child : result2.getChildren()) {
                            int endOffset;
                            TextRange range = child.getMatch().getTextRange();
                            int startOffset = range.getStartOffset();
                            if (start == -1 || start > startOffset) {
                                start = startOffset;
                            }
                            if (end >= (endOffset = range.getEndOffset())) continue;
                            end = endOffset;
                        }
                    } else {
                        TextRange range = match.getTextRange();
                        start = range.getStartOffset();
                        end = range.getEndOffset();
                    }
                    HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
                    highlightManager.addRangeHighlight(editor, start, end, EditorColors.SEARCH_RESULT_ATTRIBUTES, false, this.myRangeHighlighters);
                }
                HighlightHandlerBase.setupFindModel((Project)project2);
            }
            WindowManager.getInstance().getStatusBar(project2).setInfo(statusBarText);
        });
    }

    void reportMessage(@Nullable String message, boolean error, @NotNull JComponent component) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myBalloon != null) {
                this.myBalloon.hide();
            }
            component.putClientProperty("JComponent.outline", !error || message == null ? null : "error");
            component.repaint();
            if (message == null) {
                return;
            }
            this.myBalloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, error ? MessageType.ERROR : MessageType.WARNING, null).setHideOnFrameResize(false).createBalloon();
            if (component != this.myScopePanel) {
                this.myBalloon.show(new RelativePoint((Component)component, new Point(component.getWidth() / 2, component.getHeight())), Balloon.Position.below);
            } else {
                this.myBalloon.show(new RelativePoint((Component)component, new Point(component.getWidth() / 2, 0)), Balloon.Position.above);
            }
            this.myBalloon.showInCenterOf(component);
            Disposer.register((Disposable)this.myDisposable, (Disposable)this.myBalloon);
        }, ModalityState.stateForComponent((Component)component));
    }

    void securityCheck() {
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        int scripts = 0;
        for (String name : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
            if (constraint.getScriptCodeConstraint().length() <= 2) continue;
            ++scripts;
        }
        ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
        if (replaceOptions != null) {
            for (ReplacementVariableDefinition variableDefinition : replaceOptions.getVariableDefinitions()) {
                if (variableDefinition.getScriptCodeConstraint().length() <= 2) continue;
                ++scripts;
            }
        }
        if (scripts > 0) {
            UIUtil.SSR_NOTIFICATION_GROUP.createNotification(NotificationType.WARNING).setTitle(SSRBundle.message("import.template.script.warning.title", new Object[0])).setContent(SSRBundle.message("import.template.script.warning", ApplicationNamesInfo.getInstance().getFullProductName(), scripts)).notify(this.mySearchContext.getProject());
        }
    }

    public void showFilterPanel(String variableName) {
        this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, this.myConfiguration));
        this.setFilterPanelVisible(true);
        this.myConfiguration.setCurrentVariableName(variableName);
    }

    void setFilterPanelVisible(boolean visible) {
        if (visible) {
            if (this.myFilterPanel.getVariable() == null) {
                this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
            }
            if (!this.isFilterPanelVisible()) {
                this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
            }
        } else if (this.isFilterPanelVisible()) {
            this.mySearchEditorPanel.setSecondComponent(null);
            this.myConfiguration.setCurrentVariableName(null);
        }
    }

    boolean isFilterPanelVisible() {
        return this.mySearchEditorPanel.getSecondComponent() != null;
    }

    private void setSearchTargets(MatchOptions matchOptions) {
        ArrayList<String> names = new ArrayList<String>(matchOptions.getUsedVariableNames());
        Collections.sort(names);
        names.remove("__context__");
        names.add(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.myTargetComboBox.setItems(names);
        if (names.size() > 1) {
            this.myTargetComboBox.setEnabled(true);
            for (String name : names) {
                MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
                if (constraint == null || !constraint.isPartOfSearchResults()) continue;
                this.myTargetComboBox.setSelectedItem(name);
                return;
            }
            this.myTargetComboBox.setSelectedItem(SSRBundle.message("complete.match.variable.name", new Object[0]));
        } else {
            this.myTargetComboBox.setEnabled(false);
        }
    }

    boolean loadConfiguration(String text) {
        if (text == null) {
            return false;
        }
        try {
            Configuration configuration = ConfigurationUtil.fromXml(text);
            if (configuration == null) {
                return false;
            }
            this.loadConfiguration(configuration);
            this.securityCheck();
        }
        catch (JDOMException e) {
            this.reportMessage(SSRBundle.message("import.template.script.corrupted", new Object[0]) + '\n' + e.getMessage(), false, (JComponent)this.myOptionsToolbar);
        }
        return true;
    }

    public void loadConfiguration(Configuration configuration) {
        this.myConfiguration = this.createConfiguration(configuration);
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        this.setSearchTargets(matchOptions);
        if (!this.myEditConfigOnly) {
            this.myScopePanel.setScopesFromContext();
            SearchScope scope = matchOptions.getScope();
            if (scope != null) {
                this.myScopePanel.setScope(scope);
            }
        }
        this.myFileTypeChooser.setSelectedItem(matchOptions.getFileType(), matchOptions.getDialect(), matchOptions.getPatternContext());
        Editor searchEditor = this.mySearchCriteriaEdit.getEditor();
        if (searchEditor != null) {
            searchEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
        }
        UIUtil.setContent(this.mySearchCriteriaEdit, matchOptions.getSearchPattern());
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (this.myReplace) {
            Editor replaceEditor = this.myReplaceCriteriaEdit.getEditor();
            if (replaceEditor != null) {
                replaceEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
            }
            if (configuration instanceof ReplaceConfiguration) {
                ReplaceOptions replaceOptions = configuration.getReplaceOptions();
                UIUtil.setContent(this.myReplaceCriteriaEdit, replaceOptions.getReplacement());
            } else {
                UIUtil.setContent(this.myReplaceCriteriaEdit, matchOptions.getSearchPattern());
            }
        } else if (configuration instanceof ReplaceConfiguration) {
            matchOptions.setRecursiveSearch(properties.getBoolean(RECURSIVE_STATE));
        }
    }

    private void saveConfiguration() {
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        if (!this.myEditConfigOnly) {
            SearchScope scope = this.myScopePanel.getScope();
            boolean searchWithinHierarchy = IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(scope.getDisplayName());
            matchOptions.setScope((SearchScope)(searchWithinHierarchy && !this.myDoingOkAction ? GlobalSearchScope.projectScope((Project)this.getProject()) : scope));
        } else {
            matchOptions.setScope(null);
        }
        matchOptions.setFileType(this.myFileType);
        matchOptions.setDialect(this.myDialect);
        matchOptions.setPatternContext(this.myPatternContext);
        matchOptions.setSearchPattern(this.getPattern(this.mySearchCriteriaEdit));
        ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
        if (this.myReplace) {
            replaceOptions.setReplacement(this.getPattern(this.myReplaceCriteriaEdit));
            matchOptions.setRecursiveSearch(false);
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (this.myReplace) {
            properties.setValue(SHORTEN_FQN_STATE, replaceOptions.isToShortenFQN());
            properties.setValue(USE_STATIC_IMPORT_STATE, replaceOptions.isToUseStaticImport());
            properties.setValue(REFORMAT_STATE, replaceOptions.isToReformatAccordingToStyle());
        } else {
            properties.setValue(RECURSIVE_STATE, matchOptions.isRecursiveSearch());
        }
    }

    private String getPattern(EditorTextField textField) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (profile != null);
        Document document2 = textField.getDocument();
        String pattern = (String)ReadAction.compute(() -> {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document2);
            assert (file2 != null);
            return profile.getCodeFragmentText(file2);
        });
        return pattern.isEmpty() ? textField.getText() : pattern;
    }

    @Nullable
    protected final String getDimensionServiceKey() {
        return null;
    }

    public void dispose() {
        this.getProject().putUserData(STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION, (Object)this.myConfiguration);
        if (this.myReplace) {
            this.storeDimensions(REPLACE_DIMENSION_SERVICE_KEY, SEARCH_DIMENSION_SERVICE_KEY);
        } else {
            this.storeDimensions(SEARCH_DIMENSION_SERVICE_KEY, REPLACE_DIMENSION_SERVICE_KEY);
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue(FILTERS_VISIBLE_STATE, this.isFilterPanelVisible(), true);
        StructuralSearchPlugin.getInstance(this.getProject()).setDialog(null);
        this.myAlarm.cancelAllRequests();
        this.mySearchCriteriaEdit.removeNotify();
        this.myReplaceCriteriaEdit.removeNotify();
        this.removeRestartHighlightingListenerFromCurrentEditor();
        super.dispose();
    }

    private void storeDimensions(String key1, String key2) {
        if (this.myEditConfigOnly) {
            return;
        }
        Dimension size = this.getSize();
        DimensionService dimensionService = DimensionService.getInstance();
        Point location = this.getLocation();
        if (location.x < 0) {
            location.x = 0;
        }
        if (location.y < 0) {
            location.y = 0;
        }
        dimensionService.setLocation(SEARCH_DIMENSION_SERVICE_KEY, location, this.getProject());
        dimensionService.setSize(key1, size, this.getProject());
        Dimension otherSize = dimensionService.getSize(key2);
        if (otherSize != null && otherSize.width != size.width) {
            otherSize.width = size.width;
            dimensionService.setSize(key2, otherSize, this.getProject());
        }
    }

    protected String getHelpId() {
        return "find.structuredSearch";
    }

    public static String getUserDefined() {
        return SSRBundle.message("new.template.defaultname", new Object[0]);
    }

    private class MyEditorTextField
    extends EditorTextField {
        private final boolean myReplace;

        MyEditorTextField(Document document2, boolean replace) {
            super(document2, StructuralSearchDialog.this.getProject(), (FileType)StructuralSearchDialog.this.myFileType, false, false);
            this.myReplace = replace;
        }

        protected EditorEx createEditor() {
            EditorEx editor = super.createEditor();
            editor.setHorizontalScrollbarVisible(true);
            editor.setVerticalScrollbarVisible(true);
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
            assert (profile != null);
            TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)UIUtil.getTemplateContextType(profile));
            SubstitutionShortInfoHandler.install((Editor)editor, variableName -> {
                if (variableName.endsWith("$replacement")) {
                    variableName = StringUtil.trimEnd((String)variableName, (String)"$replacement");
                    assert (StructuralSearchDialog.this.myConfiguration instanceof ReplaceConfiguration);
                    StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddReplacementVariable(variableName, StructuralSearchDialog.this.myConfiguration));
                } else {
                    StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, StructuralSearchDialog.this.myConfiguration));
                }
                StructuralSearchDialog.this.myFilterIsShowing = StructuralSearchDialog.this.myFilterPanel.hasVisibleFilter();
                if (StructuralSearchDialog.this.isFilterPanelVisible()) {
                    StructuralSearchDialog.this.myConfiguration.setCurrentVariableName((String)variableName);
                }
            }, StructuralSearchDialog.this.myDisposable, this.myReplace);
            editor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)StructuralSearchDialog.this.myConfiguration);
            this.getDocument().putUserData(STRUCTURAL_SEARCH_ERROR_CALLBACK, () -> {
                this.putClientProperty("JComponent.outline", "error");
                this.repaint();
                StructuralSearchDialog.this.getOKAction().setEnabled(false);
                StructuralSearchDialog.this.removeMatchHighlights();
            });
            TextCompletionUtil.installCompletionHint((EditorEx)editor);
            editor.putUserData(STRUCTURAL_SEARCH_DIALOG, (Object)StructuralSearchDialog.this);
            editor.setEmbeddedIntoDialogWrapper(true);
            return editor;
        }

        protected void updateBorder(@NotNull EditorEx editor) {
            this.setupBorder(editor);
            JScrollPane scrollPane = editor.getScrollPane();
            scrollPane.setBorder(new ErrorBorder(scrollPane.getBorder()));
        }
    }

    private class PasteConfigurationAction
    extends AnAction
    implements DumbAware {
        PasteConfigurationAction() {
            super(SSRBundle.messagePointer("import.template.action", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String contents = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
            if (!StructuralSearchDialog.this.loadConfiguration(contents)) {
                StructuralSearchDialog.this.reportMessage(SSRBundle.message("no.template.found.warning", new Object[0]), false, (JComponent)StructuralSearchDialog.this.myOptionsToolbar);
            }
        }
    }

    private class CopyConfigurationAction
    extends AnAction
    implements DumbAware {
        CopyConfigurationAction() {
            super(SSRBundle.messagePointer("export.template.action", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(ConfigurationUtil.toXml(StructuralSearchDialog.this.myConfiguration)));
        }
    }

    private class SwitchAction
    extends AnAction
    implements DumbAware {
        SwitchAction() {
            this.init();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            StructuralSearchDialog.this.myReplace = !StructuralSearchDialog.this.myReplace;
            StructuralSearchDialog.this.setTitle(StructuralSearchDialog.this.getDefaultTitle());
            StructuralSearchDialog.this.myReplacePanel.setVisible(StructuralSearchDialog.this.myReplace);
            StructuralSearchDialog.this.loadConfiguration(StructuralSearchDialog.this.myConfiguration);
            Dimension size = DimensionService.getInstance().getSize(StructuralSearchDialog.this.myReplace ? StructuralSearchDialog.REPLACE_DIMENSION_SERVICE_KEY : StructuralSearchDialog.SEARCH_DIMENSION_SERVICE_KEY);
            if (size != null) {
                StructuralSearchDialog.this.setSize(StructuralSearchDialog.this.getSize().width, size.height);
            } else {
                StructuralSearchDialog.this.pack();
            }
            this.init();
        }

        private void init() {
            this.getTemplatePresentation().setText(SSRBundle.messagePointer(StructuralSearchDialog.this.myReplace ? "switch.to.search.action" : "switch.to.replace.action", new Object[0]));
            ActionManager actionManager = ActionManager.getInstance();
            ShortcutSet searchShortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralSearchAction").getShortcutSet();
            ShortcutSet replaceShortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralReplaceAction").getShortcutSet();
            CompositeShortcutSet shortcutSet = StructuralSearchDialog.this.myReplace ? new CompositeShortcutSet(new ShortcutSet[]{searchShortcutSet, replaceShortcutSet}) : new CompositeShortcutSet(new ShortcutSet[]{replaceShortcutSet, searchShortcutSet});
            this.registerCustomShortcutSet((ShortcutSet)shortcutSet, StructuralSearchDialog.this.getRootPane());
        }
    }

    private static class ErrorBorder
    implements Border {
        private final Border myErrorBorder;

        ErrorBorder(Border errorBorder) {
            this.myErrorBorder = errorBorder;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            EditorTextField editorTextField = (EditorTextField)ComponentUtil.getParentOfType(EditorTextField.class, (Component)c);
            if (editorTextField == null) {
                return;
            }
            Object object = editorTextField.getClientProperty((Object)"JComponent.outline");
            if ("error".equals(object) || "warning".equals(object)) {
                this.myErrorBorder.paintBorder(c, g, x, y, width, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.myErrorBorder.getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

