/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchTypedHandler;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import org.jetbrains.annotations.NotNull;

public class StructuralSearchBackspaceHandler
extends BackspaceHandlerDelegate {
    public void beforeCharDeleted(char c, @NotNull PsiFile file2, @NotNull Editor editor) {
    }

    public boolean charDeleted(char c, @NotNull PsiFile file2, @NotNull Editor editor) {
        if (editor.getUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY) == null || !CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        if (c == '$') {
            Document document2 = editor.getDocument();
            CharSequence text = document2.getCharsSequence();
            Caret caret = editor.getCaretModel().getCurrentCaret();
            int offset = caret.getOffset();
            LogicalPosition position = caret.getLogicalPosition();
            int lineStart = document2.getLineStartOffset(position.line);
            int lineEnd = document2.getLineEndOffset(position.line);
            if (text.length() > offset && text.charAt(offset) == '$' && StructuralSearchTypedHandler.hasOddDollar(text, lineStart, lineEnd)) {
                document2.deleteString(offset, offset + 1);
            }
            return true;
        }
        return false;
    }
}

