/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ExistingTemplatesComponent;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectTemplateDialog
extends DialogWrapper {
    private final boolean showHistory;
    private Editor searchPatternEditor;
    private Editor replacePatternEditor;
    private final boolean replace;
    private final Project project;
    private final ExistingTemplatesComponent existingTemplatesComponent;
    private MySelectionListener selectionListener;
    private CardLayout myCardLayout;
    private JPanel myPreviewPanel;
    @NonNls
    private static final String PREVIEW_CARD = "Preview";
    @NonNls
    private static final String SELECT_TEMPLATE_CARD = "SelectCard";

    public SelectTemplateDialog(Project project2, boolean showHistory, boolean replace) {
        super(project2, true);
        this.project = project2;
        this.showHistory = showHistory;
        this.replace = replace;
        this.existingTemplatesComponent = ExistingTemplatesComponent.getInstance(this.project);
        this.setTitle(SSRBundle.message(this.showHistory ? "used.templates.history.dialog.title" : "existing.templates.dialog.title", new Object[0]));
        this.init();
        if (this.showHistory) {
            int selection = this.existingTemplatesComponent.getHistoryList().getSelectedIndex();
            if (selection != -1) {
                this.setPatternFromList(selection);
            }
        } else {
            Configuration configuration = this.existingTemplatesComponent.getSelectedConfiguration();
            this.showPatternPreviewFromConfiguration(configuration);
        }
        this.setupListeners();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.existingTemplatesComponent.finish(true);
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.existingTemplatesComponent.finish(false);
    }

    private void setPatternFromList(int index) {
        this.showPatternPreviewFromConfiguration(this.existingTemplatesComponent.getHistoryList().getModel().getElementAt(index));
    }

    protected JComponent createCenterPanel() {
        JComponent centerComponent;
        JPanel centerPanel = new JPanel(new BorderLayout());
        Splitter splitter = new Splitter(false, 0.3f);
        centerPanel.add("Center", (Component)splitter);
        centerPanel.add((Component)splitter);
        splitter.setFirstComponent(this.showHistory ? this.existingTemplatesComponent.getHistoryPanel() : this.existingTemplatesComponent.getTemplatesPanel());
        JPanel panel2 = new JPanel(new BorderLayout());
        splitter.setSecondComponent((JComponent)panel2);
        this.searchPatternEditor = UIUtil.createEditor(EditorFactory.getInstance().createDocument((CharSequence)""), this.project, false, null);
        SubstitutionShortInfoHandler.install(this.searchPatternEditor, this.myDisposable);
        if (this.replace) {
            this.replacePatternEditor = UIUtil.createEditor(EditorFactory.getInstance().createDocument((CharSequence)""), this.project, false, null);
            SubstitutionShortInfoHandler.install(this.replacePatternEditor, this.myDisposable);
            centerComponent = new Splitter(true);
            ((Splitter)centerComponent).setFirstComponent(this.searchPatternEditor.getComponent());
            ((Splitter)centerComponent).setSecondComponent(this.replacePatternEditor.getComponent());
        } else {
            centerComponent = this.searchPatternEditor.getComponent();
        }
        this.myCardLayout = new CardLayout();
        this.myPreviewPanel = new JPanel(this.myCardLayout);
        this.myPreviewPanel.add((Component)centerComponent, PREVIEW_CARD);
        JPanel selectPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 10, 0, (Insets)JBUI.emptyInsets(), 0, 0);
        selectPanel.add((Component)new JLabel(SSRBundle.message("selecttemplate.template.label.please.select.template", new Object[0])), gb);
        this.myPreviewPanel.add((Component)selectPanel, SELECT_TEMPLATE_CARD);
        panel2.add("Center", this.myPreviewPanel);
        JPanel labelPanel = new JPanel(new FlowLayout(0, 2, 0));
        labelPanel.add(new JLabel(SSRBundle.message("selecttemplate.template.preview", new Object[0])));
        if (!Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips")) {
            labelPanel.add(UIUtil.createCompleteMatchInfo(() -> {
                Configuration[] configurations = this.getSelectedConfigurations();
                return configurations.length != 1 ? null : configurations[0];
            }));
        }
        panel2.add("North", labelPanel);
        return centerPanel;
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.searchPatternEditor);
        if (this.replacePatternEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.replacePatternEditor);
        }
        this.removeListeners();
        super.dispose();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.showHistory ? this.existingTemplatesComponent.getHistoryList() : this.existingTemplatesComponent.getPatternTree();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog";
    }

    private void setupListeners() {
        this.existingTemplatesComponent.setOwner(this);
        this.selectionListener = new MySelectionListener();
        if (this.showHistory) {
            this.existingTemplatesComponent.getHistoryList().getSelectionModel().addListSelectionListener(this.selectionListener);
        } else {
            this.existingTemplatesComponent.getPatternTree().getSelectionModel().addTreeSelectionListener(this.selectionListener);
        }
    }

    private void removeListeners() {
        this.existingTemplatesComponent.setOwner(null);
        if (this.showHistory) {
            this.existingTemplatesComponent.getHistoryList().getSelectionModel().removeListSelectionListener(this.selectionListener);
        } else {
            this.existingTemplatesComponent.getPatternTree().getSelectionModel().removeTreeSelectionListener(this.selectionListener);
        }
    }

    private void showPatternPreviewFromConfiguration(@Nullable Configuration configuration) {
        if (configuration == null) {
            this.myCardLayout.show(this.myPreviewPanel, SELECT_TEMPLATE_CARD);
            return;
        }
        this.myCardLayout.show(this.myPreviewPanel, PREVIEW_CARD);
        MatchOptions matchOptions = configuration.getMatchOptions();
        UIUtil.setContent(this.searchPatternEditor, matchOptions.getSearchPattern());
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(matchOptions.getFileType());
        if (profile != null) {
            TemplateEditorUtil.setHighlighter((Editor)this.searchPatternEditor, (TemplateContextType)UIUtil.getTemplateContextType(profile));
        }
        this.searchPatternEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)configuration);
        SubstitutionShortInfoHandler.retrieve(this.searchPatternEditor).updateEditorInlays();
        if (this.replace) {
            String replacement = configuration instanceof ReplaceConfiguration ? configuration.getReplaceOptions().getReplacement() : configuration.getMatchOptions().getSearchPattern();
            UIUtil.setContent(this.replacePatternEditor, replacement);
            if (profile != null) {
                TemplateEditorUtil.setHighlighter((Editor)this.replacePatternEditor, (TemplateContextType)UIUtil.getTemplateContextType(profile));
            }
            this.replacePatternEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)configuration);
            SubstitutionShortInfoHandler.retrieve(this.replacePatternEditor).updateEditorInlays();
        }
    }

    public Configuration @NotNull [] getSelectedConfigurations() {
        if (this.showHistory) {
            List<Configuration> selectedValues = this.existingTemplatesComponent.getHistoryList().getSelectedValuesList();
            return selectedValues.toArray(Configuration.EMPTY_ARRAY);
        }
        TreePath[] paths = this.existingTemplatesComponent.getPatternTree().getSelectionModel().getSelectionPaths();
        if (paths == null) {
            return Configuration.EMPTY_ARRAY;
        }
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (TreePath path : paths) {
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node2.getUserObject();
            if (!(userObject instanceof Configuration)) continue;
            configurations.add((Configuration)userObject);
        }
        return configurations.toArray(Configuration.EMPTY_ARRAY);
    }

    class MySelectionListener
    implements TreeSelectionListener,
    ListSelectionListener {
        MySelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Configuration configuration = SelectTemplateDialog.this.existingTemplatesComponent.getSelectedConfiguration();
            SelectTemplateDialog.this.showPatternPreviewFromConfiguration(configuration);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || e.getLastIndex() == -1) {
                return;
            }
            int selectionIndex = SelectTemplateDialog.this.existingTemplatesComponent.getHistoryList().getSelectedIndex();
            if (selectionIndex != -1) {
                SelectTemplateDialog.this.setPatternFromList(selectionIndex);
            }
        }
    }
}

