/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.PatternContext;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileTypeInfo {
    public static final FileTypeInfo[] EMPTY_ARRAY = new FileTypeInfo[0];
    private static final Pattern CLEANUP = Pattern.compile("(?i)\\s+file(?:s)?$");
    private final LanguageFileType myFileType;
    private final Language myDialect;
    private final PatternContext myContext;
    private final boolean myNested;
    private final String myDescription;

    FileTypeInfo(@NotNull LanguageFileType fileType, @NotNull Language dialect, @Nullable PatternContext context2, boolean nested) {
        this.myFileType = fileType;
        this.myDialect = dialect;
        this.myContext = context2;
        this.myNested = nested;
        this.myDescription = FileTypeInfo.getDescription(fileType);
    }

    @NotNull
    public LanguageFileType getFileType() {
        return this.myFileType;
    }

    @Nullable
    public Language getDialect() {
        return this.myDialect;
    }

    @Nullable
    public PatternContext getContext() {
        return this.myContext;
    }

    @NotNull
    public String getText() {
        if (this.myNested) {
            if (this.myDialect != null && this.myDialect != this.myFileType.getLanguage()) {
                return this.myDialect.getDisplayName();
            }
            if (this.myContext != null) {
                return this.myDescription + " - " + this.myContext.getDisplayName();
            }
        }
        return this.myDescription;
    }

    @NotNull
    public String getSearchText() {
        return this.myDialect != null ? this.myDialect.getDisplayName() : this.myFileType.getName();
    }

    public boolean isNested() {
        return this.myNested;
    }

    public boolean isEqualTo(@NotNull LanguageFileType fileType, @Nullable Language dialect, @Nullable PatternContext context2) {
        return !(this.myFileType != fileType || dialect != null && this.myDialect != dialect || context2 != null && this.myContext != context2);
    }

    @NotNull
    private static String getDescription(@NotNull LanguageFileType fileType) {
        String description2 = fileType.getDescription();
        return StringUtil.capitalizeWords((String)CLEANUP.matcher(description2).replaceAll(""), (boolean)true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileTypeInfo)) {
            return false;
        }
        FileTypeInfo info = (FileTypeInfo)o;
        return this.myFileType == info.myFileType && this.myDialect == info.myDialect && this.myContext == info.myContext;
    }

    public int hashCode() {
        return Objects.hash(this.myFileType, this.myDialect, this.myContext);
    }

    public String toString() {
        return this.getText();
    }
}

