/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import java.io.IOException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public final class ConfigurationUtil {
    private ConfigurationUtil() {
    }

    @NotNull
    public static String toXml(@NotNull Configuration configuration) {
        configuration = configuration.copy();
        configuration.getMatchOptions().setScope(null);
        String className = configuration.getClass().getSimpleName();
        Element element = new Element(Character.toLowerCase(className.charAt(0)) + className.substring(1));
        configuration.writeExternal(element);
        return JDOMUtil.writeElement((Element)element);
    }

    public static Configuration fromXml(@NotNull String xml) throws JDOMException {
        Configuration configuration;
        if ((xml = xml.trim()).startsWith("<searchConfiguration ") && xml.endsWith("</searchConfiguration>")) {
            configuration = new SearchConfiguration();
        } else if (xml.startsWith("<replaceConfiguration ") && xml.endsWith("</replaceConfiguration>")) {
            configuration = new ReplaceConfiguration();
        } else {
            return null;
        }
        try {
            Element element = JDOMUtil.load((CharSequence)xml);
            configuration.readExternal(element);
            return configuration;
        }
        catch (IOException ignored) {
            return null;
        }
    }
}

