/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementInfoImpl;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Replacer {
    private final Project project;
    private final ReplaceOptions options;
    private final StructuralReplaceHandler replaceHandler;
    private final ReplacementBuilder replacementBuilder;
    private PsiElement lastAffectedElement = null;

    public Replacer(Project project2, ReplaceOptions options2) {
        this.project = project2;
        this.options = options2;
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(options2.getMatchOptions().getFileType());
        assert (profile != null);
        this.replaceHandler = profile.getReplaceHandler(project2, options2);
        assert (this.replaceHandler != null);
        this.replacementBuilder = new ReplacementBuilder(this.project, this.options);
    }

    public static String stripTypedVariableDecoration(String type) {
        return type.substring(1, type.length() - 1);
    }

    public static int insertSubstitution(StringBuilder result2, int offset, ParameterInfo info, String image) {
        if (!image.isEmpty()) {
            result2.insert(offset + info.getStartIndex(), image);
            offset += image.length();
        }
        return offset;
    }

    public static String testReplace(String in, String what, String by, ReplaceOptions options2, Project project2) {
        return Replacer.testReplace(in, what, by, options2, project2, false);
    }

    public static String testReplace(String in, String what, String by, ReplaceOptions options2, Project project2, boolean sourceIsFile) {
        LanguageFileType type = options2.getMatchOptions().getFileType();
        return Replacer.testReplace(in, what, by, options2, project2, sourceIsFile, false, type, null);
    }

    public static String testReplace(String in, String what, String by, ReplaceOptions replaceOptions, Project project2, boolean sourceIsFile, boolean createPhysicalFile, LanguageFileType sourceFileType, Language sourceDialect) {
        replaceOptions.setReplacement(by);
        MatchOptions matchOptions = replaceOptions.getMatchOptions();
        matchOptions.fillSearchCriteria(what);
        Matcher.validate(project2, matchOptions);
        Replacer.checkReplacementPattern(project2, replaceOptions);
        Replacer replacer = new Replacer(project2, replaceOptions);
        Matcher matcher = new Matcher(project2, matchOptions);
        try {
            PsiElement nextSibling;
            PsiElement parent;
            PsiElement lastElement;
            PsiElement firstElement;
            if (matchOptions.getScope() == null) {
                PsiElement[] elements = MatcherImplUtil.createTreeFromText(in, new PatternContextInfo(sourceIsFile ? PatternTreeContext.File : PatternTreeContext.Block), sourceFileType, sourceDialect, project2, createPhysicalFile);
                firstElement = elements[0];
                lastElement = elements[elements.length - 1];
                parent = firstElement.getParent();
                matchOptions.setScope((SearchScope)new LocalSearchScope(elements));
            } else {
                parent = ((LocalSearchScope)matchOptions.getScope()).getScope()[0];
                firstElement = parent.getFirstChild();
                lastElement = parent.getLastChild();
            }
            CollectingMatchResultSink sink = new CollectingMatchResultSink();
            matcher.testFindMatches(sink);
            SmartList replacements = new SmartList();
            for (MatchResult result2 : sink.getMatches()) {
                replacements.add(replacer.buildReplacement(result2));
            }
            int startOffset = firstElement.getTextRange().getStartOffset();
            int endOffset = sourceIsFile ? 0 : parent.getTextLength() - lastElement.getTextRange().getEndOffset();
            PsiElement prevSibling = firstElement.getPrevSibling();
            if (prevSibling instanceof PsiWhiteSpace) {
                startOffset -= prevSibling.getTextLength();
            }
            if ((nextSibling = lastElement.getNextSibling()) instanceof PsiWhiteSpace) {
                endOffset -= nextSibling.getTextLength();
            }
            replacer.replaceAll((List<? extends ReplacementInfo>)replacements);
            if (firstElement == lastElement && firstElement instanceof PsiFile) {
                String string = firstElement.getText();
                return string;
            }
            String result3 = parent.getText();
            String string = result3.substring(startOffset, result3.length() - endOffset);
            return string;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IncorrectOperationException((Throwable)e);
        }
        finally {
            matchOptions.setScope(null);
        }
    }

    public void replaceAll(List<? extends ReplacementInfo> infos) {
        for (ReplacementInfo replacementInfo : infos) {
            this.replaceHandler.prepare(replacementInfo);
        }
        ((ApplicationEx)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread(SSRBundle.message("structural.replace.title", new Object[0]), this.project, null, indicator -> {
            indicator.setIndeterminate(false);
            try {
                int size = infos.size();
                VirtualFile lastFile = null;
                for (int i2 = 0; i2 < size; ++i2) {
                    indicator.checkCanceled();
                    indicator.setFraction((double)((float)(i2 + 1) / (float)size));
                    ReplacementInfo info = (ReplacementInfo)infos.get(i2);
                    PsiElement element = info.getMatch(0);
                    if (element == null) continue;
                    VirtualFile vFile = element.getContainingFile().getVirtualFile();
                    if (vFile != null && !vFile.equals(lastFile)) {
                        indicator.setText2(vFile.getPresentableUrl());
                        lastFile = vFile;
                    }
                    ProgressManager.getInstance().executeNonCancelableSection(() -> {
                        PsiElement affectedElement = this.doReplace(info);
                        if (affectedElement != this.lastAffectedElement) {
                            if (this.lastAffectedElement != null) {
                                this.reformatAndPostProcess(this.lastAffectedElement);
                            }
                            this.lastAffectedElement = affectedElement;
                        }
                    });
                }
            }
            finally {
                ProgressManager.getInstance().executeNonCancelableSection(() -> this.reformatAndPostProcess(this.lastAffectedElement));
            }
        });
    }

    public void replace(ReplacementInfo info) {
        this.replaceHandler.prepare(info);
        this.reformatAndPostProcess(this.doReplace(info));
    }

    @Nullable
    private PsiElement doReplace(ReplacementInfo info) {
        PsiElement element = info.getMatch(0);
        if (element == null || !element.isWritable() || !element.isValid()) {
            return null;
        }
        PsiElement elementParent = StructuralSearchUtil.getPresentableElement(element).getParent();
        CodeStyleManager.getInstance((Project)this.project).performActionWithFormatterDisabled(() -> this.replaceHandler.replace(info, this.options));
        if (!elementParent.isValid() || !elementParent.isWritable()) {
            return null;
        }
        return elementParent;
    }

    private void reformatAndPostProcess(PsiElement elementParent) {
        if (elementParent == null || !elementParent.isValid()) {
            return;
        }
        PsiFile containingFile = elementParent.getContainingFile();
        if (containingFile != null && this.options.isToReformatAccordingToStyle()) {
            Document document2;
            VirtualFile file2 = containingFile.getVirtualFile();
            if (file2 != null && (document2 = FileDocumentManager.getInstance().getDocument(file2)) != null) {
                PsiDocumentManager.getInstance((Project)this.project).commitDocument(document2);
            }
            int parentOffset = elementParent.getTextRange().getStartOffset();
            CodeStyleManager.getInstance((Project)this.project).reformatRange((PsiElement)containingFile, parentOffset, parentOffset + elementParent.getTextLength(), true);
        }
        this.replaceHandler.postProcess(elementParent, this.options);
    }

    public static void handleComments(PsiElement el, PsiElement replacement, ReplacementInfo replacementInfo) {
        PsiElement firstChild;
        PsiElement lastChild = el.getLastChild();
        if (lastChild instanceof PsiComment && replacementInfo.getVariableName(lastChild) == null && !(replacement.getLastChild() instanceof PsiComment)) {
            PsiElement firstElementAfterStatementEnd = lastChild;
            for (PsiElement curElement = firstElementAfterStatementEnd.getPrevSibling(); curElement != null && (curElement instanceof PsiWhiteSpace || curElement instanceof PsiComment); curElement = curElement.getPrevSibling()) {
                firstElementAfterStatementEnd = curElement;
            }
            replacement.addRangeAfter(firstElementAfterStatementEnd, lastChild, replacement.getLastChild());
        }
        if ((firstChild = el.getFirstChild()) instanceof PsiComment && !(firstChild instanceof PsiDocCommentBase) && replacementInfo.getVariableName(firstChild) == null) {
            PsiElement lastElementBeforeStatementStart = firstChild;
            for (PsiElement curElement = lastElementBeforeStatementStart.getNextSibling(); curElement != null && (curElement instanceof PsiWhiteSpace || curElement instanceof PsiComment); curElement = curElement.getNextSibling()) {
                lastElementBeforeStatementStart = curElement;
            }
            replacement.addRangeBefore(firstChild, lastElementBeforeStatementStart, replacement.getFirstChild());
        }
    }

    public static void checkReplacementPattern(Project project2, ReplaceOptions options2) {
        try {
            String search = options2.getMatchOptions().getSearchPattern();
            String replacement = options2.getReplacement();
            LanguageFileType fileType = options2.getMatchOptions().getFileType();
            Template searchTemplate = TemplateManager.getInstance((Project)project2).createTemplate("", "", search);
            Template replaceTemplate = TemplateManager.getInstance((Project)project2).createTemplate("", "", replacement);
            int segmentCount = replaceTemplate.getSegmentsCount();
            for (int i2 = 0; i2 < segmentCount; ++i2) {
                String searchSegmentName;
                int j;
                String replacementSegmentName = replaceTemplate.getSegmentName(i2);
                int segmentCount2 = searchTemplate.getSegmentsCount();
                for (j = 0; j < segmentCount2 && !replacementSegmentName.equals(searchSegmentName = searchTemplate.getSegmentName(j)); ++j) {
                    if (!replacementSegmentName.startsWith(searchSegmentName) || replacementSegmentName.charAt(searchSegmentName.length()) != '_') continue;
                    try {
                        Integer.parseInt(replacementSegmentName.substring(searchSegmentName.length() + 1));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (j != segmentCount2) continue;
                ReplacementVariableDefinition definition = options2.getVariableDefinition(replacementSegmentName);
                if (definition == null || definition.getScriptCodeConstraint().length() <= 2) {
                    throw new MalformedPatternException(SSRBundle.message("replacement.variable.is.not.defined.message", replacementSegmentName));
                }
                String message = ScriptSupport.checkValidScript(StringUtil.unquoteString((String)definition.getScriptCodeConstraint()), options2.getMatchOptions());
                if (message == null) continue;
                throw new MalformedPatternException(SSRBundle.message("replacement.variable.is.not.valid", replacementSegmentName, message));
            }
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(fileType);
            assert (profile != null);
            ReadAction.run(() -> profile.checkReplacementPattern(project2, options2));
        }
        catch (IncorrectOperationException ex) {
            throw new MalformedPatternException(SSRBundle.message("incorrect.pattern.message", new Object[0]));
        }
    }

    public ReplacementInfo buildReplacement(MatchResult result2) {
        ReplacementInfoImpl replacementInfo = new ReplacementInfoImpl(result2, this.project);
        replacementInfo.setReplacement(this.replacementBuilder.process(result2, replacementInfo, this.options.getMatchOptions().getFileType()));
        return replacementInfo;
    }
}

