/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace;

import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceOptions
implements JDOMExternalizable {
    private final Map<String, ReplacementVariableDefinition> variableDefs;
    private String replacement;
    private boolean toShortenFQN;
    private boolean myToReformatAccordingToStyle;
    private boolean myToUseStaticImport;
    private final MatchOptions matchOptions;
    @NonNls
    private static final String REFORMAT_ATTR_NAME = "reformatAccordingToStyle";
    @NonNls
    private static final String REPLACEMENT_ATTR_NAME = "replacement";
    @NonNls
    private static final String SHORTEN_FQN_ATTR_NAME = "shortenFQN";
    @NonNls
    private static final String USE_STATIC_IMPORT_ATTR_NAME = "useStaticImport";
    @NonNls
    private static final String VARIABLE_DEFINITION_TAG_NAME = "variableDefinition";

    public ReplaceOptions() {
        this(new MatchOptions());
    }

    public ReplaceOptions(MatchOptions matchOptions) {
        this.variableDefs = new LinkedHashMap<String, ReplacementVariableDefinition>();
        this.matchOptions = matchOptions;
        this.replacement = "";
        this.myToUseStaticImport = false;
    }

    ReplaceOptions(ReplaceOptions options2) {
        this.variableDefs = new LinkedHashMap<String, ReplacementVariableDefinition>(options2.variableDefs.size());
        options2.variableDefs.forEach((key, value) -> this.variableDefs.put((String)key, value.copy()));
        this.replacement = options2.replacement;
        this.toShortenFQN = options2.toShortenFQN;
        this.myToReformatAccordingToStyle = options2.myToReformatAccordingToStyle;
        this.myToUseStaticImport = options2.myToUseStaticImport;
        this.matchOptions = options2.matchOptions.copy();
    }

    public ReplaceOptions copy() {
        return new ReplaceOptions(this);
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(@NotNull String replacement) {
        this.replacement = replacement;
    }

    public boolean isToShortenFQN() {
        return this.toShortenFQN;
    }

    public void setToShortenFQN(boolean shortedFQN) {
        this.toShortenFQN = shortedFQN;
    }

    public boolean isToReformatAccordingToStyle() {
        return this.myToReformatAccordingToStyle;
    }

    public MatchOptions getMatchOptions() {
        return this.matchOptions;
    }

    public void setToReformatAccordingToStyle(boolean reformatAccordingToStyle) {
        this.myToReformatAccordingToStyle = reformatAccordingToStyle;
    }

    public boolean isToUseStaticImport() {
        return this.myToUseStaticImport;
    }

    public void setToUseStaticImport(boolean useStaticImport) {
        this.myToUseStaticImport = useStaticImport;
    }

    private Set<String> getUsedVariableNames() {
        return TemplateImplUtil.parseVariableNames((CharSequence)this.replacement);
    }

    public void removeUnusedVariables() {
        this.variableDefs.keySet().removeIf(key -> !this.getUsedVariableNames().contains(key));
    }

    public void readExternal(Element element) {
        this.matchOptions.readExternal(element);
        Attribute attribute = element.getAttribute(REFORMAT_ATTR_NAME);
        try {
            this.myToReformatAccordingToStyle = attribute == null || attribute.getBooleanValue();
        }
        catch (DataConversionException dataConversionException) {
            // empty catch block
        }
        attribute = element.getAttribute(SHORTEN_FQN_ATTR_NAME);
        try {
            this.toShortenFQN = attribute == null || attribute.getBooleanValue();
        }
        catch (DataConversionException dataConversionException) {
            // empty catch block
        }
        attribute = element.getAttribute(USE_STATIC_IMPORT_ATTR_NAME);
        if (attribute != null) {
            try {
                this.myToUseStaticImport = attribute.getBooleanValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        this.replacement = element.getAttributeValue(REPLACEMENT_ATTR_NAME);
        for (Element child : element.getChildren(VARIABLE_DEFINITION_TAG_NAME)) {
            ReplacementVariableDefinition variableDefinition = new ReplacementVariableDefinition();
            variableDefinition.readExternal(child);
            this.addVariableDefinition(variableDefinition);
        }
    }

    public void writeExternal(Element element) {
        this.matchOptions.writeExternal(element);
        element.setAttribute(REFORMAT_ATTR_NAME, String.valueOf(this.myToReformatAccordingToStyle));
        element.setAttribute(SHORTEN_FQN_ATTR_NAME, String.valueOf(this.toShortenFQN));
        if (this.myToUseStaticImport) {
            element.setAttribute(USE_STATIC_IMPORT_ATTR_NAME, String.valueOf(true));
        }
        element.setAttribute(REPLACEMENT_ATTR_NAME, this.replacement);
        Set<String> nameSet = this.getUsedVariableNames();
        for (ReplacementVariableDefinition variableDefinition : this.variableDefs.values()) {
            if (!nameSet.contains(variableDefinition.getName())) continue;
            Element infoElement = new Element(VARIABLE_DEFINITION_TAG_NAME);
            element.addContent(infoElement);
            variableDefinition.writeExternal(infoElement);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplaceOptions)) {
            return false;
        }
        ReplaceOptions replaceOptions = (ReplaceOptions)o;
        if (this.myToReformatAccordingToStyle != replaceOptions.myToReformatAccordingToStyle) {
            return false;
        }
        if (this.toShortenFQN != replaceOptions.toShortenFQN) {
            return false;
        }
        if (this.myToUseStaticImport != replaceOptions.myToUseStaticImport) {
            return false;
        }
        if (!this.matchOptions.equals(replaceOptions.matchOptions)) {
            return false;
        }
        if (!Objects.equals(this.replacement, replaceOptions.replacement)) {
            return false;
        }
        return this.variableDefs.equals(replaceOptions.variableDefs);
    }

    public int hashCode() {
        int result2 = this.replacement.hashCode();
        result2 = 29 * result2 + (this.toShortenFQN ? 1 : 0);
        result2 = 29 * result2 + (this.myToReformatAccordingToStyle ? 1 : 0);
        result2 = 29 * result2 + (this.myToUseStaticImport ? 1 : 0);
        result2 = 29 * result2 + this.matchOptions.hashCode();
        result2 = 29 * result2 + this.variableDefs.hashCode();
        return result2;
    }

    public ReplacementVariableDefinition getVariableDefinition(String name) {
        return this.variableDefs != null ? this.variableDefs.get(name) : null;
    }

    public void addVariableDefinition(ReplacementVariableDefinition definition) {
        this.variableDefs.put(definition.getName(), definition);
    }

    public ReplacementVariableDefinition addNewVariableDefinition(String name) {
        ReplacementVariableDefinition definition = new ReplacementVariableDefinition(name);
        this.variableDefs.put(name, definition);
        return definition;
    }

    public Collection<ReplacementVariableDefinition> getVariableDefinitions() {
        return this.variableDefs.values();
    }

    public void clearVariableDefinitions() {
        this.variableDefs.clear();
    }
}

