/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.InspectionProfileActionProvider;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.InspectionProfileUtil;
import com.intellij.structuralsearch.inspection.SSBasedInspection;
import com.intellij.structuralsearch.inspection.StructuralSearchInspectionToolWrapper;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ui.FormBuilder;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchProfileActionProvider
extends InspectionProfileActionProvider {
    @NotNull
    public List<AnAction> getActions(SingleInspectionProfilePanel panel2) {
        InspectionProfileModifiableModel profile = panel2.getProfile();
        if (profile.getToolsOrNull("SSBasedInspection", null) != null && !profile.isToolEnabled(HighlightDisplayKey.find((String)"SSBasedInspection"))) {
            profile.setToolEnabled("SSBasedInspection", true);
            for (ScopeToolState tool : profile.getAllTools()) {
                InspectionToolWrapper wrapper = tool.getTool();
                if (!(wrapper instanceof StructuralSearchInspectionToolWrapper)) continue;
                tool.setEnabled(false);
            }
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{new AddInspectionAction(panel2, false), new AddInspectionAction(panel2, true)});
        actionGroup.setPopup(true);
        actionGroup.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)panel2);
        Presentation presentation = actionGroup.getTemplatePresentation();
        presentation.setIcon(AllIcons.General.Add);
        presentation.setText(SSRBundle.messagePointer("add.inspection.button", new Object[0]));
        return Arrays.asList(new AnAction[]{actionGroup, new RemoveInspectionAction(panel2)});
    }

    public static void createNewInspection(@NotNull Configuration configuration, @NotNull Project project2) {
        StructuralSearchProfileActionProvider.createNewInspection(configuration, project2, InspectionProfileManager.getInstance((Project)project2).getCurrentProfile());
    }

    static boolean createNewInspection(@NotNull Configuration configuration, @NotNull Project project2, @NotNull InspectionProfileImpl profile) {
        InspectionDataDialog dialog;
        SSBasedInspection inspection = InspectionProfileUtil.getStructuralSearchInspection((InspectionProfile)profile);
        if (!ApplicationManager.getApplication().isUnitTestMode() && !(dialog = new InspectionDataDialog(project2, inspection, configuration, true)).showAndGet()) {
            return false;
        }
        configuration.setUuid(null);
        inspection.addConfiguration(configuration);
        StructuralSearchProfileActionProvider.addInspectionToProfile(project2, profile, configuration);
        InspectionProfileUtil.fireProfileChanged(profile);
        profile.getProfileManager().fireProfileChanged(profile);
        return true;
    }

    private static void addInspectionToProfile(@NotNull Project project2, InspectionProfileImpl profile, Configuration configuration) {
        String shortName = configuration.getUuid().toString();
        InspectionToolWrapper toolWrapper = profile.getInspectionTool(shortName, project2);
        if (toolWrapper != null) {
            return;
        }
        StructuralSearchInspectionToolWrapper wrapped = new StructuralSearchInspectionToolWrapper(Collections.singletonList(configuration));
        profile.addTool(project2, (InspectionToolWrapper)wrapped, null);
        profile.setToolEnabled(shortName, true);
    }

    static class InspectionDataDialog
    extends DialogWrapper {
        private final Pattern mySuppressIdPattern = Pattern.compile("[a-zA-Z_0-9.-]+");
        private final SSBasedInspection myInspection;
        @NotNull
        private final Configuration myConfiguration;
        private final boolean myNewInspection;
        private final JTextField myNameTextField;
        private final JTextField myProblemDescriptorTextField;
        private final EditorTextField myDescriptionTextArea;
        private final JTextField mySuppressIdTextField;

        InspectionDataDialog(Project project2, SSBasedInspection inspection, Configuration configuration, boolean newInspection) {
            super(null);
            this.myInspection = inspection;
            this.myConfiguration = configuration;
            this.myNewInspection = newInspection;
            assert (this.myConfiguration.getOrder() == 0);
            this.myNameTextField = new JTextField(configuration.getName());
            this.myProblemDescriptorTextField = new JTextField(configuration.getProblemDescriptor());
            this.myDescriptionTextArea = new EditorTextField((String)ObjectUtils.notNull((Object)configuration.getDescription(), (Object)""), project2, (FileType)StdFileTypes.HTML);
            this.myDescriptionTextArea.setOneLineMode(false);
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.myDescriptionTextArea.setFont(scheme.getFont(EditorFontType.PLAIN));
            this.myDescriptionTextArea.setPreferredSize(new Dimension(375, 125));
            this.myDescriptionTextArea.setMinimumSize(new Dimension(200, 50));
            this.mySuppressIdTextField = new JTextField(configuration.getSuppressId());
            this.setTitle(SSRBundle.message("meta.data.dialog.title", new Object[0]));
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myNameTextField;
        }

        @NotNull
        protected List<ValidationInfo> doValidateAll() {
            SmartList warnings = new SmartList();
            List<Configuration> configurations = this.myInspection.getConfigurations();
            String name = this.getName();
            if (StringUtil.isEmpty((String)name)) {
                warnings.add(new ValidationInfo(SSRBundle.message("name.must.not.be.empty.warning", new Object[0]), (JComponent)this.myNameTextField));
            } else {
                for (Configuration configuration : configurations) {
                    if (configuration.getOrder() != 0) continue;
                    if (this.myNewInspection) {
                        if (!configuration.getName().equals(name)) continue;
                        warnings.add(new ValidationInfo(SSRBundle.message("inspection.with.name.exists.warning", name), (JComponent)this.myNameTextField));
                        break;
                    }
                    if (configuration.getUuid().equals(this.myConfiguration.getUuid()) || !configuration.getName().equals(name)) continue;
                    warnings.add(new ValidationInfo(SSRBundle.message("inspection.with.name.exists.warning", name), (JComponent)this.myNameTextField));
                    break;
                }
            }
            String suppressId = this.getSuppressId();
            if (!StringUtil.isEmpty((String)suppressId)) {
                if (!this.mySuppressIdPattern.matcher(suppressId).matches()) {
                    warnings.add(new ValidationInfo(SSRBundle.message("suppress.id.must.match.regex.warning", new Object[0]), (JComponent)this.mySuppressIdTextField));
                } else {
                    HighlightDisplayKey key = HighlightDisplayKey.findById((String)suppressId);
                    if (key != null && key != HighlightDisplayKey.find((String)this.myConfiguration.getUuid().toString())) {
                        warnings.add(new ValidationInfo(SSRBundle.message("suppress.id.in.use.warning", suppressId), (JComponent)this.mySuppressIdTextField));
                    } else {
                        for (Configuration configuration : configurations) {
                            if (!suppressId.equals(configuration.getSuppressId()) || this.myConfiguration.getUuid().equals(configuration.getUuid())) continue;
                            warnings.add(new ValidationInfo(SSRBundle.message("suppress.id.in.use.warning", suppressId), (JComponent)this.mySuppressIdTextField));
                            break;
                        }
                    }
                }
            }
            return warnings;
        }

        protected void doOKAction() {
            super.doOKAction();
            if (this.getOKAction().isEnabled()) {
                this.myConfiguration.setName(this.getName());
                this.myConfiguration.setDescription(this.getDescription());
                this.myConfiguration.setSuppressId(this.getSuppressId());
                this.myConfiguration.setProblemDescriptor(this.getProblemDescriptor());
            }
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return new FormBuilder().addLabeledComponent(SSRBundle.message("inspection.name.label", new Object[0]), (JComponent)this.myNameTextField, true).addLabeledComponent(SSRBundle.message("problem.descriptor.label", new Object[0]), (JComponent)this.myProblemDescriptorTextField, true).addLabeledComponentFillVertically(SSRBundle.message("description.label", new Object[0]), (JComponent)this.myDescriptionTextArea).addLabeledComponent(SSRBundle.message("suppress.id.label", new Object[0]), (JComponent)this.mySuppressIdTextField).getPanel();
        }

        public String getName() {
            return this.myNameTextField.getText().trim();
        }

        @Nullable
        public String getDescription() {
            return InspectionDataDialog.convertEmptyToNull(this.myDescriptionTextArea.getText());
        }

        @Nullable
        public String getSuppressId() {
            return InspectionDataDialog.convertEmptyToNull(this.mySuppressIdTextField.getText());
        }

        @Nullable
        public String getProblemDescriptor() {
            return InspectionDataDialog.convertEmptyToNull(this.myProblemDescriptorTextField.getText());
        }

        private static String convertEmptyToNull(String s) {
            return StringUtil.isEmpty((String)s.trim()) ? null : s;
        }
    }

    private static class AddInspectionAction
    extends DumbAwareAction {
        private final SingleInspectionProfilePanel myPanel;
        private final boolean myReplace;

        private AddInspectionAction(SingleInspectionProfilePanel panel2, boolean replace) {
            super(replace ? SSRBundle.message("SSRInspection.add.replace.template.button", new Object[0]) : SSRBundle.message("SSRInspection.add.search.template.button", new Object[0]));
            this.myPanel = panel2;
            this.myReplace = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SearchContext context2 = new SearchContext(e.getDataContext());
            StructuralSearchDialog dialog = new StructuralSearchDialog(context2, this.myReplace, true);
            if (!dialog.showAndGet()) {
                return;
            }
            InspectionProfileModifiableModel profile = this.myPanel.getProfile();
            Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
            assert (project2 != null);
            Configuration configuration = dialog.getConfiguration();
            configuration.setOrder(0);
            configuration.setName(SSRBundle.message("new.template.defaultname", new Object[0]));
            configuration.setDescription("");
            configuration.setProblemDescriptor("");
            configuration.setSuppressId("");
            if (!StructuralSearchProfileActionProvider.createNewInspection(configuration, project2, (InspectionProfileImpl)profile)) {
                return;
            }
            this.myPanel.selectInspectionTool(configuration.getUuid().toString());
        }
    }

    private static class RemoveInspectionAction
    extends DumbAwareAction {
        private final SingleInspectionProfilePanel myPanel;

        private RemoveInspectionAction(SingleInspectionProfilePanel panel2) {
            super(SSRBundle.message("remove.inspection.button", new Object[0]), null, AllIcons.General.Remove);
            this.myPanel = panel2;
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)this.myPanel);
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(this.myPanel.getSelectedTool() instanceof StructuralSearchInspectionToolWrapper);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            InspectionToolWrapper selectedTool = this.myPanel.getSelectedTool();
            String shortName = selectedTool.getShortName();
            this.myPanel.removeSelectedRow();
            InspectionProfileModifiableModel profile = this.myPanel.getProfile();
            SSBasedInspection inspection = InspectionProfileUtil.getStructuralSearchInspection((InspectionProfile)profile);
            inspection.removeConfigurationsWithUuid(UUID.fromString(shortName));
            profile.removeTool(shortName);
            InspectionProfileUtil.fireProfileChanged((InspectionProfileImpl)profile);
        }
    }
}

