/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.InspectionProfileUtil;
import com.intellij.structuralsearch.inspection.SSBasedInspection;
import com.intellij.structuralsearch.inspection.StructuralSearchProfileActionProvider;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationCellRenderer;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.SmartList;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchFakeInspection
extends LocalInspectionTool {
    private Configuration myMainConfiguration;
    @NotNull
    private final List<Configuration> myConfigurations;

    public StructuralSearchFakeInspection(@NotNull @NotNull Collection<@NotNull Configuration> configurations) {
        if (configurations.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.myConfigurations = new SmartList(configurations);
        this.myConfigurations.sort(Comparator.comparingInt(Configuration::getOrder));
        this.myMainConfiguration = this.myConfigurations.get(0);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getDisplayName() {
        return this.myMainConfiguration.getName();
    }

    @NotNull
    public String getShortName() {
        return this.myMainConfiguration.getUuid().toString();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        HighlightDisplayKey key = HighlightDisplayKey.find((String)this.getShortName());
        if (key != null) {
            return key.getID();
        }
        String suppressId = this.myMainConfiguration.getSuppressId();
        return !StringUtil.isEmpty((String)suppressId) ? suppressId : "SSBasedInspection";
    }

    @Nullable
    public String getAlternativeID() {
        return "SSBasedInspection";
    }

    @Nullable
    public String getMainToolId() {
        return "SSBasedInspection";
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getGroupDisplayName() {
        return SSRBundle.message("structural.search.group.name", new Object[0]);
    }

    @Nullable
    public String getStaticDescription() {
        String description2 = this.myMainConfiguration.getDescription();
        if (StringUtil.isEmpty((String)description2)) {
            return SSRBundle.message("no.description.message", new Object[0]);
        }
        return description2;
    }

    @NotNull
    public List<Configuration> getConfigurations() {
        return Collections.unmodifiableList(this.myConfigurations);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MyListModel model = new MyListModel();
        JButton button = new JButton(SSRBundle.message("edit.metadata.button", new Object[0]));
        button.addActionListener(e -> this.performEditMetaData(button));
        JBList list = new JBList((ListModel)model);
        list.setCellRenderer(new ConfigurationCellRenderer());
        JPanel listPanel = ToolbarDecorator.createDecorator((JList)list).setAddAction(arg_0 -> this.lambda$createOptionsPanel$1((JList)list, arg_0)).setAddActionName(SSRBundle.message("add.pattern.action", new Object[0])).setRemoveAction(arg_0 -> this.lambda$createOptionsPanel$2((JList)list, arg_0)).setRemoveActionUpdater(arg_0 -> StructuralSearchFakeInspection.lambda$createOptionsPanel$3((JList)list, arg_0)).setEditAction(arg_0 -> this.lambda$createOptionsPanel$4((JList)list, arg_0)).setMoveUpAction(arg_0 -> this.lambda$createOptionsPanel$5((JList)list, arg_0)).setMoveDownAction(arg_0 -> this.lambda$createOptionsPanel$6((JList)list, arg_0)).createPanel();
        new DoubleClickListener((JList)list){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                StructuralSearchFakeInspection.this.performEdit(this.val$list);
                return true;
            }
        }.installOn((Component)list);
        JPanel panel2 = new FormBuilder().addComponent((JComponent)button).addLabeledComponentFillVertically(SSRBundle.message("templates.title", new Object[0]), (JComponent)listPanel).getPanel();
        panel2.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        return panel2;
    }

    private void performEditMetaData(Component context2) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(context2));
        InspectionProfileModifiableModel profile = InspectionProfileUtil.getInspectionProfile(context2);
        if (profile == null) {
            return;
        }
        SSBasedInspection inspection = InspectionProfileUtil.getStructuralSearchInspection((InspectionProfile)profile);
        StructuralSearchProfileActionProvider.InspectionDataDialog dialog = new StructuralSearchProfileActionProvider.InspectionDataDialog(project2, inspection, this.myMainConfiguration, false);
        if (!dialog.showAndGet()) {
            return;
        }
        String name = dialog.getName();
        for (Configuration c : this.myConfigurations) {
            c.setName(name);
        }
        inspection.removeConfigurationsWithUuid(this.myMainConfiguration.getUuid());
        inspection.addConfigurations(this.myConfigurations);
        profile.setModified(true);
        InspectionProfileUtil.fireProfileChanged((InspectionProfileImpl)profile);
    }

    private void performMove(JList<Configuration> list, boolean up) {
        MyListModel model = (MyListModel)list.getModel();
        List<Configuration> values = list.getSelectedValuesList();
        Comparator<Configuration> c = Comparator.comparingInt(Configuration::getOrder);
        values.sort(up ? c : c.reversed());
        int[] indices = new int[values.size()];
        int size = values.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Configuration value = values.get(i2);
            int order = value.getOrder();
            model.swap(order, order + (up ? -1 : 1));
            indices[i2] = value.getOrder();
        }
        this.myMainConfiguration = StructuralSearchFakeInspection.moveMetaData(this.myMainConfiguration, this.myConfigurations.get(0));
        list.setSelectedIndices(indices);
        list.scrollRectToVisible(list.getCellBounds(indices[0], indices[indices.length - 1]));
        model.fireContentsChanged(list);
        InspectionProfileModifiableModel profile = InspectionProfileUtil.getInspectionProfile(list);
        if (profile == null) {
            return;
        }
        SSBasedInspection inspection = InspectionProfileUtil.getStructuralSearchInspection((InspectionProfile)profile);
        inspection.removeConfigurationsWithUuid(this.myMainConfiguration.getUuid());
        inspection.addConfigurations(this.myConfigurations);
        profile.setModified(true);
    }

    private static Configuration moveMetaData(Configuration source, Configuration target) {
        if (source == target) {
            return source;
        }
        target.setDescription(source.getDescription());
        target.setSuppressId(source.getSuppressId());
        target.setProblemDescriptor(source.getProblemDescriptor());
        source.setDescription(null);
        source.setSuppressId(null);
        source.setProblemDescriptor(null);
        return target;
    }

    private void performAdd(JList<Configuration> list, AnActionButton b) {
        AnAction[] children = new AnAction[]{new AddTemplateAction(list, false), new AddTemplateAction(list, true)};
        RelativePoint point = b.getPreferredPopupPoint();
        if (point == null) {
            return;
        }
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(children), DataManager.getInstance().getDataContext((Component)b.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(point);
    }

    private void performRemove(JList<Configuration> list) {
        boolean metaData = false;
        for (Configuration configuration : list.getSelectedValuesList()) {
            if (configuration.getOrder() == 0) {
                metaData = true;
            }
            this.myConfigurations.remove(configuration);
        }
        if (metaData) {
            this.myMainConfiguration = StructuralSearchFakeInspection.moveMetaData(this.myMainConfiguration, this.myConfigurations.get(0));
        }
        int size = this.myConfigurations.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.myConfigurations.get(i2).setOrder(i2);
        }
        int maxIndex = list.getMaxSelectionIndex();
        if (maxIndex != list.getMinSelectionIndex()) {
            list.setSelectedIndex(maxIndex);
        }
        ((MyListModel)list.getModel()).fireContentsChanged(list);
        if (list.getSelectedIndex() >= size) {
            list.setSelectedIndex(size - 1);
        }
        int index = list.getSelectedIndex();
        list.scrollRectToVisible(list.getCellBounds(index, index));
        InspectionProfileModifiableModel profile = InspectionProfileUtil.getInspectionProfile(list);
        if (profile == null) {
            return;
        }
        SSBasedInspection inspection = InspectionProfileUtil.getStructuralSearchInspection((InspectionProfile)profile);
        inspection.removeConfigurationsWithUuid(this.myMainConfiguration.getUuid());
        inspection.addConfigurations(this.myConfigurations);
        profile.setModified(true);
    }

    private void performEdit(JList<Configuration> list) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(list));
        if (project2 == null) {
            return;
        }
        int index = list.getSelectedIndex();
        Configuration configuration = this.myConfigurations.get(index);
        if (configuration == null) {
            return;
        }
        SearchContext searchContext = new SearchContext(project2);
        StructuralSearchDialog dialog = new StructuralSearchDialog(searchContext, !(configuration instanceof SearchConfiguration), true);
        dialog.loadConfiguration(configuration);
        dialog.setUseLastConfiguration(true);
        if (!dialog.showAndGet()) {
            return;
        }
        Configuration newConfiguration = dialog.getConfiguration();
        if (configuration.getOrder() == 0) {
            this.myMainConfiguration = newConfiguration;
        }
        this.myConfigurations.set(index, newConfiguration);
        MyListModel model = (MyListModel)list.getModel();
        model.fireContentsChanged(list);
        InspectionProfileModifiableModel profile = InspectionProfileUtil.getInspectionProfile(list);
        if (profile == null) {
            return;
        }
        SSBasedInspection inspection = InspectionProfileUtil.getStructuralSearchInspection((InspectionProfile)profile);
        inspection.removeConfiguration(configuration);
        inspection.addConfiguration(newConfiguration);
        profile.setModified(true);
    }

    private /* synthetic */ void lambda$createOptionsPanel$6(JList list, AnActionButton b) {
        this.performMove(list, false);
    }

    private /* synthetic */ void lambda$createOptionsPanel$5(JList list, AnActionButton b) {
        this.performMove(list, true);
    }

    private /* synthetic */ void lambda$createOptionsPanel$4(JList list, AnActionButton b) {
        this.performEdit(list);
    }

    private static /* synthetic */ boolean lambda$createOptionsPanel$3(JList list, AnActionEvent e) {
        return list.getSelectedValuesList().size() < list.getModel().getSize();
    }

    private /* synthetic */ void lambda$createOptionsPanel$2(JList list, AnActionButton b) {
        this.performRemove(list);
    }

    private /* synthetic */ void lambda$createOptionsPanel$1(JList list, AnActionButton b) {
        this.performAdd(list, b);
    }

    private class MyListModel
    extends AbstractListModel<Configuration> {
        private MyListModel() {
        }

        @Override
        public int getSize() {
            return StructuralSearchFakeInspection.this.myConfigurations.size();
        }

        @Override
        public Configuration getElementAt(int index) {
            return (Configuration)StructuralSearchFakeInspection.this.myConfigurations.get(index);
        }

        public void fireContentsChanged(Object source) {
            this.fireContentsChanged(source, -1, -1);
        }

        public void swap(int first, int second) {
            Configuration one = (Configuration)StructuralSearchFakeInspection.this.myConfigurations.get(first);
            Configuration two = (Configuration)StructuralSearchFakeInspection.this.myConfigurations.get(second);
            int order = one.getOrder();
            one.setOrder(two.getOrder());
            two.setOrder(order);
            StructuralSearchFakeInspection.this.myConfigurations.set(second, one);
            StructuralSearchFakeInspection.this.myConfigurations.set(first, two);
        }
    }

    private class AddTemplateAction
    extends DumbAwareAction {
        private final JList<Configuration> myList;
        private final boolean myReplace;

        private AddTemplateAction(JList<Configuration> list, boolean replace) {
            super(replace ? SSRBundle.message("SSRInspection.add.replace.template.button", new Object[0]) : SSRBundle.message("SSRInspection.add.search.template.button", new Object[0]));
            this.myList = list;
            this.myReplace = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
            assert (project2 != null);
            SearchContext context2 = new SearchContext(project2);
            StructuralSearchDialog dialog = new StructuralSearchDialog(context2, this.myReplace, true);
            if (!dialog.showAndGet()) {
                return;
            }
            Configuration configuration = dialog.getConfiguration();
            configuration.setUuid(StructuralSearchFakeInspection.this.myMainConfiguration.getUuid());
            configuration.setName(StructuralSearchFakeInspection.this.myMainConfiguration.getName());
            configuration.setDescription(null);
            configuration.setSuppressId(null);
            configuration.setProblemDescriptor(null);
            MyListModel model = (MyListModel)this.myList.getModel();
            int size = model.getSize();
            configuration.setOrder(size);
            InspectionProfileModifiableModel profile = InspectionProfileUtil.getInspectionProfile(this.myList);
            if (profile == null) {
                return;
            }
            if (InspectionProfileUtil.getStructuralSearchInspection((InspectionProfile)profile).addConfiguration(configuration)) {
                StructuralSearchFakeInspection.this.myConfigurations.add(configuration);
                model.fireContentsChanged(this.myList);
                this.myList.setSelectedIndex(size);
                this.myList.scrollRectToVisible(this.myList.getCellBounds(size, size));
                profile.setModified(true);
            } else {
                int index = StructuralSearchFakeInspection.this.myConfigurations.indexOf(configuration);
                if (index >= 0) {
                    this.myList.setSelectedIndex(index);
                }
            }
        }
    }
}

