/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.DeleteNodesAction;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.compiler.TestModeOptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.AndPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ContainsPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ReferencePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.impl.matcher.predicates.WithinPredicate;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatternCompiler {
    private static final Logger LOG = Logger.getInstance(PatternCompiler.class);
    private static String ourLastSearchPlan;

    public static CompiledPattern compilePattern(Project project2, MatchOptions options2, boolean checkForErrors, boolean optimizeScope) throws MalformedPatternException, NoMatchFoundException {
        return (CompiledPattern)ReadAction.compute(() -> PatternCompiler.doCompilePattern(project2, options2, checkForErrors, optimizeScope));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static CompiledPattern doCompilePattern(Project project2, MatchOptions options2, boolean checkForErrors, boolean optimizeScope) throws MalformedPatternException, NoMatchFoundException {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(options2.getFileType());
        if (profile == null) {
            LOG.warn("no profile found for " + options2.getFileType().getDescription());
            return null;
        }
        CompiledPattern result2 = profile.createCompiledPattern();
        String[] prefixes = result2.getTypedVarPrefixes();
        assert (prefixes.length > 0);
        CompileContext context2 = new CompileContext(result2, options2, project2);
        try {
            List<PsiElement> elements = PatternCompiler.compileByAllPrefixes(project2, options2, result2, context2, prefixes, checkForErrors);
            CompiledPattern pattern = context2.getPattern();
            PatternCompiler.collectVariableNodes(pattern, elements, checkForErrors);
            pattern.setNodes(elements);
            if (checkForErrors) {
                profile.checkSearchPattern(pattern);
            }
            if (optimizeScope) {
                PatternCompiler.optimizeScope(options2, checkForErrors, context2, result2);
            }
            CompiledPattern compiledPattern = result2;
            return compiledPattern;
        }
        finally {
            context2.clear();
        }
    }

    private static void optimizeScope(MatchOptions options2, boolean checkForErrors, CompileContext context2, CompiledPattern result2) throws NoMatchFoundException {
        OptimizingSearchHelper searchHelper = context2.getSearchHelper();
        if (searchHelper.doOptimizing() && searchHelper.isScannedSomething()) {
            Set<VirtualFile> filesToScan = searchHelper.getFilesSetToScan();
            GlobalSearchScope scope = (GlobalSearchScope)options2.getScope();
            assert (scope != null);
            if (checkForErrors && filesToScan.isEmpty()) {
                throw new NoMatchFoundException(SSRBundle.message("ssr.will.not.find.anything", scope.getDisplayName()));
            }
            result2.setScope((SearchScope)(scope.isSearchInLibraries() ? GlobalSearchScope.filesWithLibrariesScope((Project)context2.getProject(), filesToScan) : GlobalSearchScope.filesWithoutLibrariesScope((Project)context2.getProject(), filesToScan)));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ourLastSearchPlan = ((TestModeOptimizingSearchHelper)searchHelper).getSearchPlan();
        }
    }

    private static void collectVariableNodes(final CompiledPattern pattern, List<? extends PsiElement> elements, boolean checkForErrors) throws MalformedPatternException {
        for (PsiElement psiElement : elements) {
            pattern.putVariableNode("__context__", psiElement);
            if (checkForErrors) {
                PatternCompiler.checkForUnknownVariables(pattern, psiElement);
            }
            psiElement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    this.collectNode(element, element.getUserData(CompiledPattern.HANDLER_KEY));
                    super.visitElement(element);
                    if (element instanceof LeafElement) {
                        this.collectNode(element, pattern.getHandler(pattern.getTypedVarString(element)));
                    }
                }

                private void collectNode(PsiElement element, Object handler) {
                    if (handler instanceof DelegatingHandler) {
                        handler = ((DelegatingHandler)handler).getDelegate();
                    }
                    if (handler instanceof SubstitutionHandler) {
                        pattern.putVariableNode(((SubstitutionHandler)handler).getName(), element);
                    }
                }
            });
        }
    }

    private static void checkForUnknownVariables(final CompiledPattern pattern, PsiElement element) {
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element.getUserData(CompiledPattern.HANDLER_KEY) != null) {
                    return;
                }
                super.visitElement(element);
                if (!(element instanceof LeafElement)) {
                    return;
                }
                String text = element.getText();
                if (!pattern.isTypedVar(text)) {
                    for (String prefix : pattern.getTypedVarPrefixes()) {
                        if (!text.contains(prefix)) continue;
                        throw new MalformedPatternException();
                    }
                    return;
                }
                MatchingHandler handler = pattern.getHandler(pattern.getTypedVarString(element));
                if (handler == null) {
                    throw new MalformedPatternException();
                }
            }
        });
    }

    public static String getLastSearchPlan() {
        return ourLastSearchPlan;
    }

    @NotNull
    private static List<PsiElement> compileByAllPrefixes(Project project2, MatchOptions options2, CompiledPattern pattern, CompileContext context2, String @NotNull [] applicablePrefixes, boolean checkForErrors) throws MalformedPatternException {
        if (applicablePrefixes.length == 0) {
            return Collections.emptyList();
        }
        List<PsiElement> elements = PatternCompiler.doCompile(project2, options2, pattern, new ConstantPrefixProvider(applicablePrefixes[0]), context2, checkForErrors);
        if (elements.isEmpty()) {
            return elements;
        }
        PsiFile file2 = elements.get(0).getContainingFile();
        if (file2 == null) {
            return elements;
        }
        PsiElement last = elements.get(elements.size() - 1);
        Pattern[] patterns = new Pattern[applicablePrefixes.length];
        for (int i2 = 0; i2 < applicablePrefixes.length; ++i2) {
            patterns[i2] = Pattern.compile(StructuralSearchUtil.shieldRegExpMetaChars(applicablePrefixes[i2]) + "\\w+\\b");
        }
        int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(file2, patterns);
        int patternEndOffset = last.getTextRange().getEndOffset();
        if (elements.isEmpty() || PatternCompiler.checkErrorElements((PsiElement)file2, patternEndOffset, patternEndOffset, varEndOffsets, true) != Boolean.TRUE) {
            return elements;
        }
        int varCount = varEndOffsets.length;
        String[] prefixSequence = new String[varCount];
        for (int i3 = 0; i3 < varCount; ++i3) {
            prefixSequence[i3] = applicablePrefixes[0];
        }
        List<PsiElement> finalElements = PatternCompiler.compileByPrefixes(project2, options2, pattern, context2, applicablePrefixes, patterns, prefixSequence, 0, checkForErrors);
        return finalElements != null ? finalElements : PatternCompiler.doCompile(project2, options2, pattern, new ConstantPrefixProvider(applicablePrefixes[0]), context2, checkForErrors);
    }

    @Nullable
    private static List<PsiElement> compileByPrefixes(Project project2, MatchOptions options2, CompiledPattern pattern, CompileContext context2, String[] applicablePrefixes, Pattern[] substitutionPatterns, String[] prefixSequence, int index, boolean checkForErrors) throws MalformedPatternException {
        if (index >= prefixSequence.length) {
            List<PsiElement> elements = PatternCompiler.doCompile(project2, options2, pattern, new ArrayPrefixProvider(prefixSequence), context2, checkForErrors);
            if (elements.isEmpty()) {
                return elements;
            }
            PsiElement parent = elements.get(0).getParent();
            PsiElement last = elements.get(elements.size() - 1);
            int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(parent.getContainingFile(), substitutionPatterns);
            int patternEndOffset = last.getTextRange().getEndOffset();
            return PatternCompiler.checkErrorElements(parent, patternEndOffset, patternEndOffset, varEndOffsets, false) != Boolean.TRUE ? elements : null;
        }
        String[] alternativeVariant = null;
        String[] stringArray = applicablePrefixes;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            List<PsiElement> finalElements;
            int patternEndOffset;
            String applicablePrefix;
            prefixSequence[index] = applicablePrefix = stringArray[j];
            List<PsiElement> elements = PatternCompiler.doCompile(project2, options2, pattern, new ArrayPrefixProvider(prefixSequence), context2, checkForErrors);
            if (elements.isEmpty()) {
                return elements;
            }
            PsiFile file2 = elements.get(0).getContainingFile();
            if (file2 == null) {
                return elements;
            }
            int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(file2, substitutionPatterns);
            int offset = varEndOffsets[index];
            Boolean result2 = PatternCompiler.checkErrorElements((PsiElement)file2, offset, patternEndOffset = elements.get(elements.size() - 1).getTextRange().getEndOffset(), varEndOffsets, false);
            if (result2 == Boolean.TRUE || result2 != Boolean.FALSE && (result2 != null || alternativeVariant != null) || (finalElements = PatternCompiler.compileByPrefixes(project2, options2, pattern, context2, applicablePrefixes, substitutionPatterns, prefixSequence, index + 1, checkForErrors)) == null) continue;
            if (result2 == Boolean.FALSE) {
                return finalElements;
            }
            alternativeVariant = new String[prefixSequence.length];
            System.arraycopy(prefixSequence, 0, alternativeVariant, 0, prefixSequence.length);
        }
        return alternativeVariant != null ? PatternCompiler.compileByPrefixes(project2, options2, pattern, context2, applicablePrefixes, substitutionPatterns, alternativeVariant, index + 1, checkForErrors) : null;
    }

    private static int @NotNull [] findAllTypedVarOffsets(PsiFile file2, final Pattern[] substitutionPatterns) {
        final TIntHashSet result2 = new TIntHashSet();
        file2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                super.visitElement(element);
                if (element instanceof LeafElement) {
                    String text = element.getText();
                    for (Pattern pattern : substitutionPatterns) {
                        Matcher matcher = pattern.matcher(text);
                        while (matcher.find()) {
                            result2.add(element.getTextRange().getStartOffset() + matcher.end());
                        }
                    }
                }
            }
        });
        int[] resultArray = result2.toArray();
        Arrays.sort(resultArray);
        return resultArray;
    }

    @Nullable
    private static Boolean checkErrorElements(PsiElement element, final int offset, final int patternEndOffset, int[] varEndOffsets, final boolean strict) {
        final TIntArrayList errorOffsets = new TIntArrayList();
        final boolean[] containsErrorTail = new boolean[]{false};
        final TIntHashSet varEndOffsetsSet = new TIntHashSet(varEndOffsets);
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                super.visitErrorElement(element);
                int startOffset = element.getTextRange().getStartOffset();
                if ((strict || !varEndOffsetsSet.contains(startOffset)) && startOffset != patternEndOffset) {
                    errorOffsets.add(startOffset);
                }
                if (startOffset == offset) {
                    containsErrorTail[0] = true;
                }
            }
        });
        for (int i2 = 0; i2 < errorOffsets.size(); ++i2) {
            int errorOffset = errorOffsets.get(i2);
            if (errorOffset > offset) continue;
            return true;
        }
        return containsErrorTail[0] ? null : Boolean.valueOf(false);
    }

    private static List<PsiElement> doCompile(Project project2, MatchOptions options2, CompiledPattern result2, PrefixProvider prefixProvider, CompileContext context2, boolean checkForErrors) throws MalformedPatternException {
        GlobalCompilingVisitor compilingVisitor;
        SmartList elements;
        block31: {
            PsiElement[] patternElements;
            MatchVariableConstraint constraint;
            int prevOffset;
            String text;
            StringBuilder buf;
            block30: {
                result2.clearHandlers();
                buf = new StringBuilder();
                Template template = TemplateManager.getInstance((Project)project2).createTemplate("", "", options2.getSearchPattern());
                int segmentsCount = template.getSegmentsCount();
                text = template.getTemplateText();
                prevOffset = 0;
                THashSet variableNames = new THashSet();
                for (int i2 = 0; i2 < segmentsCount; ++i2) {
                    int offset;
                    block29: {
                        offset = template.getSegmentOffset(i2);
                        String name = template.getSegmentName(i2);
                        String prefix = prefixProvider.getPrefix(i2);
                        if (prefix == null) {
                            if (checkForErrors) {
                                throw new MalformedPatternException();
                            }
                            return Collections.emptyList();
                        }
                        PsiElement[] compiledName = prefix + name;
                        buf.append(text, prevOffset, offset).append((String)compiledName);
                        int repeated = !variableNames.add(name) ? 1 : 0;
                        SubstitutionHandler existing = (SubstitutionHandler)result2.getHandler((String)compiledName);
                        if (existing != null) {
                            existing.setRepeatedVar(repeated != 0);
                        } else {
                            try {
                                MatchPredicate predicate;
                                MatchVariableConstraint constraint2 = options2.getVariableConstraint(name);
                                if (constraint2 == null) {
                                    constraint2 = options2.addNewVariableConstraint(name);
                                }
                                SubstitutionHandler handler = result2.createSubstitutionHandler(name, (String)compiledName, constraint2.isPartOfSearchResults(), constraint2.getMinCount(), constraint2.getMaxCount(), constraint2.isGreedy());
                                handler.setRepeatedVar(repeated != 0);
                                if (constraint2.isWithinHierarchy()) {
                                    handler.setSubtype(true);
                                }
                                if (constraint2.isStrictlyWithinHierarchy()) {
                                    handler.setStrictSubtype(true);
                                }
                                if (!StringUtil.isEmptyOrSpaces((String)constraint2.getRegExp())) {
                                    predicate = new RegExpPredicate(constraint2.getRegExp(), options2.isCaseSensitiveMatch(), name, constraint2.isWholeWordsOnly(), constraint2.isPartOfSearchResults());
                                    if (constraint2.isInvertRegExp()) {
                                        predicate = new NotPredicate(predicate);
                                    }
                                    PatternCompiler.addPredicate(handler, predicate);
                                }
                                if (!StringUtil.isEmptyOrSpaces((String)constraint2.getReferenceConstraint())) {
                                    predicate = new ReferencePredicate(constraint2.getReferenceConstraint(), options2.getFileType(), project2);
                                    if (constraint2.isInvertReference()) {
                                        predicate = new NotPredicate(predicate);
                                    }
                                    PatternCompiler.addPredicate(handler, predicate);
                                }
                                PatternCompiler.addExtensionPredicates(options2, constraint2, handler);
                                PatternCompiler.addScriptConstraint(project2, name, constraint2, handler, (Set<String>)variableNames, options2, checkForErrors);
                                if (!StringUtil.isEmptyOrSpaces((String)constraint2.getContainsConstraint())) {
                                    predicate = new ContainsPredicate(name, constraint2.getContainsConstraint());
                                    if (constraint2.isInvertContainsConstraint()) {
                                        predicate = new NotPredicate(predicate);
                                    }
                                    PatternCompiler.addPredicate(handler, predicate);
                                }
                                if (!StringUtil.isEmptyOrSpaces((String)constraint2.getWithinConstraint())) assert (false);
                            }
                            catch (MalformedPatternException e) {
                                if (!checkForErrors) break block29;
                                throw e;
                            }
                        }
                    }
                    prevOffset = offset;
                }
                constraint = options2.getVariableConstraint("__context__");
                if (constraint != null) {
                    SubstitutionHandler handler = result2.createSubstitutionHandler("__context__", "__context__", constraint.isPartOfSearchResults(), constraint.getMinCount(), constraint.getMaxCount(), constraint.isGreedy());
                    try {
                        if (!StringUtil.isEmptyOrSpaces((String)constraint.getWithinConstraint())) {
                            MatchPredicate predicate = new WithinPredicate(constraint.getWithinConstraint(), options2.getFileType(), project2);
                            if (constraint.isInvertWithinConstraint()) {
                                predicate = new NotPredicate(predicate);
                            }
                            PatternCompiler.addPredicate(handler, predicate);
                        }
                        PatternCompiler.addExtensionPredicates(options2, constraint, handler);
                        PatternCompiler.addScriptConstraint(project2, "__context__", constraint, handler, (Set<String>)variableNames, options2, checkForErrors);
                    }
                    catch (MalformedPatternException e) {
                        if (!checkForErrors) break block30;
                        throw e;
                    }
                }
            }
            buf.append(text.substring(prevOffset));
            try {
                PatternContextInfo contextInfo = new PatternContextInfo(PatternTreeContext.Block, options2.getPatternContext(), constraint != null ? constraint.getContextConstraint() : null);
                patternElements = MatcherImplUtil.createTreeFromText(buf.toString(), contextInfo, options2.getFileType(), options2.getDialect(), project2, false);
                if (patternElements.length == 0 && checkForErrors) {
                    throw new MalformedPatternException();
                }
            }
            catch (IncorrectOperationException e) {
                if (checkForErrors) {
                    throw new MalformedPatternException(e.getMessage());
                }
                return Collections.emptyList();
            }
            NodeFilter filter = LexicalNodesFilter.getInstance();
            elements = new SmartList();
            for (PsiElement element : patternElements) {
                if (filter.accepts(element)) continue;
                elements.add(element);
            }
            compilingVisitor = new GlobalCompilingVisitor();
            try {
                compilingVisitor.compile(elements.toArray(PsiElement.EMPTY_ARRAY), context2);
            }
            catch (MalformedPatternException e) {
                if (!checkForErrors) break block31;
                throw e;
            }
        }
        new DeleteNodesAction(compilingVisitor.getLexicalNodes()).run();
        return elements;
    }

    private static void addExtensionPredicates(MatchOptions options2, MatchVariableConstraint constraint, SubstitutionHandler handler) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(options2.getFileType());
        assert (profile != null);
        for (MatchPredicate matchPredicate : profile.getCustomPredicates(constraint, handler.getName(), options2)) {
            PatternCompiler.addPredicate(handler, matchPredicate);
        }
    }

    private static void addScriptConstraint(Project project2, String name, MatchVariableConstraint constraint, SubstitutionHandler handler, Set<String> variableNames, MatchOptions matchOptions, boolean checkForErrors) throws MalformedPatternException {
        String scriptCodeConstraint = constraint.getScriptCodeConstraint();
        if (scriptCodeConstraint.length() > 2) {
            String problem;
            String script = StringUtil.unquoteString((String)scriptCodeConstraint);
            if (checkForErrors && (problem = ScriptSupport.checkValidScript(script, matchOptions)) != null) {
                throw new MalformedPatternException("Script constraint for " + constraint.getName() + " has problem " + problem);
            }
            PatternCompiler.addPredicate(handler, new ScriptPredicate(project2, name, script, variableNames, matchOptions));
        }
    }

    private static void addPredicate(SubstitutionHandler handler, @NotNull MatchPredicate predicate) {
        handler.setPredicate(handler.getPredicate() == null ? predicate : new AndPredicate(handler.getPredicate(), predicate));
    }

    private static class ArrayPrefixProvider
    implements PrefixProvider {
        private final String[] myPrefixes;

        ArrayPrefixProvider(String @NotNull [] prefixes) {
            this.myPrefixes = prefixes;
        }

        @Override
        public String getPrefix(int varIndex) {
            if (varIndex >= this.myPrefixes.length) {
                return null;
            }
            return this.myPrefixes[varIndex];
        }
    }

    private static class ConstantPrefixProvider
    implements PrefixProvider {
        private final String myPrefix;

        ConstantPrefixProvider(@NotNull String prefix) {
            this.myPrefix = prefix;
        }

        @Override
        @NotNull
        public String getPrefix(int varIndex) {
            return this.myPrefix;
        }
    }

    private static interface PrefixProvider {
        public String getPrefix(int var1);
    }
}

