/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelperBase;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class FindInFilesOptimizingSearchHelper
extends OptimizingSearchHelperBase {
    private THashSet<VirtualFile> filesToScan;
    private THashSet<VirtualFile> filesToScan2;
    private final Project myProject;
    private final SearchScope myScope;
    private final boolean myCaseSensitive;
    private boolean myTransactionStarted = false;

    FindInFilesOptimizingSearchHelper(SearchScope scope, boolean caseSensitive, Project project2) {
        this.myScope = scope;
        this.myCaseSensitive = caseSensitive;
        this.myProject = project2;
        if (scope instanceof GlobalSearchScope && this.filesToScan == null) {
            this.filesToScan = new THashSet();
            this.filesToScan2 = new THashSet();
        }
    }

    @Override
    public boolean doOptimizing() {
        return this.myScope instanceof GlobalSearchScope;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.filesToScan != null) {
            this.filesToScan.clear();
            this.filesToScan2.clear();
        }
    }

    @Override
    protected void doAddSearchWordInCode(@NotNull String word) {
        this.myTransactionStarted = true;
        VirtualFile[] files = CacheManager.getInstance((Project)this.myProject).getVirtualFilesWithWord(word, (short)17, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
        this.process(files);
    }

    @Override
    protected void doAddSearchWordInText(@NotNull String word) {
        this.myTransactionStarted = true;
        VirtualFile[] files = CacheManager.getInstance((Project)this.myProject).getVirtualFilesWithWord(word, (short)16, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
        this.process(files);
    }

    @Override
    protected void doAddSearchWordInComments(@NotNull String word) {
        this.myTransactionStarted = true;
        VirtualFile[] files = CacheManager.getInstance((Project)this.myProject).getVirtualFilesWithWord(word, (short)2, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
        this.process(files);
    }

    @Override
    protected void doAddSearchWordInLiterals(@NotNull String word) {
        this.myTransactionStarted = true;
        VirtualFile[] files = CacheManager.getInstance((Project)this.myProject).getVirtualFilesWithWord(word, (short)4, (GlobalSearchScope)this.myScope, this.myCaseSensitive);
        this.process(files);
    }

    @Override
    public void endTransaction() {
        if (!this.myTransactionStarted) {
            return;
        }
        this.myTransactionStarted = false;
        super.endTransaction();
        THashSet<VirtualFile> map2 = this.filesToScan;
        if (!map2.isEmpty()) {
            map2.clear();
        }
        this.filesToScan = this.filesToScan2;
        this.filesToScan2 = map2;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getFilesSetToScan() {
        assert (!this.myTransactionStarted);
        if (this.filesToScan == null) {
            return Collections.emptySet();
        }
        return this.filesToScan;
    }

    private void process(VirtualFile[] files) {
        if (this.scanRequest == 0) {
            Collections.addAll(this.filesToScan2, files);
        } else {
            for (VirtualFile file2 : files) {
                if (!this.filesToScan.contains((Object)file2)) continue;
                this.filesToScan2.add((Object)file2);
            }
        }
    }
}

