/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;

public final class MatcherImplUtil {
    public static PsiElement[] createTreeFromText(String text, PatternTreeContext context2, LanguageFileType fileType, Project project2) {
        return MatcherImplUtil.createTreeFromText(text, new PatternContextInfo(context2), fileType, null, project2, false);
    }

    public static PsiElement[] createSourceTreeFromText(String text, PatternTreeContext context2, LanguageFileType fileType, Project project2, boolean physical) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByLanguage(fileType.getLanguage());
        if (profile != null) {
            return profile.createPatternTree(text, context2, fileType, fileType.getLanguage(), null, project2, physical);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public static PsiElement[] createTreeFromText(String text, PatternContextInfo contextInfo, LanguageFileType fileType, Language language, Project project2, boolean physical) {
        StructuralSearchProfile profile;
        if (language == null) {
            language = fileType.getLanguage();
        }
        if ((profile = StructuralSearchUtil.getProfileByLanguage(language)) != null) {
            return profile.createPatternTree(text, contextInfo, fileType, language, project2, physical);
        }
        return PsiElement.EMPTY_ARRAY;
    }
}

