/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;

public final class MatchResultImpl
extends MatchResult {
    private String name;
    private SmartPsiPointer matchRef;
    private int start;
    private int end = -1;
    private String matchImage;
    private final List<MatchResult> myChildren = new SmartList();
    private boolean target;
    private boolean myScopeMatch;
    private boolean myMultipleMatch;
    private MatchResultImpl parent = null;

    MatchResultImpl() {
    }

    public MatchResultImpl(String name, String image, SmartPsiPointer ref, boolean target) {
        this(name, image, ref, 0, -1, target);
    }

    public MatchResultImpl(String name, String image, SmartPsiPointer ref, int start, int end, boolean target) {
        this.matchRef = ref;
        this.name = name;
        this.matchImage = image;
        this.target = target;
        this.start = start;
        this.end = end;
    }

    @Override
    public String getMatchImage() {
        return this.matchImage;
    }

    @Override
    public SmartPsiPointer getMatchRef() {
        return this.matchRef;
    }

    @Override
    public PsiElement getMatch() {
        if (this.matchRef == null) {
            return null;
        }
        return this.matchRef.getElement();
    }

    public void setMatchRef(SmartPsiPointer matchStart) {
        this.matchRef = matchStart;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<MatchResult> getChildren() {
        return Collections.unmodifiableList(this.myChildren);
    }

    @Override
    public int size() {
        if (!this.myMultipleMatch) {
            return this.getMatch() != null ? 1 : 0;
        }
        return this.myChildren.size();
    }

    @Override
    public boolean isScopeMatch() {
        return this.myScopeMatch;
    }

    @Override
    public boolean isMultipleMatch() {
        return this.myMultipleMatch;
    }

    public void clear() {
        if (this.matchRef != null) {
            this.matchRef.clear();
            this.matchRef = null;
        }
        for (MatchResult match : this.myChildren) {
            ((MatchResultImpl)match).clear();
        }
        this.myChildren.clear();
        this.name = null;
        this.matchImage = null;
    }

    @Override
    public boolean hasChildren() {
        return !this.myChildren.isEmpty();
    }

    public void removeChildren() {
        this.myChildren.clear();
    }

    public MatchResult removeLastChild() {
        return this.myChildren.remove(this.myChildren.size() - 1);
    }

    public void setScopeMatch(boolean scopeMatch) {
        this.myScopeMatch = scopeMatch;
    }

    public void setMultipleMatch(boolean multipleMatch) {
        this.myMultipleMatch = multipleMatch;
    }

    public MatchResultImpl findChild(String name) {
        for (MatchResult match : this.myChildren) {
            MatchResultImpl res = (MatchResultImpl)match;
            if (!name.equals(res.getName())) continue;
            return res;
        }
        return null;
    }

    public static MatchResultImpl findChildDeep(MatchResult match, String name) {
        for (MatchResult child : match.getChildren()) {
            if (name.equals(child.getName())) {
                return (MatchResultImpl)child;
            }
            MatchResultImpl deep = MatchResultImpl.findChildDeep(child, name);
            if (deep == null) continue;
            return deep;
        }
        return null;
    }

    public MatchResult removeChild(String typedVar) {
        int size = this.myChildren.size();
        for (int i2 = 0; i2 < size; ++i2) {
            MatchResult child = this.myChildren.get(i2);
            if (!typedVar.equals(child.getName())) continue;
            this.myChildren.remove(i2);
            return child;
        }
        return null;
    }

    public void addChild(MatchResult result2) {
        if (result2 instanceof MatchResultImpl) {
            ((MatchResultImpl)result2).parent = this;
        }
        this.myChildren.add(result2);
    }

    @Override
    public MatchResult getRoot() {
        if (this.parent == null) {
            return this;
        }
        MatchResultImpl root = this.parent;
        while (root.parent != null) {
            root = root.parent;
        }
        return root;
    }

    public void setMatchImage(String matchImage) {
        this.matchImage = matchImage;
    }

    @Override
    public boolean isTarget() {
        return this.target;
    }

    public void setTarget(boolean target) {
        this.target = target;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String toString() {
        return "MatchResultImpl{name='" + this.name + '\'' + ", matchImage='" + this.matchImage + '\'' + "}";
    }
}

