/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.Scopes;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.compiler.StringToConstraintsTransformer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatchOptions
implements JDOMExternalizable {
    private final Map<String, MatchVariableConstraint> variableConstraints;
    private boolean looseMatching;
    private boolean recursiveSearch;
    private boolean caseSensitiveMatch;
    private LanguageFileType myFileType;
    private Language myDialect;
    private SearchScope scope;
    private Scopes.Type scopeType;
    private String scopeDescriptor;
    @NotNull
    private String pattern;
    private String myPatternContextId;
    @NonNls
    private static final String TEXT_ATTRIBUTE_NAME = "text";
    @NonNls
    private static final String LOOSE_MATCHING_ATTRIBUTE_NAME = "loose";
    @NonNls
    private static final String RECURSIVE_ATTRIBUTE_NAME = "recursive";
    @NonNls
    private static final String CASESENSITIVE_ATTRIBUTE_NAME = "caseInsensitive";
    @NonNls
    private static final String CONSTRAINT_TAG_NAME = "constraint";
    @NonNls
    private static final String FILE_TYPE_ATTR_NAME = "type";
    @NonNls
    private static final String DIALECT_ATTR_NAME = "dialect";
    @NonNls
    private static final String PATTERN_CONTEXT_ATTR_NAME = "pattern_context";
    @NonNls
    private static final String SCOPE_TYPE = "scope_type";
    @NonNls
    private static final String SCOPE_DESCRIPTOR = "scope_descriptor";
    @NonNls
    public static final String INSTANCE_MODIFIER_NAME = "Instance";
    @NonNls
    public static final String MODIFIER_ANNOTATION_NAME = "Modifier";

    public MatchOptions() {
        this.variableConstraints = new LinkedHashMap<String, MatchVariableConstraint>();
        this.looseMatching = true;
        this.pattern = "";
    }

    MatchOptions(MatchOptions options2) {
        this.variableConstraints = new LinkedHashMap<String, MatchVariableConstraint>(options2.variableConstraints.size());
        options2.variableConstraints.forEach((key, value) -> this.variableConstraints.put((String)key, value.copy()));
        this.looseMatching = options2.looseMatching;
        this.recursiveSearch = options2.recursiveSearch;
        this.caseSensitiveMatch = options2.caseSensitiveMatch;
        this.myFileType = options2.myFileType;
        this.myDialect = options2.myDialect;
        this.scope = options2.scope;
        this.scopeType = options2.scopeType;
        this.scopeDescriptor = options2.scopeDescriptor;
        this.pattern = options2.pattern;
        this.myPatternContextId = options2.myPatternContextId;
    }

    public MatchOptions copy() {
        return new MatchOptions(this);
    }

    public void initScope(Project project2) {
        if (this.scope == null && this.scopeType != null && this.scopeDescriptor != null) {
            this.scope = Scopes.createScope(project2, this.scopeDescriptor, this.scopeType);
        }
    }

    public void addVariableConstraint(@NotNull MatchVariableConstraint constraint) {
        this.variableConstraints.put(constraint.getName(), constraint);
    }

    public MatchVariableConstraint addNewVariableConstraint(@NotNull String name) {
        MatchVariableConstraint constraint = new MatchVariableConstraint(name);
        this.variableConstraints.put(name, constraint);
        return constraint;
    }

    public Set<String> getUsedVariableNames() {
        LinkedHashSet set = TemplateImplUtil.parseVariableNames((CharSequence)this.pattern);
        set.add("__context__");
        return set;
    }

    public void removeUnusedVariables() {
        this.variableConstraints.keySet().removeIf(key -> !this.getUsedVariableNames().contains(key));
    }

    public MatchVariableConstraint getVariableConstraint(String name) {
        return this.variableConstraints.get(name);
    }

    public Set<String> getVariableConstraintNames() {
        return Collections.unmodifiableSet(this.variableConstraints.keySet());
    }

    public void setCaseSensitiveMatch(boolean caseSensitiveMatch) {
        this.caseSensitiveMatch = caseSensitiveMatch;
    }

    public boolean isCaseSensitiveMatch() {
        return this.caseSensitiveMatch;
    }

    public String toString() {
        return "match options:\npattern:\n" + this.pattern + "\nscope:\n" + (this.scope != null ? this.scope.toString() : "undefined scope") + "\nrecursive: " + this.recursiveSearch + "\ncase sensitive: " + this.caseSensitiveMatch + "\nloose: " + this.looseMatching;
    }

    public boolean isRecursiveSearch() {
        return this.recursiveSearch;
    }

    public void setRecursiveSearch(boolean recursiveSearch) {
        this.recursiveSearch = recursiveSearch;
    }

    public boolean isLooseMatching() {
        return this.looseMatching;
    }

    public void setLooseMatching(boolean looseMatching) {
        this.looseMatching = looseMatching;
    }

    public void setSearchPattern(@NotNull String text) {
        this.pattern = text;
    }

    @NotNull
    public String getSearchPattern() {
        return this.pattern;
    }

    public void fillSearchCriteria(String criteria) {
        if (!this.variableConstraints.isEmpty()) {
            this.variableConstraints.clear();
        }
        StringToConstraintsTransformer.transformCriteria(criteria, this);
    }

    @Nullable
    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scopeType = null;
        this.scopeDescriptor = null;
        this.scope = scope;
    }

    public void writeExternal(Element element) {
        element.setAttribute(TEXT_ATTRIBUTE_NAME, this.pattern);
        if (!this.looseMatching) {
            element.setAttribute(LOOSE_MATCHING_ATTRIBUTE_NAME, String.valueOf(false));
        }
        element.setAttribute(RECURSIVE_ATTRIBUTE_NAME, String.valueOf(this.recursiveSearch));
        element.setAttribute(CASESENSITIVE_ATTRIBUTE_NAME, String.valueOf(this.caseSensitiveMatch));
        if (this.myFileType != null) {
            element.setAttribute(FILE_TYPE_ATTR_NAME, this.myFileType.getName());
        }
        if (this.myDialect != null && (this.myFileType == null || this.myFileType.getLanguage() != this.myDialect)) {
            element.setAttribute(DIALECT_ATTR_NAME, this.myDialect.getID());
        }
        if (this.myPatternContextId != null) {
            element.setAttribute(PATTERN_CONTEXT_ATTR_NAME, this.myPatternContextId);
        }
        if (this.scope != null) {
            element.setAttribute(SCOPE_TYPE, Scopes.getType(this.scope).toString()).setAttribute(SCOPE_DESCRIPTOR, Scopes.getDescriptor(this.scope));
        }
        Set<String> constraintNames = this.getUsedVariableNames();
        for (MatchVariableConstraint matchVariableConstraint : this.variableConstraints.values()) {
            if (!constraintNames.contains(matchVariableConstraint.getName())) continue;
            Element infoElement = new Element(CONSTRAINT_TAG_NAME);
            element.addContent(infoElement);
            matchVariableConstraint.writeExternal(infoElement);
        }
    }

    public void readExternal(Element element) {
        this.pattern = StringUtil.notNullize((String)element.getAttributeValue(TEXT_ATTRIBUTE_NAME));
        this.looseMatching = MatchVariableConstraint.getBooleanValue(element, LOOSE_MATCHING_ATTRIBUTE_NAME, true);
        this.recursiveSearch = MatchVariableConstraint.getBooleanValue(element, RECURSIVE_ATTRIBUTE_NAME, false);
        this.caseSensitiveMatch = MatchVariableConstraint.getBooleanValue(element, CASESENSITIVE_ATTRIBUTE_NAME, false);
        this.myFileType = MatchOptions.getFileTypeByName(element.getAttributeValue(FILE_TYPE_ATTR_NAME));
        this.myDialect = Language.findLanguageByID((String)element.getAttributeValue(DIALECT_ATTR_NAME));
        this.myPatternContextId = element.getAttributeValue(PATTERN_CONTEXT_ATTR_NAME);
        String value = element.getAttributeValue(SCOPE_TYPE);
        this.scopeType = value == null ? null : Scopes.Type.valueOf(value);
        this.scopeDescriptor = element.getAttributeValue(SCOPE_DESCRIPTOR);
        for (Element element1 : element.getChildren(CONSTRAINT_TAG_NAME)) {
            MatchVariableConstraint constraint = new MatchVariableConstraint();
            constraint.readExternal(element1);
            this.addVariableConstraint(constraint);
        }
    }

    private static LanguageFileType getFileTypeByName(String value) {
        if (value != null) {
            for (LanguageFileType type : StructuralSearchUtil.getSuitableFileTypes()) {
                if (!value.equals(type.getName())) continue;
                return type;
            }
        }
        return StructuralSearchUtil.getDefaultFileType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchOptions)) {
            return false;
        }
        MatchOptions matchOptions = (MatchOptions)o;
        if (this.caseSensitiveMatch != matchOptions.caseSensitiveMatch) {
            return false;
        }
        if (this.looseMatching != matchOptions.looseMatching) {
            return false;
        }
        if (this.recursiveSearch != matchOptions.recursiveSearch) {
            return false;
        }
        if (!Objects.equals(this.scope, matchOptions.scope)) {
            return false;
        }
        if (!this.pattern.equals(matchOptions.pattern)) {
            return false;
        }
        if (!this.variableConstraints.equals(matchOptions.variableConstraints)) {
            return false;
        }
        if (this.myFileType != matchOptions.myFileType) {
            return false;
        }
        if (!Objects.equals(this.getDialect(), matchOptions.getDialect())) {
            return false;
        }
        return Objects.equals(this.myPatternContextId, matchOptions.myPatternContextId);
    }

    public int hashCode() {
        int result2 = this.looseMatching ? 1 : 0;
        result2 = 29 * result2 + (this.recursiveSearch ? 1 : 0);
        result2 = 29 * result2 + (this.caseSensitiveMatch ? 1 : 0);
        result2 = 29 * result2 + this.pattern.hashCode();
        result2 = 29 * result2 + this.variableConstraints.hashCode();
        if (this.scope != null) {
            result2 = 29 * result2 + this.scope.hashCode();
        }
        if (this.myFileType != null) {
            result2 = 29 * result2 + this.myFileType.hashCode();
        }
        if (this.myDialect != null) {
            result2 = 29 * result2 + this.myDialect.hashCode();
        }
        if (this.myPatternContextId != null) {
            result2 = 29 * result2 + this.myPatternContextId.hashCode();
        }
        return result2;
    }

    public void setFileType(LanguageFileType fileType) {
        this.myFileType = fileType;
    }

    @NotNull
    public LanguageFileType getFileType() {
        if (this.myFileType == null) {
            this.myFileType = StructuralSearchUtil.getDefaultFileType();
        }
        return this.myFileType;
    }

    @NotNull
    public Language getDialect() {
        if (this.myDialect == null) {
            return this.getFileType().getLanguage();
        }
        return this.myDialect;
    }

    public void setDialect(Language dialect) {
        this.myDialect = dialect;
    }

    public PatternContext getPatternContext() {
        return StructuralSearchUtil.findPatternContextByID(this.myPatternContextId, this.getDialect());
    }

    public void setPatternContext(PatternContext patternContext) {
        this.myPatternContextId = patternContext == null ? null : patternContext.getId();
    }
}

